/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.RouteWithTrack;

public class RoutingPlan {
    private static final RoutingPlan EMPTY = new RoutingPlan("", null, Collections.emptyList());
    private final String distance;
    private final Location depot;
    private final List<RouteWithTrack> routes;

    public RoutingPlan(String distance, Location depot, List<RouteWithTrack> routes) {
        this.distance = Objects.requireNonNull(distance);
        this.depot = depot;
        this.routes = new ArrayList(Objects.requireNonNull(routes));
        if (depot == null && !routes.isEmpty()) {
            throw new IllegalArgumentException("Routes must be empty when depot is null.");
        }
    }

    public static RoutingPlan empty() {
        return EMPTY;
    }

    public String distance() {
        return this.distance;
    }

    public List<RouteWithTrack> routes() {
        return Collections.unmodifiableList(this.routes);
    }

    public Optional<Location> depot() {
        return Optional.ofNullable(this.depot);
    }
}

