/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Depot;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.RoadLocation;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.service.route.ShallowRoute;

/*
 * Exception performing whole class analysis ignored.
 */
public class SolutionUtil {
    public static final int DEFAULT_CUSTOMER_DEMAND = 1;
    static final int DEFAULT_VEHICLE_CAPACITY = 10;

    private SolutionUtil() {
        throw new AssertionError((Object)"Utility class");
    }

    public static VehicleRoutingSolution emptySolution() {
        VehicleRoutingSolution solution = new VehicleRoutingSolution();
        solution.setLocationList(new ArrayList());
        solution.setCustomerList(new ArrayList());
        solution.setDepotList(new ArrayList());
        solution.setVehicleList(new ArrayList());
        solution.setScore(HardSoftLongScore.ZERO);
        solution.setDistanceUnitOfMeasurement("sec");
        return solution;
    }

    static VehicleRoutingSolution initialSolution() {
        VehicleRoutingSolution solution = SolutionUtil.emptySolution();
        SolutionUtil.addVehicle((VehicleRoutingSolution)solution, (long)1L, (int)10);
        SolutionUtil.addVehicle((VehicleRoutingSolution)solution, (long)2L, (int)10);
        SolutionUtil.addVehicle((VehicleRoutingSolution)solution, (long)3L, (int)10);
        SolutionUtil.addVehicle((VehicleRoutingSolution)solution, (long)4L, (int)10);
        SolutionUtil.addVehicle((VehicleRoutingSolution)solution, (long)5L, (int)10);
        SolutionUtil.addVehicle((VehicleRoutingSolution)solution, (long)6L, (int)10);
        return solution;
    }

    static Vehicle addVehicle(VehicleRoutingSolution solution, long id) {
        return SolutionUtil.addVehicle((VehicleRoutingSolution)solution, (long)id, (int)0);
    }

    private static Vehicle addVehicle(VehicleRoutingSolution solution, long id, int capacity) {
        Vehicle vehicle = new Vehicle();
        vehicle.setId(Long.valueOf(id));
        vehicle.setCapacity(capacity);
        solution.getVehicleList().add(vehicle);
        return vehicle;
    }

    static List<ShallowRoute> routes(VehicleRoutingSolution solution) {
        if (solution.getDepotList().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ShallowRoute> routes = new ArrayList<ShallowRoute>();
        for (Vehicle vehicle : solution.getVehicleList()) {
            Depot depot = vehicle.getDepot();
            if (depot == null) {
                throw new IllegalStateException("Vehicle (id=" + vehicle.getId() + ") is not in the depot. That's not allowed");
            }
            ArrayList<Long> visits = new ArrayList<Long>();
            for (Customer customer = vehicle.getNextCustomer(); customer != null; customer = customer.getNextCustomer()) {
                if (!solution.getCustomerList().contains(customer)) {
                    throw new IllegalStateException("Customer (" + customer + ") doesn't exist");
                }
                visits.add(customer.getLocation().getId());
            }
            routes.add(new ShallowRoute(depot.getId(), visits));
        }
        return routes;
    }

    static RoadLocation planningLocation(Location location) {
        return new RoadLocation(location.id(), location.coordinates().latitude().doubleValue(), location.coordinates().longitude().doubleValue());
    }

    static Long depot(VehicleRoutingSolution solution) {
        return solution.getDepotList().isEmpty() ? null : ((Depot)solution.getDepotList().get(0)).getId();
    }

    static Depot addDepot(VehicleRoutingSolution solution, org.optaplanner.examples.vehiclerouting.domain.location.Location location) {
        Depot depot = new Depot();
        depot.setId(location.getId());
        depot.setLocation(location);
        solution.getDepotList().add(depot);
        solution.getLocationList().add(location);
        return depot;
    }

    static Customer addCustomer(VehicleRoutingSolution solution, org.optaplanner.examples.vehiclerouting.domain.location.Location location) {
        return SolutionUtil.addCustomer((VehicleRoutingSolution)solution, (org.optaplanner.examples.vehiclerouting.domain.location.Location)location, (int)0);
    }

    static Customer addCustomer(VehicleRoutingSolution solution, org.optaplanner.examples.vehiclerouting.domain.location.Location location, int demand) {
        Customer customer = new Customer();
        customer.setId(location.getId());
        customer.setLocation(location);
        customer.setDemand(demand);
        solution.getCustomerList().add(customer);
        solution.getLocationList().add(location);
        return customer;
    }

    static void moveAllVehiclesTo(VehicleRoutingSolution solution, Depot depot) {
        solution.getVehicleList().forEach(vehicle -> vehicle.setDepot(depot));
    }
}

