/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.change;

import java.util.ArrayList;
import java.util.Objects;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;

public class AddCustomer
implements ProblemFactChange<VehicleRoutingSolution> {
    private final Location location;

    public AddCustomer(Location location) {
        this.location = Objects.requireNonNull(location);
    }

    public void doChange(ScoreDirector<VehicleRoutingSolution> scoreDirector) {
        VehicleRoutingSolution workingSolution = (VehicleRoutingSolution)scoreDirector.getWorkingSolution();
        workingSolution.setLocationList(new ArrayList(workingSolution.getLocationList()));
        scoreDirector.beforeProblemFactAdded((Object)this.location);
        workingSolution.getLocationList().add(this.location);
        scoreDirector.afterProblemFactAdded((Object)this.location);
        Customer customer = new Customer();
        customer.setId(this.location.getId());
        customer.setLocation(this.location);
        customer.setDemand(1);
        scoreDirector.beforeEntityAdded((Object)customer);
        workingSolution.getCustomerList().add(customer);
        scoreDirector.afterEntityAdded((Object)customer);
        scoreDirector.triggerVariableListeners();
    }
}

