/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.change;

import java.util.Objects;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;

public class RemoveCustomer
implements ProblemFactChange<VehicleRoutingSolution> {
    private final Location location;

    public RemoveCustomer(Location location) {
        this.location = Objects.requireNonNull(location);
    }

    public void doChange(ScoreDirector<VehicleRoutingSolution> scoreDirector) {
        VehicleRoutingSolution workingSolution = (VehicleRoutingSolution)scoreDirector.getWorkingSolution();
        Customer customer = workingSolution.getCustomerList().stream().filter(v -> v.getLocation().getId().equals(this.location.getId())).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid request for removing customer at " + this.location));
        for (Customer nextCustomer : workingSolution.getCustomerList()) {
            if (!nextCustomer.getPreviousStandstill().equals(customer)) continue;
            scoreDirector.beforeVariableChanged((Object)nextCustomer, "previousStandstill");
            nextCustomer.setPreviousStandstill(customer.getPreviousStandstill());
            scoreDirector.afterVariableChanged((Object)nextCustomer, "previousStandstill");
            break;
        }
        scoreDirector.beforeEntityRemoved((Object)customer);
        if (!workingSolution.getCustomerList().remove(customer)) {
            throw new IllegalStateException("This is impossible.");
        }
        scoreDirector.afterEntityRemoved((Object)customer);
        scoreDirector.triggerVariableListeners();
    }
}

