/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.routing;

import com.graphhopper.reader.osm.GraphHopperOSM;
import com.graphhopper.routing.util.EncodingManager;
import java.io.File;
import org.optaweb.vehiclerouting.plugin.routing.RoutingProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
class RoutingConfig {
    private static final Logger logger = LoggerFactory.getLogger(RoutingConfig.class);
    private static final String OSM_DIR = "local/openstreetmap/";
    private static final String GH_DIR = "local/graphhopper/";
    private final RoutingProperties routingProperties;

    @Autowired
    RoutingConfig(RoutingProperties routingProperties) {
        this.routingProperties = routingProperties;
    }

    @Profile(value={"!test"})
    @Bean
    GraphHopperOSM graphHopper() {
        GraphHopperOSM graphHopper = (GraphHopperOSM)new GraphHopperOSM().forServer();
        String osmPath = OSM_DIR + this.routingProperties.getOsmFile();
        logger.info("OSM file: {}", (Object)osmPath);
        if (!new File(osmPath).exists()) {
            throw new IllegalStateException("The osmPath (" + new File(osmPath).getAbsolutePath() + ") does not exist.\nDownload the osm file from http://download.geofabrik.de/ first.");
        }
        graphHopper.setOSMFile(osmPath);
        graphHopper.setGraphHopperLocation(GH_DIR + osmPath.replaceFirst(".*/(.*)\\.osm\\.pbf$", "$1"));
        graphHopper.setEncodingManager(new EncodingManager("car"));
        logger.info("GraphHopper loading...");
        graphHopper.importOrLoad();
        logger.info("GraphHopper loaded.");
        return graphHopper;
    }
}

