/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.websocket;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.RoutingPlan;
import org.optaweb.vehiclerouting.plugin.websocket.PortableCoordinates;
import org.optaweb.vehiclerouting.plugin.websocket.PortableLocation;
import org.optaweb.vehiclerouting.plugin.websocket.PortableRoute;
import org.optaweb.vehiclerouting.plugin.websocket.PortableRoutingPlan;
import org.optaweb.vehiclerouting.service.route.RoutePublisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
class RoutePublisherImpl
implements RoutePublisher {
    private final SimpMessagingTemplate webSocket;

    @Autowired
    RoutePublisherImpl(SimpMessagingTemplate webSocket) {
        this.webSocket = webSocket;
    }

    public void publish(RoutingPlan routingPlan) {
        this.webSocket.convertAndSend((Object)"/topic/route", (Object)RoutePublisherImpl.portable((RoutingPlan)routingPlan));
    }

    static PortableRoutingPlan portable(RoutingPlan routingPlan) {
        PortableLocation depot = routingPlan.depot().map(PortableLocation::fromLocation).orElse(null);
        List routes = routingPlan.routes().stream().map(routeWithTrack -> new PortableRoute(depot, RoutePublisherImpl.portableVisits((List)routeWithTrack.visits()), RoutePublisherImpl.portableTrack((List)routeWithTrack.track()))).collect(Collectors.toList());
        return new PortableRoutingPlan(routingPlan.distance(), depot, routes);
    }

    private static List<List<PortableCoordinates>> portableTrack(List<List<Coordinates>> track) {
        ArrayList<List<PortableCoordinates>> portableTrack = new ArrayList<List<PortableCoordinates>>();
        for (List<Coordinates> segment : track) {
            List portableSegment = segment.stream().map(PortableCoordinates::fromCoordinates).collect(Collectors.toList());
            portableTrack.add(portableSegment);
        }
        return portableTrack;
    }

    private static List<PortableLocation> portableVisits(List<Location> visits) {
        return visits.stream().map(PortableLocation::fromLocation).collect(Collectors.toList());
    }
}

