/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.demo;

import java.util.ArrayList;
import java.util.Collection;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.LocationData;
import org.optaweb.vehiclerouting.domain.RoutingProblem;
import org.optaweb.vehiclerouting.service.demo.RoutingProblemList;
import org.optaweb.vehiclerouting.service.demo.dataset.DataSetMarshaller;
import org.optaweb.vehiclerouting.service.location.LocationRepository;
import org.optaweb.vehiclerouting.service.location.LocationService;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class DemoService {
    static final int MAX_TRIES = 10;
    private final LocationService locationService;
    private final DataSetMarshaller dataSetMarshaller;
    private final LocationRepository locationRepository;
    private final RoutingProblemList routingProblems;

    DemoService(LocationService locationService, DataSetMarshaller dataSetMarshaller, LocationRepository locationRepository, RoutingProblemList routingProblems) {
        this.locationService = locationService;
        this.dataSetMarshaller = dataSetMarshaller;
        this.locationRepository = locationRepository;
        this.routingProblems = routingProblems;
    }

    public Collection<RoutingProblem> demos() {
        return this.routingProblems.all();
    }

    @Async
    public void loadDemo(String name) {
        RoutingProblem routingProblem = this.routingProblems.byName(name);
        routingProblem.depot().ifPresent(depot -> this.addWithRetry(depot.coordinates(), depot.description()));
        routingProblem.visits().forEach(visit -> this.addWithRetry(visit.coordinates(), visit.description()));
    }

    private void addWithRetry(Coordinates coordinates, String description) {
        int tries;
        for (tries = 0; tries < 10 && !this.locationService.createLocation(coordinates, description); ++tries) {
        }
        if (tries == 10) {
            throw new RuntimeException("Impossible to create a new location near " + coordinates + " after " + tries + " attempts");
        }
    }

    public String exportDataSet() {
        ArrayList visits = new ArrayList(this.locationRepository.locations());
        Location depot = visits.isEmpty() ? null : (Location)visits.remove(0);
        return this.dataSetMarshaller.marshal(new RoutingProblem("Custom Vehicle Routing instance", (LocationData)depot, visits));
    }
}

