/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.location;

import java.util.Objects;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.service.location.DistanceMatrix;
import org.optaweb.vehiclerouting.service.location.LocationRepository;
import org.optaweb.vehiclerouting.service.location.RouteOptimizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class LocationService {
    private static final Logger logger = LoggerFactory.getLogger(LocationService.class);
    private final LocationRepository repository;
    private final RouteOptimizer optimizer;
    private final DistanceMatrix distanceMatrix;

    LocationService(LocationRepository repository, RouteOptimizer optimizer, DistanceMatrix distanceMatrix) {
        this.repository = repository;
        this.optimizer = optimizer;
        this.distanceMatrix = distanceMatrix;
    }

    @EventListener
    public synchronized void reload(ApplicationStartedEvent event) {
        this.repository.locations().forEach(arg_0 -> this.submitToPlanner(arg_0));
    }

    public synchronized boolean createLocation(Coordinates coordinates, String description) {
        Objects.requireNonNull(coordinates);
        Objects.requireNonNull(description);
        return this.submitToPlanner(this.repository.createLocation(coordinates, description));
    }

    private boolean submitToPlanner(Location location) {
        try {
            this.distanceMatrix.addLocation(location);
        }
        catch (Exception e) {
            logger.warn("Failed to calculate distances for {}, it will be discarded", (Object)location);
            logger.debug("Details:", (Throwable)e);
            this.repository.removeLocation(location.id());
            return false;
        }
        this.optimizer.addLocation(location, this.distanceMatrix);
        return true;
    }

    public synchronized void removeLocation(long id) {
        Location location = this.repository.removeLocation(id);
        this.optimizer.removeLocation(location);
    }

    public synchronized void clear() {
        this.optimizer.clear();
        this.repository.removeAll();
        this.distanceMatrix.clear();
    }
}

