/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.route;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.optaweb.vehiclerouting.service.route.ShallowRoute;
import org.springframework.context.ApplicationEvent;

public class RouteChangedEvent
extends ApplicationEvent {
    private final String distance;
    private final Long depotId;
    private final Collection<ShallowRoute> routes;

    public RouteChangedEvent(Object source, String distance, Long depotId, Collection<ShallowRoute> routes) {
        super(source);
        this.distance = Objects.requireNonNull(distance);
        this.depotId = depotId;
        this.routes = Objects.requireNonNull(routes);
    }

    public Collection<ShallowRoute> routes() {
        return this.routes;
    }

    public String distance() {
        return this.distance;
    }

    public Optional<Long> depot() {
        return Optional.ofNullable(this.depotId);
    }
}

