/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.Route;
import org.optaweb.vehiclerouting.domain.RouteWithTrack;
import org.optaweb.vehiclerouting.domain.RoutingPlan;
import org.optaweb.vehiclerouting.domain.Vehicle;
import org.optaweb.vehiclerouting.domain.VehicleFactory;

class RoutingPlanTest {
    private final Vehicle vehicle = VehicleFactory.testVehicle((long)1L);
    private final List<Vehicle> vehicles = Collections.singletonList(this.vehicle);
    private final Location depot = new Location(1L, Coordinates.valueOf((double)5.0, (double)5.0));
    private final Location visit = new Location(2L, Coordinates.valueOf((double)3.0, (double)3.0));
    private final RouteWithTrack emptyRoute = new RouteWithTrack(new Route(this.vehicle, this.depot, Collections.emptyList()), Collections.emptyList());
    private final List<List<Coordinates>> nonEmptyTrack = Collections.singletonList(Collections.singletonList(Coordinates.valueOf((double)5.0, (double)5.0)));

    RoutingPlanTest() {
    }

    @Test
    void constructor_args_not_null() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> new RoutingPlan(null, this.vehicles, this.depot, Collections.emptyList(), Collections.emptyList()));
        Assertions.assertThatNullPointerException().isThrownBy(() -> new RoutingPlan("", null, this.depot, Collections.emptyList(), Collections.emptyList()));
        Assertions.assertThatNullPointerException().isThrownBy(() -> new RoutingPlan("", this.vehicles, this.depot, null, Collections.emptyList()));
        Assertions.assertThatNullPointerException().isThrownBy(() -> new RoutingPlan("", this.vehicles, this.depot, Collections.emptyList(), null));
    }

    @Test
    void no_visits_without_a_depot() {
        List<List<Coordinates>> track = Collections.singletonList(Collections.singletonList(this.visit.coordinates()));
        RouteWithTrack routeWithTrack = new RouteWithTrack(new Route(this.vehicle, this.depot, Collections.singletonList(this.visit)), track);
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new RoutingPlan("", this.vehicles, null, Collections.singletonList(this.visit), Collections.singletonList(routeWithTrack)));
    }

    @Test
    void no_routes_without_a_depot() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new RoutingPlan("", this.vehicles, null, Collections.emptyList(), Collections.singletonList(this.emptyRoute)));
    }

    @Test
    void there_must_be_one_route_per_vehicle_when_there_is_a_depot() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new RoutingPlan("", this.vehicles, this.depot, Collections.emptyList(), Collections.emptyList())).withMessageContaining("Vehicles (1): [").withMessageContaining("Routes' vehicleIds (0): []");
    }

    @Test
    void routes_vehicle_references_must_be_consistent_with_vehicles_in_routing_plan() {
        List<Vehicle> unexpectedVehicles = Collections.singletonList(VehicleFactory.testVehicle((long)(this.vehicle.id() + 1L)));
        List<RouteWithTrack> routes = Collections.singletonList(this.emptyRoute);
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new RoutingPlan("", unexpectedVehicles, this.depot, Collections.emptyList(), routes)).withMessageContaining("Vehicles (1): [").withMessageContaining("Routes' vehicleIds (1): [" + this.vehicle.id() + "]");
    }

    @Test
    void routes_visit_references_must_be_consistent_with_visits_in_routing_plan() {
        Vehicle vehicle1 = VehicleFactory.testVehicle((long)1L);
        Vehicle vehicle2 = VehicleFactory.testVehicle((long)2L);
        Location depot = new Location(100L, Coordinates.valueOf((double)0.0, (double)0.0), "depot");
        Location visit1 = new Location(101L, Coordinates.valueOf((double)1.0, (double)1.0), "visit1");
        Location visit2 = new Location(102L, Coordinates.valueOf((double)2.0, (double)2.0), "visit2");
        Location visit3 = new Location(103L, Coordinates.valueOf((double)3.0, (double)3.0), "visit3");
        Assertions.assertThatCode(() -> new RoutingPlan("", Collections.emptyList(), depot, Collections.singletonList(visit1), Collections.emptyList())).doesNotThrowAnyException();
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new RoutingPlan("", Collections.singletonList(vehicle1), depot, Arrays.asList(visit1, visit2), Collections.singletonList(new RouteWithTrack(new Route(vehicle1, depot, Arrays.asList(visit1, visit2, visit3)), this.nonEmptyTrack)))).withMessageContaining(visit3.toString());
        Location visit4 = new Location(104L, Coordinates.valueOf((double)4.0, (double)4.0), "visit4");
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new RoutingPlan("", Arrays.asList(vehicle1, vehicle2), depot, Arrays.asList(visit1, visit2, visit3), Arrays.asList(new RouteWithTrack(new Route(vehicle1, depot, Arrays.asList(visit1, visit4)), this.nonEmptyTrack), new RouteWithTrack(new Route(vehicle2, depot, Collections.singletonList(visit2)), this.nonEmptyTrack)))).withMessageContaining(visit4.toString());
    }

    @Test
    void cannot_modify_collections_externally() {
        ArrayList<Vehicle> vehicles = new ArrayList<Vehicle>();
        ArrayList<Location> visits = new ArrayList<Location>();
        ArrayList<RouteWithTrack> routes = new ArrayList<RouteWithTrack>();
        vehicles.add(this.vehicle);
        visits.add(this.visit);
        routes.add(new RouteWithTrack(new Route(this.vehicle, this.depot, Collections.singletonList(this.visit)), this.nonEmptyTrack));
        RoutingPlan routingPlan = new RoutingPlan("", vehicles, this.depot, visits, routes);
        Assertions.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(() -> routingPlan.vehicles().clear());
        Assertions.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(() -> routingPlan.visits().clear());
        Assertions.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(() -> routingPlan.routes().clear());
    }

    @Test
    void empty_routing_plan_should_be_empty() {
        RoutingPlan empty = RoutingPlan.empty();
        Assertions.assertThat((String)empty.distance()).isEmpty();
        Assertions.assertThat((List)empty.vehicles()).isEmpty();
        Assertions.assertThat((Optional)empty.depot()).isEmpty();
        Assertions.assertThat((List)empty.visits()).isEmpty();
        Assertions.assertThat((List)empty.routes()).isEmpty();
    }

    @Test
    void isEmpty() {
        Assertions.assertThat((boolean)RoutingPlan.empty().isEmpty()).isTrue();
        Assertions.assertThat((boolean)new RoutingPlan("", Collections.emptyList(), this.depot, Collections.emptyList(), Collections.emptyList()).isEmpty()).isFalse();
        Assertions.assertThat((boolean)new RoutingPlan("", this.vehicles, null, Collections.emptyList(), Collections.emptyList()).isEmpty()).isFalse();
        Assertions.assertThat((boolean)new RoutingPlan("", this.vehicles, this.depot, Collections.emptyList(), Collections.singletonList(this.emptyRoute)).isEmpty()).isFalse();
    }
}

