/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.demo;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.LocationData;
import org.optaweb.vehiclerouting.domain.RoutingProblem;
import org.optaweb.vehiclerouting.service.demo.DemoService;
import org.optaweb.vehiclerouting.service.demo.RoutingProblemList;
import org.optaweb.vehiclerouting.service.demo.dataset.DataSetMarshaller;
import org.optaweb.vehiclerouting.service.location.LocationRepository;
import org.optaweb.vehiclerouting.service.location.LocationService;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class DemoServiceTest {
    @Mock
    private LocationService locationService;
    @Mock
    private DataSetMarshaller dataSetMarshaller;
    @Mock
    private LocationRepository locationRepository;
    @Mock
    private RoutingProblemList routingProblems;
    @InjectMocks
    private DemoService demoService;
    @Captor
    private ArgumentCaptor<RoutingProblem> routingProblemCaptor;
    private final Location depot = new Location(1L, Coordinates.valueOf((double)1.0, (double)7.0), "Depot");
    private final List<Location> visits = Arrays.asList(new Location(2L, Coordinates.valueOf((double)2.0, (double)9.0), "Visit"));
    private final String problemName = "Testing problem";
    private final RoutingProblem routingProblem = new RoutingProblem("Testing problem", (LocationData)this.depot, this.visits);

    DemoServiceTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.locationService.createLocation((Coordinates)ArgumentMatchers.any(Coordinates.class), ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.routingProblems.all()).thenReturn(Arrays.asList(this.routingProblem));
        Mockito.when((Object)this.routingProblems.byName("Testing problem")).thenReturn((Object)this.routingProblem);
    }

    @Test
    void demos_should_return_routing_problems() {
        Collection problems = this.demoService.demos();
        Assertions.assertThat((Iterable)problems).containsExactly((Object[])new RoutingProblem[]{this.routingProblem});
    }

    @Test
    void loadDemo() {
        this.demoService.loadDemo("Testing problem");
        ((LocationService)Mockito.verify((Object)this.locationService, (VerificationMode)Mockito.times((int)(this.routingProblem.visits().size() + 1)))).createLocation((Coordinates)ArgumentMatchers.any(Coordinates.class), ArgumentMatchers.anyString());
    }

    @Test
    void retry_when_adding_location_fails() {
        Mockito.when((Object)this.locationService.createLocation((Coordinates)ArgumentMatchers.any(Coordinates.class), ArgumentMatchers.anyString())).thenReturn((Object)false);
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.demoService.loadDemo("Testing problem")).withMessageContaining(this.depot.coordinates().toString());
        ((LocationService)Mockito.verify((Object)this.locationService, (VerificationMode)Mockito.times((int)10))).createLocation((Coordinates)ArgumentMatchers.any(Coordinates.class), ArgumentMatchers.anyString());
    }

    @Test
    void export_should_marshal_routing_plans_with_locations_from_repository() {
        Location depot = new Location(0L, Coordinates.valueOf((double)1.0, (double)2.0), "Depot");
        Location visit1 = new Location(1L, Coordinates.valueOf((double)11.0, (double)22.0), "Visit 1");
        Location visit2 = new Location(2L, Coordinates.valueOf((double)22.0, (double)33.0), "Visit 2");
        Mockito.when((Object)this.locationRepository.locations()).thenReturn(Arrays.asList(depot, visit1, visit2));
        this.demoService.exportDataSet();
        RoutingProblem routingProblem = this.verifyAndCaptureMarshalledProblem();
        Assertions.assertThat((String)routingProblem.name()).isNotNull();
        Assertions.assertThat((Optional)routingProblem.depot()).contains((Object)depot);
        Assertions.assertThat((List)routingProblem.visits()).containsExactly((Object[])new LocationData[]{visit1, visit2});
    }

    @Test
    void export_should_marshal_empty_routing_plan_when_no_locations_in_repository() {
        Mockito.when((Object)this.locationRepository.locations()).thenReturn(Collections.emptyList());
        this.demoService.exportDataSet();
        RoutingProblem routingProblem = this.verifyAndCaptureMarshalledProblem();
        Assertions.assertThat((String)routingProblem.name()).isNotNull();
        Assertions.assertThat((Optional)routingProblem.depot()).isEmpty();
        Assertions.assertThat((List)routingProblem.visits()).isEmpty();
    }

    private RoutingProblem verifyAndCaptureMarshalledProblem() {
        ((DataSetMarshaller)Mockito.verify((Object)this.dataSetMarshaller)).marshal((RoutingProblem)this.routingProblemCaptor.capture());
        return (RoutingProblem)this.routingProblemCaptor.getValue();
    }
}

