/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.persistence;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.plugin.persistence.DistanceEntity;
import org.optaweb.vehiclerouting.plugin.persistence.DistanceKey;

class DistanceEntityTest {
    DistanceEntityTest() {
    }

    @Test
    void constructor_params_must_not_be_null() {
        DistanceKey dKey = new DistanceKey(1L, 2L);
        Assertions.assertThatNullPointerException().isThrownBy(() -> new DistanceEntity(null, Double.valueOf(10.0)));
        Assertions.assertThatNullPointerException().isThrownBy(() -> new DistanceEntity(dKey, null));
    }

    @Test
    void equals() {
        long from = 10L;
        long to = 2000L;
        DistanceKey distanceKey = new DistanceKey(10L, 2000L);
        double distance = 5.0001;
        DistanceEntity distanceEntity = new DistanceEntity(distanceKey, Double.valueOf(5.0001));
        Assertions.assertThat((Object)distanceEntity).isEqualTo((Object)distanceEntity);
        Assertions.assertThat((Object)distanceEntity).isEqualTo((Object)new DistanceEntity(new DistanceKey(10L, 2000L), Double.valueOf(5.0001)));
        Assertions.assertThat((Object)distanceEntity).isNotEqualTo(null);
        Assertions.assertThat((Object)distanceEntity).isNotEqualTo((Object)distanceKey);
        Assertions.assertThat((Object)distanceEntity).isNotEqualTo((Object)new DistanceEntity(distanceKey, Double.valueOf(6.0001)));
        Assertions.assertThat((Object)distanceEntity).isNotEqualTo((Object)new DistanceEntity(new DistanceKey(2000L, 10L), Double.valueOf(5.0001)));
    }
}

