/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.persistence;

import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.plugin.persistence.DistanceCrudRepository;
import org.optaweb.vehiclerouting.plugin.persistence.DistanceEntity;
import org.optaweb.vehiclerouting.plugin.persistence.DistanceKey;
import org.optaweb.vehiclerouting.plugin.persistence.DistanceRepositoryImpl;

@ExtendWith(value={MockitoExtension.class})
class DistanceRepositoryImplTest {
    @Mock
    private DistanceCrudRepository crudRepository;
    @InjectMocks
    private DistanceRepositoryImpl repository;
    @Captor
    private ArgumentCaptor<DistanceEntity> distanceEntityArgumentCaptor;
    @Mock
    private DistanceEntity distanceEntity;
    private final Location from = new Location(1L, Coordinates.valueOf((double)7.0, (double)-4.0));
    private final Location to = new Location(2L, Coordinates.valueOf((double)5.0, (double)9.0));

    DistanceRepositoryImplTest() {
    }

    @Test
    void should_save_distance() {
        double distance = 95676.6417;
        this.repository.saveDistance(this.from, this.to, distance);
        ((DistanceCrudRepository)Mockito.verify((Object)this.crudRepository)).save(this.distanceEntityArgumentCaptor.capture());
        DistanceEntity distanceEntity = (DistanceEntity)this.distanceEntityArgumentCaptor.getValue();
        Assertions.assertThat((Double)distanceEntity.getDistance()).isEqualTo(distance);
        Assertions.assertThat((Long)distanceEntity.getKey().getFromId()).isEqualTo(this.from.id());
        Assertions.assertThat((Long)distanceEntity.getKey().getToId()).isEqualTo(this.to.id());
    }

    @Test
    void should_return_distance_when_entity_is_found() {
        DistanceKey distanceKey = new DistanceKey(this.from.id(), this.to.id());
        Mockito.when((Object)this.crudRepository.findById((Object)distanceKey)).thenReturn(Optional.of(this.distanceEntity));
        double distance = 1.0305;
        Mockito.when((Object)this.distanceEntity.getDistance()).thenReturn((Object)1.0305);
        Assertions.assertThat((double)this.repository.getDistance(this.from, this.to)).isEqualTo(1.0305);
    }

    @Test
    void should_return_negative_number_when_distance_not_found() {
        Mockito.when((Object)this.crudRepository.findById(ArgumentMatchers.any(DistanceKey.class))).thenReturn(Optional.empty());
        Assertions.assertThat((double)this.repository.getDistance(this.from, this.to)).isNegative().isNotZero();
    }
}

