/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.persistence;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.plugin.persistence.LocationCrudRepository;
import org.optaweb.vehiclerouting.plugin.persistence.LocationEntity;
import org.optaweb.vehiclerouting.plugin.persistence.LocationRepositoryImpl;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class LocationRepositoryImplTest {
    @Mock
    private LocationCrudRepository crudRepository;
    @InjectMocks
    private LocationRepositoryImpl repository;
    @Mock
    private LocationEntity locationEntity;
    @Captor
    private ArgumentCaptor<LocationEntity> locationEntityCaptor;
    private Location testLocation;

    LocationRepositoryImplTest() {
    }

    @BeforeEach
    void setUp() {
        long id = 76L;
        BigDecimal latitude = BigDecimal.valueOf(1.2);
        BigDecimal longitude = BigDecimal.valueOf(3.4);
        String description = "description";
        this.testLocation = new Location(76L, new Coordinates(latitude, longitude), "description");
        Mockito.when((Object)this.locationEntity.getId()).thenReturn((Object)76L);
        Mockito.when((Object)this.locationEntity.getLatitude()).thenReturn((Object)latitude);
        Mockito.when((Object)this.locationEntity.getLongitude()).thenReturn((Object)longitude);
        Mockito.when((Object)this.locationEntity.getDescription()).thenReturn((Object)"description");
    }

    @Test
    void should_create_location_and_generate_id() {
        Mockito.when((Object)this.crudRepository.save(this.locationEntityCaptor.capture())).thenReturn((Object)this.locationEntity);
        Coordinates savedCoordinates = Coordinates.valueOf((double)0.00213, (double)32.777);
        String savedDescription = "new location";
        Location createdLocation = this.repository.createLocation(savedCoordinates, savedDescription);
        LocationEntity savedLocation = (LocationEntity)this.locationEntityCaptor.getValue();
        Assertions.assertThat((BigDecimal)savedLocation.getLatitude()).isEqualTo((Object)savedCoordinates.latitude());
        Assertions.assertThat((BigDecimal)savedLocation.getLongitude()).isEqualTo((Object)savedCoordinates.longitude());
        Assertions.assertThat((String)savedLocation.getDescription()).isEqualTo((Object)savedDescription);
        Assertions.assertThat((long)createdLocation.id()).isEqualTo(this.locationEntity.getId());
        Assertions.assertThat((Object)createdLocation.coordinates()).isEqualTo((Object)new Coordinates(this.locationEntity.getLatitude(), this.locationEntity.getLongitude()));
        Assertions.assertThat((String)createdLocation.description()).isEqualTo((Object)this.locationEntity.getDescription());
    }

    @Test
    void remove_created_location_by_id() {
        long id = this.testLocation.id();
        Mockito.when((Object)this.crudRepository.findById((Object)id)).thenReturn(Optional.of(this.locationEntity));
        Location removed = this.repository.removeLocation(id);
        Assertions.assertThat((Object)removed).isEqualTo((Object)this.testLocation);
        ((LocationCrudRepository)Mockito.verify((Object)this.crudRepository)).deleteById((Object)id);
    }

    @Test
    void removing_nonexistent_location_should_fail() {
        Mockito.when((Object)this.crudRepository.findById((Object)ArgumentMatchers.anyLong())).thenReturn(Optional.empty());
        int uniqueNonexistentId = 7173;
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.repository.removeLocation((long)uniqueNonexistentId)).withMessageContaining(String.valueOf(uniqueNonexistentId));
    }

    @Test
    void remove_all_locations() {
        this.repository.removeAll();
        ((LocationCrudRepository)Mockito.verify((Object)this.crudRepository)).deleteAll();
    }

    @Test
    void get_all_locations() {
        Mockito.when((Object)this.crudRepository.findAll()).thenReturn(Collections.singletonList(this.locationEntity));
        Assertions.assertThat((List)this.repository.locations()).containsExactly((Object[])new Location[]{this.testLocation});
    }

    @Test
    void find_by_id() {
        Mockito.when((Object)this.crudRepository.findById((Object)this.testLocation.id())).thenReturn(Optional.of(this.locationEntity));
        Assertions.assertThat((Optional)this.repository.find(Long.valueOf(this.testLocation.id()))).contains((Object)this.testLocation);
    }
}

