/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.change;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaweb.vehiclerouting.plugin.planner.change.AddVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.SolutionFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;

@ExtendWith(value={MockitoExtension.class})
class AddVehicleTest {
    @Mock
    private ScoreDirector<VehicleRoutingSolution> scoreDirector;

    AddVehicleTest() {
    }

    @Test
    void add_vehicle_should_add_vehicle() {
        VehicleRoutingSolution solution = SolutionFactory.emptySolution();
        Mockito.when((Object)this.scoreDirector.getWorkingSolution()).thenReturn((Object)solution);
        PlanningVehicle vehicle = new PlanningVehicle();
        AddVehicle addVehicle = new AddVehicle(vehicle);
        addVehicle.doChange(this.scoreDirector);
        Assertions.assertThat((List)solution.getVehicleList()).containsExactly((Object[])new PlanningVehicle[]{vehicle});
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).beforeProblemFactAdded((Object)vehicle);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).afterProblemFactAdded((Object)vehicle);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).triggerVariableListeners();
    }
}

