/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.websocket;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.plugin.websocket.PortableLocation;
import org.springframework.boot.test.json.JacksonTester;
import org.springframework.boot.test.json.JsonContentAssert;
import org.springframework.boot.test.json.ObjectContentAssert;

class PortableLocationTest {
    private final PortableLocation portableLocation = new PortableLocation(987L, BigDecimal.ONE, BigDecimal.TEN, "Some Location");
    private JacksonTester<PortableLocation> json;

    PortableLocationTest() {
    }

    @BeforeEach
    void setUp() {
        JacksonTester.initFields((Object)this, (ObjectMapper)new ObjectMapper());
    }

    @Test
    void marshal_to_json() throws IOException {
        ((JsonContentAssert)Assertions.assertThat((AssertProvider)this.json.write((Object)this.portableLocation))).isEqualToJson((CharSequence)"portable-location.json");
    }

    @Test
    void unmarshal_from_json() throws IOException {
        ((ObjectContentAssert)Assertions.assertThat((AssertProvider)this.json.read("portable-location.json"))).isEqualTo((Object)this.portableLocation);
    }

    @Test
    void constructor_params_must_not_be_null() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> new PortableLocation(1L, null, BigDecimal.ZERO, ""));
        Assertions.assertThatNullPointerException().isThrownBy(() -> new PortableLocation(1L, BigDecimal.ZERO, null, ""));
        Assertions.assertThatNullPointerException().isThrownBy(() -> new PortableLocation(1L, BigDecimal.ZERO, BigDecimal.ZERO, null));
    }

    @Test
    void fromLocation() {
        Location location = new Location(17L, Coordinates.valueOf((double)5.1, (double)-7.0E-4), "Hello, world!");
        PortableLocation portableLocation = PortableLocation.fromLocation((Location)location);
        Assertions.assertThat((long)portableLocation.getId()).isEqualTo(location.id());
        Assertions.assertThat((BigDecimal)portableLocation.getLatitude()).isEqualTo((Object)location.coordinates().latitude());
        Assertions.assertThat((BigDecimal)portableLocation.getLongitude()).isEqualTo((Object)location.coordinates().longitude());
        Assertions.assertThat((String)portableLocation.getDescription()).isEqualTo((Object)location.description());
        Assertions.assertThatNullPointerException().isThrownBy(() -> PortableLocation.fromLocation(null)).withMessageContaining("location");
    }

    @Test
    void equals_hashCode_toString() {
        long id = 123456L;
        String description = "x y";
        BigDecimal lat1 = BigDecimal.valueOf(10.0101);
        BigDecimal lat2 = BigDecimal.valueOf(20.2323);
        BigDecimal lon1 = BigDecimal.valueOf(-8.7);
        BigDecimal lon2 = BigDecimal.valueOf(-7.8);
        PortableLocation portableLocation = new PortableLocation(id, lat1, lon1, description);
        Assertions.assertThat((Object)portableLocation).isNotEqualTo(null);
        Assertions.assertThat((Object)portableLocation).isNotEqualTo((Object)new Location(id, new Coordinates(lat1, lon1)));
        Assertions.assertThat((Object)portableLocation).isNotEqualTo((Object)new PortableLocation(id + 1L, lat1, lon1, description));
        Assertions.assertThat((Object)portableLocation).isNotEqualTo((Object)new PortableLocation(id, lat1, lon2, description));
        Assertions.assertThat((Object)portableLocation).isNotEqualTo((Object)new PortableLocation(id, lat2, lon1, description));
        Assertions.assertThat((Object)portableLocation).isNotEqualTo((Object)new PortableLocation(id, lat1, lon1, "y x"));
        Assertions.assertThat((Object)portableLocation).isEqualTo((Object)portableLocation);
        Assertions.assertThat((Object)portableLocation).isEqualTo((Object)new PortableLocation(id, lat1, lon1, description));
        Assertions.assertThat((Object)portableLocation).hasSameHashCodeAs((Object)new PortableLocation(id, lat1, lon1, description));
        Assertions.assertThat((String)portableLocation.toString()).contains(new CharSequence[]{String.valueOf(id), lat1.toPlainString(), lon1.toPlainString(), description});
    }
}

