/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.location;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.service.error.ErrorEvent;
import org.optaweb.vehiclerouting.service.location.DistanceMatrix;
import org.optaweb.vehiclerouting.service.location.DistanceMatrixRow;
import org.optaweb.vehiclerouting.service.location.LocationRepository;
import org.optaweb.vehiclerouting.service.location.LocationService;
import org.optaweb.vehiclerouting.service.location.RouteOptimizer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

@ExtendWith(value={MockitoExtension.class})
class LocationServiceTest {
    @Mock
    private LocationRepository repository;
    @Mock
    private RouteOptimizer optimizer;
    @Mock
    private DistanceMatrix distanceMatrix;
    @Mock
    private ApplicationEventPublisher eventPublisher;
    @InjectMocks
    private LocationService locationService;
    private final Coordinates coordinates = Coordinates.valueOf((double)0.0, (double)1.0);
    private final Location location = new Location(1L, this.coordinates);

    LocationServiceTest() {
    }

    @Test
    void createLocation_should_validate_arguments() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.locationService.createLocation(null, "x"));
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.locationService.createLocation(this.coordinates, null));
    }

    @Test
    void createLocation(@Mock DistanceMatrixRow matrixRow) {
        String description = "new location";
        Mockito.when((Object)this.repository.createLocation(this.coordinates, description)).thenReturn((Object)this.location);
        Mockito.when((Object)this.distanceMatrix.addLocation((Location)ArgumentMatchers.any())).thenReturn((Object)matrixRow);
        Assertions.assertThat((boolean)this.locationService.createLocation(this.coordinates, description)).isTrue();
        ((LocationRepository)Mockito.verify((Object)this.repository)).createLocation(this.coordinates, description);
        ((DistanceMatrix)Mockito.verify((Object)this.distanceMatrix)).addLocation(this.location);
        ((RouteOptimizer)Mockito.verify((Object)this.optimizer)).addLocation(this.location, matrixRow);
    }

    @Test
    void addLocation_should_validate_arguments() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.locationService.addLocation(null));
    }

    @Test
    void addLocation(@Mock DistanceMatrixRow matrixRow) {
        Mockito.when((Object)this.distanceMatrix.addLocation((Location)ArgumentMatchers.any())).thenReturn((Object)matrixRow);
        Assertions.assertThat((boolean)this.locationService.addLocation(this.location)).isTrue();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.repository});
        ((DistanceMatrix)Mockito.verify((Object)this.distanceMatrix)).addLocation(this.location);
        ((RouteOptimizer)Mockito.verify((Object)this.optimizer)).addLocation(this.location, matrixRow);
    }

    @Test
    void removing_depot_should_be_successful_when_it_is_the_last_location() {
        Mockito.when((Object)this.repository.locations()).thenReturn(Collections.singletonList(this.location));
        Mockito.when((Object)this.repository.find(this.location.id())).thenReturn(Optional.of(this.location));
        this.locationService.removeLocation(this.location.id());
        ((LocationRepository)Mockito.verify((Object)this.repository)).removeLocation(this.location.id());
        ((RouteOptimizer)Mockito.verify((Object)this.optimizer)).removeLocation(this.location);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.eventPublisher});
    }

    @Test
    void removing_nonexistent_location_should_publish_error() {
        Mockito.when((Object)this.repository.find(this.location.id())).thenReturn(Optional.empty());
        this.locationService.removeLocation(this.location.id());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.optimizer});
        ((LocationRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.never())).removeLocation(ArgumentMatchers.anyLong());
        ((ApplicationEventPublisher)Mockito.verify((Object)this.eventPublisher)).publishEvent((ApplicationEvent)ArgumentMatchers.any(ErrorEvent.class));
    }

    @Test
    void removing_depot_when_there_are_other_locations_should_publish_error() {
        Location depot = new Location(1L, this.coordinates);
        Location visit = new Location(2L, this.coordinates);
        Mockito.when((Object)this.repository.locations()).thenReturn(Arrays.asList(depot, visit));
        Mockito.when((Object)this.repository.find(depot.id())).thenReturn(Optional.of(depot));
        this.locationService.removeLocation(depot.id());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.optimizer});
        ((LocationRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.never())).removeLocation(ArgumentMatchers.anyLong());
        ((ApplicationEventPublisher)Mockito.verify((Object)this.eventPublisher)).publishEvent((ApplicationEvent)ArgumentMatchers.any(ErrorEvent.class));
    }

    @Test
    void removing_visit_should_be_successful() {
        Location depot = new Location(1L, this.coordinates);
        Location visit = new Location(2L, this.coordinates);
        Mockito.when((Object)this.repository.locations()).thenReturn(Arrays.asList(depot, visit));
        Mockito.when((Object)this.repository.find(visit.id())).thenReturn(Optional.of(visit));
        this.locationService.removeLocation(visit.id());
        ((LocationRepository)Mockito.verify((Object)this.repository)).removeLocation(visit.id());
        ((RouteOptimizer)Mockito.verify((Object)this.optimizer)).removeLocation(visit);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.eventPublisher});
    }

    @Test
    void clear() {
        this.locationService.removeAll();
        ((RouteOptimizer)Mockito.verify((Object)this.optimizer)).removeAllLocations();
        ((DistanceMatrix)Mockito.verify((Object)this.distanceMatrix)).clear();
        ((LocationRepository)Mockito.verify((Object)this.repository)).removeAll();
    }

    @Test
    void should_not_optimize_and_roll_back_if_distance_calculation_fails() {
        Mockito.when((Object)this.repository.createLocation(this.coordinates, "")).thenReturn((Object)this.location);
        ((DistanceMatrix)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("test exception")}).when((Object)this.distanceMatrix)).addLocation(this.location);
        Assertions.assertThat((boolean)this.locationService.createLocation(this.coordinates, "")).isFalse();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.optimizer});
        ((ApplicationEventPublisher)Mockito.verify((Object)this.eventPublisher)).publishEvent((ApplicationEvent)ArgumentMatchers.any(ErrorEvent.class));
        ((LocationRepository)Mockito.verify((Object)this.repository)).removeLocation(this.location.id());
    }
}

