/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.websocket;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaweb.vehiclerouting.plugin.websocket.PortableErrorMessage;
import org.optaweb.vehiclerouting.plugin.websocket.WebSocketErrorMessageSender;
import org.optaweb.vehiclerouting.service.error.ErrorMessage;
import org.springframework.messaging.simp.SimpMessagingTemplate;

@ExtendWith(value={MockitoExtension.class})
class WebSocketErrorMessageSenderTest {
    WebSocketErrorMessageSenderTest() {
    }

    @Test
    void should_send_consumed_message_over_websocket(@Mock SimpMessagingTemplate webSocket) {
        ErrorMessage message = ErrorMessage.of((String)"id", (String)"error");
        new WebSocketErrorMessageSender(webSocket).consumeMessage(message);
        ((SimpMessagingTemplate)Mockito.verify((Object)webSocket)).convertAndSend((Object)"/topic/error", (Object)PortableErrorMessage.fromMessage((ErrorMessage)message));
    }
}

