/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.websocket;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.plugin.websocket.PortableCoordinates;
import org.optaweb.vehiclerouting.plugin.websocket.PortableLocation;
import org.optaweb.vehiclerouting.plugin.websocket.PortableRoute;
import org.optaweb.vehiclerouting.plugin.websocket.PortableVehicle;
import org.springframework.boot.test.json.JacksonTester;
import org.springframework.boot.test.json.JsonContentAssert;

class PortableRouteTest {
    private JacksonTester<PortableRoute> json;

    PortableRouteTest() {
    }

    @BeforeEach
    void setUp() {
        JacksonTester.initFields((Object)this, (ObjectMapper)new ObjectMapper());
    }

    @Test
    void marshal_to_json() throws IOException {
        PortableVehicle vehicle = new PortableVehicle(13L, "Vehicle", 45317);
        PortableLocation depot = PortableRouteTest.visit(8L, 42.6501218, -71.8835449, "Test depot");
        PortableLocation visit1 = PortableRouteTest.visit(100L, 42.7066596, -72.4934873, "Visit 1");
        PortableLocation visit2 = PortableRouteTest.visit(200L, 42.5543343, -71.443828, "Visit 2");
        PortableRoute portableRoute = new PortableRoute(vehicle, depot, Arrays.asList(visit1, visit2), Arrays.asList(Arrays.asList(PortableRouteTest.coordinates(42.65005, -71.88522), PortableRouteTest.coordinates(42.64997, -71.88527)), Arrays.asList(PortableRouteTest.coordinates(42.64994, -71.88537), PortableRouteTest.coordinates(42.64994, -71.88542))));
        ((JsonContentAssert)Assertions.assertThat((AssertProvider)this.json.write((Object)portableRoute))).isStrictlyEqualToJson((CharSequence)"portable-route.json");
    }

    private static PortableLocation visit(long id, double latitude, double longitude, String description) {
        return PortableLocation.fromLocation((Location)new Location(id, Coordinates.valueOf((double)latitude, (double)longitude), description));
    }

    private static PortableCoordinates coordinates(double latitude, double longitude) {
        return PortableCoordinates.fromCoordinates((Coordinates)Coordinates.valueOf((double)latitude, (double)longitude));
    }
}

