/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.change;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.solver.change.ProblemChange;
import org.optaplanner.core.api.solver.change.ProblemChangeDirector;
import org.optaplanner.test.api.solver.change.MockProblemChangeDirector;
import org.optaweb.vehiclerouting.plugin.planner.MockSolver;
import org.optaweb.vehiclerouting.plugin.planner.change.RemoveVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicleFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisitFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.SolutionFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.Standstill;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;

class RemoveVisitTest {
    RemoveVisitTest() {
    }

    @Test
    void remove_last_visit() {
        VehicleRoutingSolution solution = SolutionFactory.emptySolution();
        PlanningVisit removedVisit = PlanningVisitFactory.testVisit((long)1L);
        PlanningVisit otherVisit = PlanningVisitFactory.testVisit((long)2L);
        solution.getVisitList().add(otherVisit);
        solution.getVisitList().add(removedVisit);
        otherVisit.setPreviousStandstill((Standstill)PlanningVehicleFactory.testVehicle((long)10L));
        otherVisit.setNextVisit(removedVisit);
        removedVisit.setPreviousStandstill((Standstill)otherVisit);
        MockSolver<VehicleRoutingSolution> mockSolver = MockSolver.build(solution);
        mockSolver.whenLookingUp(removedVisit).thenReturn((Object)removedVisit);
        mockSolver.addProblemChange((ProblemChange<VehicleRoutingSolution>)new RemoveVisit(removedVisit));
        mockSolver.verifyEntityRemoved(removedVisit);
        Assertions.assertThat((List)solution.getVisitList()).containsExactly((Object[])new PlanningVisit[]{otherVisit});
    }

    @Test
    void remove_middle_visit() {
        VehicleRoutingSolution solution = SolutionFactory.emptySolution();
        PlanningVisit firstVisit = PlanningVisitFactory.testVisit((long)1L);
        PlanningVisit middleVisit = PlanningVisitFactory.testVisit((long)2L);
        PlanningVisit lastVisit = PlanningVisitFactory.testVisit((long)3L);
        solution.getVisitList().add(firstVisit);
        solution.getVisitList().add(lastVisit);
        solution.getVisitList().add(middleVisit);
        firstVisit.setPreviousStandstill((Standstill)PlanningVehicleFactory.testVehicle((long)1L));
        firstVisit.setNextVisit(middleVisit);
        middleVisit.setPreviousStandstill((Standstill)firstVisit);
        middleVisit.setNextVisit(lastVisit);
        lastVisit.setPreviousStandstill((Standstill)middleVisit);
        PlanningVisit removedVisit = PlanningVisitFactory.testVisit((long)2L);
        MockSolver<VehicleRoutingSolution> mockSolver = MockSolver.build(solution);
        mockSolver.whenLookingUp(removedVisit).thenReturn((Object)middleVisit);
        mockSolver.addProblemChange((ProblemChange<VehicleRoutingSolution>)new RemoveVisit(removedVisit));
        mockSolver.verifyVariableChanged(lastVisit, "previousStandstill");
        mockSolver.verifyEntityRemoved(removedVisit);
        ((ListAssert)Assertions.assertThat((List)solution.getVisitList()).hasSize(2)).containsOnly((Object[])new PlanningVisit[]{firstVisit, lastVisit});
        Assertions.assertThat((Object)lastVisit.getPreviousStandstill()).isEqualTo((Object)firstVisit);
    }

    @Test
    void fail_fast_if_working_solution_visit_list_does_not_contain_working_visit() {
        VehicleRoutingSolution solution = SolutionFactory.emptySolution();
        long removedId = 111L;
        PlanningVisit removedVisit = PlanningVisitFactory.testVisit((long)removedId);
        long wrongId = 222L;
        PlanningVisit wrongVisit = PlanningVisitFactory.testVisit((long)wrongId);
        wrongVisit.setPreviousStandstill((Standstill)PlanningVisitFactory.testVisit((long)10L));
        removedVisit.setNextVisit(wrongVisit);
        solution.getVisitList().add(wrongVisit);
        RemoveVisit removeVisit = new RemoveVisit(removedVisit);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> removeVisit.doChange(solution, (ProblemChangeDirector)new MockProblemChangeDirector())).withMessageMatching(".*List .*" + wrongId + ".* doesn't contain the working.*" + removedId + ".*");
    }
}

