/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.change;

import java.util.Objects;
import org.optaplanner.core.api.solver.change.ProblemChange;
import org.optaplanner.core.api.solver.change.ProblemChangeDirector;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;

public class RemoveVehicle
implements ProblemChange<VehicleRoutingSolution> {
    private final PlanningVehicle removedVehicle;

    public RemoveVehicle(PlanningVehicle removedVehicle) {
        this.removedVehicle = Objects.requireNonNull(removedVehicle);
    }

    public void doChange(VehicleRoutingSolution workingSolution, ProblemChangeDirector problemChangeDirector) {
        PlanningVehicle workingVehicle = (PlanningVehicle)problemChangeDirector.lookUpWorkingObjectOrFail((Object)this.removedVehicle);
        for (PlanningVisit visit : workingVehicle.getFutureVisits()) {
            problemChangeDirector.changeVariable((Object)visit, "previousStandstill", planningVisit -> planningVisit.setPreviousStandstill(null));
        }
        problemChangeDirector.removeProblemFact((Object)workingVehicle, planningVehicle -> {
            if (!workingSolution.getVehicleList().remove(planningVehicle)) {
                throw new IllegalStateException("Working solution's vehicleList " + workingSolution.getVehicleList() + " doesn't contain the workingVehicle (" + planningVehicle + "). This is a bug!");
            }
        });
    }
}

