/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.rest.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Objects;
import org.optaweb.vehiclerouting.domain.Location;

public class PortableLocation {
    private final long id;
    @JsonProperty(value="lat", required=true)
    private final BigDecimal latitude;
    @JsonProperty(value="lng", required=true)
    private final BigDecimal longitude;
    private final String description;

    static PortableLocation fromLocation(Location location) {
        Objects.requireNonNull(location, "location must not be null");
        return new PortableLocation(location.id(), location.coordinates().latitude(), location.coordinates().longitude(), location.description());
    }

    @JsonCreator
    public PortableLocation(@JsonProperty(value="id") long id, @JsonProperty(value="lat") BigDecimal latitude, @JsonProperty(value="lng") BigDecimal longitude, @JsonProperty(value="description") String description) {
        this.id = id;
        this.latitude = Objects.requireNonNull(latitude);
        this.longitude = Objects.requireNonNull(longitude);
        this.description = Objects.requireNonNull(description);
    }

    public long getId() {
        return this.id;
    }

    public BigDecimal getLatitude() {
        return this.latitude;
    }

    public BigDecimal getLongitude() {
        return this.longitude;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortableLocation that = (PortableLocation)o;
        return this.id == that.id && this.description.equals(that.description) && this.latitude.compareTo(that.latitude) == 0 && this.longitude.compareTo(that.longitude) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.description, this.latitude, this.longitude);
    }

    public String toString() {
        return "PortableLocation{id=" + this.id + ", description='" + this.description + "', latitude=" + this.latitude + ", longitude=" + this.longitude + "}";
    }
}

