/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.jboss.auth;

import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.Certificate;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.login.LoginException;
import org.jboss.security.plugins.JaasSecurityDomain;
import org.picketlink.identity.federation.bindings.jboss.auth.SAML2STSCommonLoginModule;
import org.picketlink.identity.federation.core.factories.JBossAuthCacheInvalidationFactory;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.wstrust.plugins.saml.SAMLUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.w3c.dom.Element;

public class SAML2STSLoginModule
extends SAML2STSCommonLoginModule {
    protected boolean localValidation(Element assertionElement) throws Exception {
        if (this.localTestingOnly) {
            return true;
        }
        try {
            InitialContext ctx = new InitialContext();
            JaasSecurityDomain sd = (JaasSecurityDomain)ctx.lookup(this.localValidationSecurityDomain);
            KeyStore ts = sd.getTrustStore();
            if (ts == null) {
                throw logger.authNullKeyStoreFromSecurityDomainError(sd.getName());
            }
            String alias = sd.getKeyStoreAlias();
            if (alias == null) {
                throw logger.authNullKeyStoreAliasFromSecurityDomainError(sd.getName());
            }
            Certificate cert = ts.getCertificate(alias);
            if (cert == null) {
                throw logger.authNoCertificateFoundForAliasError(alias, sd.getName());
            }
            PublicKey publicKey = cert.getPublicKey();
            boolean sigValid = AssertionUtil.isSignatureValid((Element)assertionElement, (PublicKey)publicKey);
            if (!sigValid) {
                throw logger.authSAMLInvalidSignatureError();
            }
            AssertionType assertion = SAMLUtil.fromElement((Element)assertionElement);
            if (AssertionUtil.hasExpired((AssertionType)assertion)) {
                throw logger.authSAMLAssertionExpiredError();
            }
        }
        catch (NamingException e) {
            throw new LoginException(e.toString());
        }
        return true;
    }

    protected JBossAuthCacheInvalidationFactory.TimeCacheExpiry getCacheExpiry() throws Exception {
        return JBossAuthCacheInvalidationFactory.getCacheExpiry();
    }
}

