/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.wildfly.rest;

import java.io.InputStream;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.picketlink.identity.federation.bindings.wildfly.providers.OAuthProtocolContext;
import org.picketlink.identity.federation.bindings.wildfly.rest.SAMLOauthInfo;
import org.picketlink.identity.federation.bindings.wildfly.rest.STSEndpoint;
import org.picketlink.identity.federation.core.interfaces.ProtocolContext;
import org.picketlink.identity.federation.core.parsers.saml.SAMLParser;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.web.util.PostBindingUtil;

@Path(value="/samloauth")
public class SAMLOAuthEndpoint
extends STSEndpoint {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger((String)SAMLOAuthEndpoint.class.getName());
    private final String GRANT_TYPE = "urn:ietf:params:oauth:grant-type:saml2-bearer";
    private final String GRANT_TYPE_PARAMETER = "grant_type";
    private final String ASSERTION_PARAMETER = "assertion";
    private boolean debugEnabled = log.isDebugEnabled();

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response exchange(@Context HttpServletRequest request) throws Exception {
        Principal principal = request.getUserPrincipal();
        if (principal == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        String grantType = request.getParameter("grant_type");
        if (grantType == null) {
            if (this.debugEnabled) {
                log.debug((Object)"Grant Type parameter missing");
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!grantType.equals("urn:ietf:params:oauth:grant-type:saml2-bearer")) {
            if (this.debugEnabled) {
                log.debug((Object)("Wrong Grant Type:" + grantType));
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String samlToken = request.getParameter("assertion");
        if (samlToken == null) {
            if (this.debugEnabled) {
                log.debug((Object)"No SAML Assertion Found");
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        SAMLParser samlParser = new SAMLParser();
        InputStream inputStream = PostBindingUtil.base64DecodeAsStream((String)samlToken);
        AssertionType assertionType = (AssertionType)samlParser.parse(inputStream);
        if (AssertionUtil.hasExpired((AssertionType)assertionType)) {
            log.error((Object)("Expired Assertion with ID = " + assertionType.getID()));
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        String assertionID = assertionType.getID();
        this.checkAndSetUpSTS();
        OAuthProtocolContext oAuthProtocolContext = new OAuthProtocolContext();
        oAuthProtocolContext.setSamlAssertionID(assertionID);
        this.sts.issueToken((ProtocolContext)oAuthProtocolContext);
        String oauthToken = oAuthProtocolContext.getToken();
        if (oauthToken == null) {
            Response.serverError().build();
        }
        SAMLOauthInfo samlOauthInfo = new SAMLOauthInfo(assertionID, oauthToken);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)samlOauthInfo.asJSON()).build();
    }
}

