/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.store.hibernate;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.helper.Tools;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObject;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectAttribute;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectAttributeBinaryValue;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectCredential;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectCredentialBinaryValue;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectCredentialType;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectRelationship;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectRelationshipName;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectRelationshipType;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectType;
import org.picketlink.idm.impl.model.hibernate.HibernateRealm;
import org.picketlink.idm.impl.store.FeaturesMetaDataImpl;
import org.picketlink.idm.impl.store.hibernate.HibernateIdentityStoreSessionImpl;
import org.picketlink.idm.spi.configuration.IdentityStoreConfigurationContext;
import org.picketlink.idm.spi.configuration.metadata.IdentityObjectAttributeMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityObjectTypeMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityStoreConfigurationMetaData;
import org.picketlink.idm.spi.configuration.metadata.RealmConfigurationMetaData;
import org.picketlink.idm.spi.exception.OperationNotSupportedException;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectAttribute;
import org.picketlink.idm.spi.model.IdentityObjectCredential;
import org.picketlink.idm.spi.model.IdentityObjectCredentialType;
import org.picketlink.idm.spi.model.IdentityObjectRelationship;
import org.picketlink.idm.spi.model.IdentityObjectRelationshipType;
import org.picketlink.idm.spi.model.IdentityObjectType;
import org.picketlink.idm.spi.search.IdentityObjectSearchCriteria;
import org.picketlink.idm.spi.store.FeaturesMetaData;
import org.picketlink.idm.spi.store.IdentityObjectSearchCriteriaType;
import org.picketlink.idm.spi.store.IdentityStore;
import org.picketlink.idm.spi.store.IdentityStoreInvocationContext;
import org.picketlink.idm.spi.store.IdentityStoreSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateIdentityStoreImpl
implements IdentityStore,
Serializable {
    private static Logger log = Logger.getLogger(HibernateIdentityStoreImpl.class.getName());
    public static final String HIBERNATE_SESSION_FACTORY_REGISTRY_NAME = "hibernateSessionFactoryRegistryName";
    public static final String HIBERNATE_CONFIGURATION = "hibernateConfiguration";
    public static final String ADD_HIBERNATE_MAPPINGS = "addHibernateMappings";
    public static final String HIBERNATE_SESSION_FACTORY_JNDI_NAME = "hibernateSessionFactoryJNDIName";
    public static final String POPULATE_MEMBERSHIP_TYPES = "populateRelationshipTypes";
    public static final String POPULATE_IDENTITY_OBJECT_TYPES = "populateIdentityObjectTypes";
    public static final String IS_REALM_AWARE = "isRealmAware";
    public static final String MANAGE_TRANSACTION_DURING_BOOTSTRAP = "manageTransactionDuringBootstrap";
    public static final String ALLOW_NOT_DEFINED_ATTRIBUTES = "allowNotDefinedAttributes";
    public static final String ALLOW_NOT_DEFINED_IDENTITY_OBJECT_TYPES_OPTION = "allowNotDefinedIdentityObjectTypes";
    public static final String ALLOW_NOT_CASE_SENSITIVE_SEARCH = "allowNotCaseSensitiveSearch";
    public static final String DEFAULT_REALM_NAME = HibernateIdentityStoreImpl.class.getName() + ".DEFAULT_REALM";
    public static final String CREDENTIAL_TYPE_PASSWORD = "PASSWORD";
    public static final String CREDENTIAL_TYPE_BINARY = "BINARY";
    private String id;
    private FeaturesMetaData supportedFeatures;
    private SessionFactory sessionFactory;
    private boolean isRealmAware = false;
    private boolean isAllowNotDefinedAttributes = false;
    private boolean isAllowNotDefinedIdentityObjectTypes = false;
    private boolean isAllowNotCaseSensitiveSearch = false;
    private boolean isManageTransactionDuringBootstrap = true;
    private IdentityStoreConfigurationMetaData configurationMD;
    private static Set<IdentityObjectSearchCriteriaType> supportedIdentityObjectSearchCriteria = new HashSet<IdentityObjectSearchCriteriaType>();
    private static Set<String> supportedCredentialTypes = new HashSet<String>();
    private Map<String, Set<String>> attributeMappings = new HashMap<String, Set<String>>();
    private Map<String, Map<String, IdentityObjectAttributeMetaData>> attributesMetaData = new HashMap<String, Map<String, IdentityObjectAttributeMetaData>>();
    private Map<String, Map<String, String>> reverseAttributeMappings = new HashMap<String, Map<String, String>>();
    private static final long serialVersionUID = -130355852189832805L;

    public HibernateIdentityStoreImpl(String id) {
        this.id = id;
    }

    public void bootstrap(IdentityStoreConfigurationContext configurationContext) throws IdentityException {
        String allowNotCaseSensitiveSearch;
        String allowNotDefinedIOT;
        String allowNotDefineAttributes;
        String realmAware;
        this.configurationMD = configurationContext.getStoreConfigurationMetaData();
        this.id = this.configurationMD.getId();
        this.supportedFeatures = new FeaturesMetaDataImpl(this.configurationMD, supportedIdentityObjectSearchCriteria, true, true, new HashSet());
        String populateMembershipTypes = this.configurationMD.getOptionSingleValue(POPULATE_MEMBERSHIP_TYPES);
        String populateIdentityObjectTypes = this.configurationMD.getOptionSingleValue(POPULATE_IDENTITY_OBJECT_TYPES);
        String manageTransactionDuringBootstrap = this.configurationMD.getOptionSingleValue(MANAGE_TRANSACTION_DURING_BOOTSTRAP);
        if (manageTransactionDuringBootstrap != null && manageTransactionDuringBootstrap.equalsIgnoreCase("false")) {
            this.isAllowNotDefinedAttributes = false;
        }
        this.sessionFactory = this.bootstrapHibernateSessionFactory(configurationContext);
        Session hibernateSession = this.sessionFactory.openSession();
        for (IdentityObjectTypeMetaData identityObjectTypeMetaData : this.configurationMD.getSupportedIdentityTypes()) {
            HashSet<String> names = new HashSet<String>();
            HashMap<String, IdentityObjectAttributeMetaData> metadataMap = new HashMap<String, IdentityObjectAttributeMetaData>();
            HashMap<String, String> reverseMap = new HashMap<String, String>();
            for (IdentityObjectAttributeMetaData attributeMetaData : identityObjectTypeMetaData.getAttributes()) {
                names.add(attributeMetaData.getName());
                metadataMap.put(attributeMetaData.getName(), attributeMetaData);
                if (attributeMetaData.getStoreMapping() == null) continue;
                reverseMap.put(attributeMetaData.getStoreMapping(), attributeMetaData.getName());
            }
            this.attributeMappings.put(identityObjectTypeMetaData.getName(), Collections.unmodifiableSet(names));
            this.attributesMetaData.put(identityObjectTypeMetaData.getName(), metadataMap);
            this.reverseAttributeMappings.put(identityObjectTypeMetaData.getName(), reverseMap);
        }
        this.attributeMappings = Collections.unmodifiableMap(this.attributeMappings);
        if (this.isManageTransactionDuringBootstrap()) {
            hibernateSession.getTransaction().begin();
        }
        if (populateMembershipTypes != null && populateMembershipTypes.equalsIgnoreCase("true")) {
            LinkedList<String> memberships = new LinkedList<String>();
            for (String membership : this.configurationMD.getSupportedRelationshipTypes()) {
                memberships.add(membership);
            }
            try {
                this.populateRelationshipTypes((org.hibernate.Session)hibernateSession, memberships.toArray(new String[memberships.size()]));
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Exception occurred: ", e);
                }
                throw new IdentityException("Failed to populate relationship types", (Throwable)e);
            }
        }
        if (populateIdentityObjectTypes != null && populateIdentityObjectTypes.equalsIgnoreCase("true")) {
            LinkedList<String> types = new LinkedList<String>();
            for (IdentityObjectTypeMetaData metaData : this.configurationMD.getSupportedIdentityTypes()) {
                types.add(metaData.getName());
            }
            try {
                this.populateObjectTypes((org.hibernate.Session)hibernateSession, types.toArray(new String[types.size()]));
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Exception occurred: ", e);
                }
                throw new IdentityException("Failed to populate identity object types", (Throwable)e);
            }
        }
        if (supportedCredentialTypes != null && supportedCredentialTypes.size() > 0) {
            try {
                this.populateCredentialTypes((org.hibernate.Session)hibernateSession, supportedCredentialTypes.toArray(new String[supportedCredentialTypes.size()]));
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Exception occurred: ", e);
                }
                throw new IdentityException("Failed to populated credential types");
            }
        }
        if ((realmAware = this.configurationMD.getOptionSingleValue(IS_REALM_AWARE)) != null && realmAware.equalsIgnoreCase("true")) {
            this.isRealmAware = true;
        }
        if ((allowNotDefineAttributes = this.configurationMD.getOptionSingleValue(ALLOW_NOT_DEFINED_ATTRIBUTES)) != null && allowNotDefineAttributes.equalsIgnoreCase("true")) {
            this.isAllowNotDefinedAttributes = true;
        }
        if ((allowNotDefinedIOT = this.configurationMD.getOptionSingleValue(ALLOW_NOT_DEFINED_IDENTITY_OBJECT_TYPES_OPTION)) != null && allowNotDefinedIOT.equalsIgnoreCase("true")) {
            this.isAllowNotDefinedIdentityObjectTypes = true;
        }
        if ((allowNotCaseSensitiveSearch = this.configurationMD.getOptionSingleValue(ALLOW_NOT_CASE_SENSITIVE_SEARCH)) != null && allowNotCaseSensitiveSearch.equalsIgnoreCase("true")) {
            this.isAllowNotCaseSensitiveSearch = true;
        }
        HibernateRealm realm = null;
        try {
            realm = (HibernateRealm)hibernateSession.createCriteria(HibernateRealm.class).add((Criterion)Restrictions.eq((String)"name", (Object)DEFAULT_REALM_NAME)).uniqueResult();
        }
        catch (HibernateException e) {
            // empty catch block
        }
        if (realm == null) {
            this.addRealm((org.hibernate.Session)hibernateSession, DEFAULT_REALM_NAME);
        }
        if (this.isRealmAware()) {
            HashSet<String> realmNames = new HashSet<String>();
            for (RealmConfigurationMetaData realmMD : configurationContext.getConfigurationMetaData().getRealms()) {
                realmNames.add(realmMD.getId());
            }
            for (String rid : realmNames) {
                realm = (HibernateRealm)hibernateSession.createCriteria(HibernateRealm.class).add((Criterion)Restrictions.eq((String)"name", (Object)rid)).setCacheable(true).uniqueResult();
                if (realm != null) continue;
                this.addRealm((org.hibernate.Session)hibernateSession, rid);
            }
        }
        if (this.isManageTransactionDuringBootstrap()) {
            hibernateSession.getTransaction().commit();
        }
        hibernateSession.flush();
        hibernateSession.close();
    }

    protected SessionFactory bootstrapHibernateSessionFactory(IdentityStoreConfigurationContext configurationContext) throws IdentityException {
        String sfJNDIName = configurationContext.getStoreConfigurationMetaData().getOptionSingleValue(HIBERNATE_SESSION_FACTORY_JNDI_NAME);
        String sfRegistryName = configurationContext.getStoreConfigurationMetaData().getOptionSingleValue(HIBERNATE_SESSION_FACTORY_REGISTRY_NAME);
        String addMappedClasses = configurationContext.getStoreConfigurationMetaData().getOptionSingleValue(ADD_HIBERNATE_MAPPINGS);
        String hibernateConfiguration = configurationContext.getStoreConfigurationMetaData().getOptionSingleValue(HIBERNATE_CONFIGURATION);
        if (sfJNDIName != null) {
            try {
                return (SessionFactory)new InitialContext().lookup(sfJNDIName);
            }
            catch (NamingException e) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Exception occurred: ", e);
                }
                throw new IdentityException("Cannot obtain hibernate SessionFactory from provided JNDI name: " + sfJNDIName, (Throwable)e);
            }
        }
        if (sfRegistryName != null) {
            Object registryObject = configurationContext.getConfigurationRegistry().getObject(sfRegistryName);
            if (registryObject == null) {
                throw new IdentityException("Cannot obtain hibernate SessionFactory from provided registry name: " + sfRegistryName);
            }
            if (!(registryObject instanceof SessionFactory)) {
                throw new IdentityException("Cannot obtain hibernate SessionFactory from provided registry name: " + sfRegistryName + "; Registered object is not an instance of SessionFactory: " + registryObject.getClass().getName());
            }
            return (SessionFactory)registryObject;
        }
        if (hibernateConfiguration != null) {
            try {
                Configuration config = new Configuration().configure(hibernateConfiguration);
                if (addMappedClasses != null && addMappedClasses.equals("false")) {
                    return config.buildSessionFactory();
                }
                return config.addResource("mappings/HibernateIdentityObject.hbm.xml").addResource("mappings/HibernateIdentityObjectCredentialBinaryValue.hbm.xml").addResource("mappings/HibernateIdentityObjectAttributeBinaryValue.hbm.xml").addResource("mappings/HibernateIdentityObjectAttribute.hbm.xml").addResource("mappings/HibernateIdentityObjectCredential.hbm.xml").addResource("mappings/HibernateIdentityObjectCredentialType.hbm.xml").addResource("mappings/HibernateIdentityObjectRelationship.hbm.xml").addResource("mappings/HibernateIdentityObjectRelationshipName.hbm.xml").addResource("mappings/HibernateIdentityObjectRelationshipType.hbm.xml").addResource("mappings/HibernateIdentityObjectType.hbm.xml").addResource("mappings/HibernateRealm.hbm.xml").buildSessionFactory();
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Exception occurred: ", e);
                }
                throw new IdentityException("Cannot obtain hibernate SessionFactory using provided hibernate configuration: " + hibernateConfiguration, (Throwable)e);
            }
        }
        throw new IdentityException("Cannot obtain hibernate SessionFactory. None of supported options specified: hibernateSessionFactoryJNDIName, hibernateSessionFactoryRegistryName, hibernateConfiguration");
    }

    public IdentityStoreSession createIdentityStoreSession() throws IdentityException {
        try {
            return new HibernateIdentityStoreSessionImpl(this.sessionFactory);
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Failed to obtain Hibernate SessionFactory", (Throwable)e);
        }
    }

    public IdentityStoreSession createIdentityStoreSession(Map<String, Object> sessionOptions) throws IdentityException {
        return this.createIdentityStoreSession();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public FeaturesMetaData getSupportedFeatures() {
        return this.supportedFeatures;
    }

    public IdentityObject createIdentityObject(IdentityStoreInvocationContext invocationCtx, String name, IdentityObjectType identityObjectType) throws IdentityException {
        return this.createIdentityObject(invocationCtx, name, identityObjectType, null);
    }

    public IdentityObject createIdentityObject(IdentityStoreInvocationContext ctx, String name, IdentityObjectType identityObjectType, Map<String, String[]> attributes) throws IdentityException {
        if (name == null) {
            throw new IllegalArgumentException("IdentityObject name is null");
        }
        this.checkIOType(identityObjectType);
        org.hibernate.Session session = this.getHibernateSession(ctx);
        HibernateRealm realm = this.getRealm(session, ctx);
        Number boxedSize = (Number)session.createCriteria(HibernateIdentityObject.class).createAlias("identityType", "type").createAlias("realm", "rm").add((Criterion)Restrictions.eq((String)"name", (Object)name)).add((Criterion)Restrictions.eq((String)"rm.name", (Object)realm.getName())).add((Criterion)Restrictions.eq((String)"type.name", (Object)identityObjectType.getName())).setProjection(Projections.rowCount()).setCacheable(true).list().get(0);
        int size = boxedSize.intValue();
        if (size != 0) {
            throw new IdentityException("IdentityObject already present in this IdentityStore:name=" + name + "; type=" + identityObjectType.getName() + "; realm=" + realm);
        }
        HibernateIdentityObjectType hibernateType = this.getHibernateIdentityObjectType(ctx, identityObjectType);
        HibernateIdentityObject io = new HibernateIdentityObject(name, hibernateType, realm);
        if (attributes != null) {
            for (Map.Entry<String, String[]> entry : attributes.entrySet()) {
                io.addTextAttribute(entry.getKey(), entry.getValue());
            }
        }
        try {
            this.getHibernateSession(ctx).persist((Object)io);
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot persist new IdentityObject" + io, (Throwable)e);
        }
        return io;
    }

    public void removeIdentityObject(IdentityStoreInvocationContext ctx, IdentityObject identity) throws IdentityException {
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        org.hibernate.Session hibernateSession = this.getHibernateSession(ctx);
        try {
            HibernateIdentityObjectRelationship[] from = new HibernateIdentityObjectRelationship[hibernateObject.getFromRelationships().size()];
            for (HibernateIdentityObjectRelationship relationship : hibernateObject.getFromRelationships().toArray(from)) {
                relationship.getFromIdentityObject().getFromRelationships().remove(relationship);
                relationship.getToIdentityObject().getToRelationships().remove(relationship);
                hibernateSession.delete((Object)relationship);
                hibernateSession.flush();
            }
            HibernateIdentityObjectRelationship[] to = new HibernateIdentityObjectRelationship[hibernateObject.getToRelationships().size()];
            for (HibernateIdentityObjectRelationship relationship : hibernateObject.getToRelationships().toArray(to)) {
                relationship.getFromIdentityObject().getFromRelationships().remove(relationship);
                relationship.getToIdentityObject().getToRelationships().remove(relationship);
                hibernateSession.delete((Object)relationship);
                hibernateSession.flush();
            }
            hibernateSession.delete((Object)hibernateObject);
            hibernateSession.flush();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot remove IdentityObject" + identity, (Throwable)e);
        }
    }

    public int getIdentityObjectsCount(IdentityStoreInvocationContext ctx, IdentityObjectType identityType) throws IdentityException {
        int count;
        this.checkIOType(identityType);
        HibernateIdentityObjectType jpaType = this.getHibernateIdentityObjectType(ctx, identityType);
        org.hibernate.Session hibernateSession = this.getHibernateSession(ctx);
        try {
            count = ((Number)hibernateSession.createQuery("select count(o.id) from HibernateIdentityObject o where o.realm.name = :realmName and o.identityType.name = :typeName").setParameter("typeName", (Object)jpaType.getName()).setParameter("realmName", (Object)this.getRealmName(ctx)).setCacheable(true).uniqueResult()).intValue();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot count stored IdentityObjects with type: " + identityType.getName(), (Throwable)e);
        }
        return count;
    }

    public IdentityObject findIdentityObject(IdentityStoreInvocationContext ctx, String name, IdentityObjectType type) throws IdentityException {
        if (name == null) {
            throw new IllegalArgumentException("IdentityObject name is null");
        }
        this.checkIOType(type);
        HibernateIdentityObjectType hibernateType = this.getHibernateIdentityObjectType(ctx, type);
        HibernateIdentityObject hibernateObject = null;
        try {
            hibernateObject = (HibernateIdentityObject)this.getHibernateSession(ctx).createCriteria(HibernateIdentityObject.class).add((Criterion)Restrictions.eq((String)"name", (Object)name)).createAlias("realm", "rm").add((Criterion)Restrictions.eq((String)"rm.name", (Object)this.getRealmName(ctx))).createAlias("identityType", "type").add((Criterion)Restrictions.eq((String)"type.name", (Object)hibernateType.getName())).setCacheable(true).uniqueResult();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot find IdentityObject with name '" + name + "' and type '" + type.getName() + "'", (Throwable)e);
        }
        if (this.isAllowNotCaseSensitiveSearch()) {
            return hibernateObject;
        }
        if (hibernateObject != null && hibernateObject.getName().equals(name)) {
            return hibernateObject;
        }
        return null;
    }

    public IdentityObject findIdentityObject(IdentityStoreInvocationContext ctx, String id) throws IdentityException {
        HibernateIdentityObject hibernateObject;
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        try {
            hibernateObject = (HibernateIdentityObject)this.getHibernateSession(ctx).get(HibernateIdentityObject.class, (Serializable)new Long(id));
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot find IdentityObject with id: " + id, (Throwable)e);
        }
        return hibernateObject;
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext ctx, IdentityObjectType identityType, IdentityObjectSearchCriteria criteria) throws IdentityException {
        List results;
        this.checkIOType(identityType);
        HibernateIdentityObjectType hibernateType = this.getHibernateIdentityObjectType(ctx, identityType);
        org.hibernate.Session hibernateSession = this.getHibernateSession(ctx);
        try {
            Criteria hc = hibernateSession.createCriteria(HibernateIdentityObject.class).setCacheable(true).createAlias("realm", "rm").add((Criterion)Restrictions.eq((String)"rm.name", (Object)this.getRealmName(ctx))).createAlias("identityType", "type").add((Criterion)Restrictions.eq((String)"type.name", (Object)hibernateType.getName()));
            if (criteria != null && criteria.isSorted()) {
                if (criteria.isAscending()) {
                    hc.addOrder(Order.asc((String)"name"));
                } else {
                    hc.addOrder(Order.desc((String)"name"));
                }
            }
            if (criteria != null && criteria.isPaged() && !criteria.isFiltered()) {
                if (criteria.getMaxResults() > 0) {
                    hc.setMaxResults(criteria.getMaxResults());
                }
                hc.setFirstResult(criteria.getFirstResult());
            }
            if (criteria != null && criteria.getFilter() != null) {
                hc.add((Criterion)Restrictions.like((String)"name", (Object)criteria.getFilter().replaceAll("\\*", "%")));
            } else {
                hc.add((Criterion)Restrictions.like((String)"name", (Object)"%"));
            }
            results = hc.list();
            Hibernate.initialize((Object)results);
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot find IdentityObjects with type '" + identityType.getName() + "'", (Throwable)e);
        }
        if (criteria != null && criteria.isFiltered()) {
            this.filterByAttributesValues(results, criteria.getValues());
            if (criteria.isPaged()) {
                results = (LinkedList)this.cutPageFromResults(results, criteria);
            }
        }
        return results;
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext ctx, IdentityObjectType identityType) throws IdentityException {
        return this.findIdentityObject(ctx, identityType, null);
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        List results;
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        boolean orderByName = false;
        boolean ascending = true;
        if (criteria != null && criteria.isSorted()) {
            orderByName = true;
            ascending = criteria.isAscending();
        }
        try {
            Query q = null;
            StringBuilder hqlString = new StringBuilder("");
            if (parent) {
                if (relationshipType != null) {
                    hqlString.append("select distinct ior.toIdentityObject from HibernateIdentityObjectRelationship ior where ior.toIdentityObject.name like :nameFilter and ior.type.name = :relType and ior.fromIdentityObject = :identity");
                } else {
                    hqlString.append("select distinct ior.toIdentityObject from HibernateIdentityObjectRelationship ior where ior.toIdentityObject.name like :nameFilter and ior.fromIdentityObject = :identity");
                }
                if (orderByName) {
                    hqlString.append(" order by ior.toIdentityObject.name");
                    if (ascending) {
                        hqlString.append(" asc");
                    }
                }
            } else {
                if (relationshipType != null) {
                    hqlString.append("select distinct ior.fromIdentityObject from HibernateIdentityObjectRelationship ior where ior.fromIdentityObject.name like :nameFilter and ior.type.name = :relType and ior.toIdentityObject = :identity");
                } else {
                    hqlString.append("select distinct ior.fromIdentityObject from HibernateIdentityObjectRelationship ior where ior.fromIdentityObject.name like :nameFilter and ior.toIdentityObject = :identity");
                }
                if (orderByName) {
                    hqlString.append(" order by ior.toIdentityObject.name");
                    if (ascending) {
                        hqlString.append(" asc");
                    }
                }
            }
            q = this.getHibernateSession(ctx).createQuery(hqlString.toString()).setParameter("identity", (Object)hibernateObject).setCacheable(true);
            if (relationshipType != null) {
                q.setParameter("relType", (Object)relationshipType.getName());
            }
            if (criteria != null && criteria.getFilter() != null) {
                q.setParameter("nameFilter", (Object)criteria.getFilter().replaceAll("\\*", "%"));
            } else {
                q.setParameter("nameFilter", (Object)"%");
            }
            if (criteria != null && criteria.isPaged() && !criteria.isFiltered()) {
                q.setFirstResult(criteria.getFirstResult());
                if (criteria.getMaxResults() > 0) {
                    q.setMaxResults(criteria.getMaxResults());
                }
            }
            q.setCacheable(true);
            results = q.list();
            Hibernate.initialize((Object)results);
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot find IdentityObjects", (Throwable)e);
        }
        if (criteria != null && criteria.isFiltered()) {
            this.filterByAttributesValues(results, criteria.getValues());
            if (criteria.isPaged()) {
                results = (LinkedList)this.cutPageFromResults(results, criteria);
            }
        }
        return results;
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent) throws IdentityException {
        return this.findIdentityObject(ctx, identity, relationshipType, parent, null);
    }

    public IdentityObjectRelationship createRelationship(IdentityStoreInvocationContext ctx, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String name, boolean createNames) throws IdentityException {
        if (relationshipType == null) {
            throw new IllegalArgumentException("RelationshipType is null");
        }
        HibernateIdentityObject fromIO = this.safeGet(ctx, fromIdentity);
        HibernateIdentityObject toIO = this.safeGet(ctx, toIdentity);
        HibernateIdentityObjectRelationshipType type = this.getHibernateIdentityObjectRelationshipType(ctx, relationshipType);
        HibernateRealm realm = this.getRealm(this.getHibernateSession(ctx), ctx);
        if (!this.getSupportedFeatures().isRelationshipTypeSupported((IdentityObjectType)fromIO.getIdentityType(), (IdentityObjectType)toIO.getIdentityType(), relationshipType) && !this.isAllowNotDefinedIdentityObjectTypes()) {
            throw new IdentityException("Relationship not supported. RelationshipType[ " + relationshipType.getName() + " ] " + "beetween: [ " + fromIO.getIdentityType().getName() + " ] and [ " + toIO.getIdentityType().getName() + " ]");
        }
        HibernateIdentityObjectRelationship relationship = null;
        if (name != null) {
            HibernateIdentityObjectRelationshipName relationshipName = (HibernateIdentityObjectRelationshipName)this.getHibernateSession(ctx).createCriteria(HibernateIdentityObjectRelationshipName.class).setCacheable(true).createAlias("realm", "r").add((Criterion)Restrictions.eq((String)"name", (Object)name)).add((Criterion)Restrictions.eq((String)"r.name", (Object)realm.getName())).uniqueResult();
            if (relationshipName == null) {
                throw new IdentityException("Relationship name not present in the store");
            }
            relationship = new HibernateIdentityObjectRelationship(type, fromIO, toIO, relationshipName);
        } else {
            relationship = new HibernateIdentityObjectRelationship(type, fromIO, toIO);
        }
        try {
            org.hibernate.Session session = this.getHibernateSession(ctx);
            session.persist((Object)relationship);
            session.flush();
        }
        catch (HibernateException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot create relationship: ", (Throwable)e);
        }
        return relationship;
    }

    public void removeRelationship(IdentityStoreInvocationContext ctx, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String name) throws IdentityException {
        if (relationshipType == null) {
            throw new IllegalArgumentException("RelationshipType is null");
        }
        HibernateIdentityObject fromIO = this.safeGet(ctx, fromIdentity);
        HibernateIdentityObject toIO = this.safeGet(ctx, toIdentity);
        HibernateIdentityObjectRelationshipType type = this.getHibernateIdentityObjectRelationshipType(ctx, relationshipType);
        HibernateRealm realm = this.getRealm(this.getHibernateSession(ctx), ctx);
        Object query = null;
        Criteria crit = null;
        if (name == null) {
            crit = this.getHibernateSession(ctx).createCriteria(HibernateIdentityObjectRelationship.class).createAlias("type", "t").add((Criterion)Restrictions.eq((String)"fromIdentityObject", (Object)fromIO)).add((Criterion)Restrictions.eq((String)"toIdentityObject", (Object)toIO)).add((Criterion)Restrictions.eq((String)"t.name", (Object)type.getName())).setCacheable(true);
        } else {
            HibernateIdentityObjectRelationshipName relationshipName = (HibernateIdentityObjectRelationshipName)this.getHibernateSession(ctx).createCriteria(HibernateIdentityObjectRelationshipName.class).add((Criterion)Restrictions.eq((String)"name", (Object)name)).createAlias("realm", "rm").add((Criterion)Restrictions.eq((String)"rm.name", (Object)this.getRealmName(ctx))).uniqueResult();
            if (relationshipName == null) {
                throw new IdentityException("Relationship name not present in the store");
            }
            crit = this.getHibernateSession(ctx).createCriteria(HibernateIdentityObjectRelationship.class).createAlias("type", "t").createAlias("name", "n").add((Criterion)Restrictions.eq((String)"fromIdentityObject", (Object)fromIO)).add((Criterion)Restrictions.eq((String)"toIdentityObject", (Object)toIO)).add((Criterion)Restrictions.eq((String)"t.name", (Object)type.getName())).add((Criterion)Restrictions.eq((String)"n.name", (Object)name)).setCacheable(true);
        }
        HibernateIdentityObjectRelationship relationship = (HibernateIdentityObjectRelationship)crit.uniqueResult();
        if (relationship == null) {
            throw new IdentityException("Relationship not present in the store");
        }
        try {
            fromIO.getFromRelationships().remove(relationship);
            toIO.getToRelationships().remove(relationship);
            this.getHibernateSession(ctx).delete((Object)relationship);
            this.getHibernateSession(ctx).flush();
        }
        catch (HibernateException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot remove relationship");
        }
    }

    public void removeRelationships(IdentityStoreInvocationContext ctx, IdentityObject identity1, IdentityObject identity2, boolean named) throws IdentityException {
        HibernateIdentityObject hio1 = this.safeGet(ctx, identity1);
        HibernateIdentityObject hio2 = this.safeGet(ctx, identity2);
        Criteria criteria = this.getHibernateSession(ctx).createCriteria(HibernateIdentityObjectRelationship.class).setCacheable(true).add((Criterion)Restrictions.or((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"fromIdentityObject", (Object)hio1), (Criterion)Restrictions.eq((String)"toIdentityObject", (Object)hio2)), (Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"fromIdentityObject", (Object)hio2), (Criterion)Restrictions.eq((String)"toIdentityObject", (Object)hio1))));
        List results = criteria.list();
        Hibernate.initialize((Object)results);
        for (HibernateIdentityObjectRelationship relationship : results) {
            if ((!named || relationship.getName() == null) && (named || relationship.getName() != null)) continue;
            try {
                relationship.getFromIdentityObject().getFromRelationships().remove(relationship);
                relationship.getToIdentityObject().getToRelationships().remove(relationship);
                this.getHibernateSession(ctx).delete((Object)relationship);
                this.getHibernateSession(ctx).flush();
            }
            catch (HibernateException e) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Exception occurred: ", e);
                }
                throw new IdentityException("Cannot remove relationship");
            }
        }
    }

    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext ctx, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType) throws IdentityException {
        HibernateIdentityObject hio1 = this.safeGet(ctx, fromIdentity);
        HibernateIdentityObject hio2 = this.safeGet(ctx, toIdentity);
        Criteria criteria = this.getHibernateSession(ctx).createCriteria(HibernateIdentityObjectRelationship.class).setCacheable(true);
        if (relationshipType != null) {
            criteria.createAlias("type", "t").add((Criterion)Restrictions.eq((String)"t.name", (Object)relationshipType.getName()));
        }
        criteria.add((Criterion)Restrictions.eq((String)"fromIdentityObject", (Object)hio1)).add((Criterion)Restrictions.eq((String)"toIdentityObject", (Object)hio2));
        List results = criteria.list();
        Hibernate.initialize((Object)results);
        return new HashSet<IdentityObjectRelationship>(results);
    }

    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType type, boolean parent, boolean named, String name) throws IdentityException {
        HibernateIdentityObject hio = this.safeGet(ctx, identity);
        Criteria criteria = this.getHibernateSession(ctx).createCriteria(HibernateIdentityObjectRelationship.class);
        criteria.setCacheable(true);
        if (type != null) {
            HibernateIdentityObjectRelationshipType hibernateType = this.getHibernateIdentityObjectRelationshipType(ctx, type);
            criteria.add((Criterion)Restrictions.eq((String)"type", (Object)hibernateType));
        }
        if (name != null) {
            criteria.add((Criterion)Restrictions.eq((String)"name.name", (Object)name));
        } else if (named) {
            criteria.add(Restrictions.isNotNull((String)"name"));
        } else {
            criteria.add(Restrictions.isNull((String)"name"));
        }
        if (parent) {
            criteria.add((Criterion)Restrictions.eq((String)"fromIdentityObject", (Object)hio));
        } else {
            criteria.add((Criterion)Restrictions.eq((String)"toIdentityObject", (Object)hio));
        }
        List results = criteria.list();
        Hibernate.initialize((Object)results);
        return new HashSet<IdentityObjectRelationship>(results);
    }

    public String createRelationshipName(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        org.hibernate.Session hibernateSession = this.getHibernateSession(ctx);
        HibernateRealm realm = this.getRealm(hibernateSession, ctx);
        try {
            HibernateIdentityObjectRelationshipName hiorn = (HibernateIdentityObjectRelationshipName)hibernateSession.createQuery("select rn from HibernateIdentityObjectRelationshipName rn where rn.name like :name and rn.realm.name = :realmName").setParameter("name", (Object)name).setParameter("realmName", (Object)realm.getName()).uniqueResult();
            if (hiorn != null) {
                throw new IdentityException("Relationship name already exists");
            }
            hiorn = new HibernateIdentityObjectRelationshipName(name, realm);
            this.getHibernateSession(ctx).persist((Object)hiorn);
            this.getHibernateSession(ctx).flush();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot create new relationship name: " + name, (Throwable)e);
        }
        return name;
    }

    public String removeRelationshipName(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        org.hibernate.Session hibernateSession = this.getHibernateSession(ctx);
        try {
            HibernateIdentityObjectRelationshipName hiorn = (HibernateIdentityObjectRelationshipName)hibernateSession.createCriteria(HibernateIdentityObjectRelationshipName.class).createAlias("realm", "rm").add((Criterion)Restrictions.eq((String)"name", (Object)name)).add((Criterion)Restrictions.eq((String)"rm.name", (Object)this.getRealmName(ctx))).setCacheable(true).uniqueResult();
            if (hiorn == null) {
                throw new IdentityException("Relationship name doesn't exist");
            }
            List rels = hibernateSession.createCriteria(HibernateIdentityObjectRelationship.class).add((Criterion)Restrictions.eq((String)"name", (Object)hiorn)).setCacheable(true).list();
            Hibernate.initialize((Object)rels);
            for (HibernateIdentityObjectRelationship rel : rels) {
                this.getHibernateSession(ctx).delete((Object)rel);
            }
            this.getHibernateSession(ctx).delete((Object)hiorn);
            this.getHibernateSession(ctx).flush();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot remove new relationship name: " + name, (Throwable)e);
        }
        return name;
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObjectSearchCriteria criteria) throws IdentityException, OperationNotSupportedException {
        HashSet<String> names = null;
        org.hibernate.Session hibernateSession = this.getHibernateSession(ctx);
        try {
            Criteria c = hibernateSession.createCriteria(HibernateIdentityObjectRelationshipName.class).setCacheable(true).createAlias("realm", "r").setProjection((Projection)Projections.property((String)"name"));
            if (criteria != null && criteria.isSorted()) {
                if (criteria.isAscending()) {
                    c.addOrder(Order.asc((String)"name"));
                } else {
                    c.addOrder(Order.desc((String)"name"));
                }
            }
            c.add((Criterion)Restrictions.eq((String)"r.name", (Object)this.getRealmName(ctx)));
            if (criteria != null && criteria.getFilter() != null) {
                c.add((Criterion)Restrictions.like((String)"name", (Object)criteria.getFilter().replaceAll("\\*", "%")));
            } else {
                c.add((Criterion)Restrictions.like((String)"name", (Object)"%"));
            }
            if (criteria != null && criteria.isPaged()) {
                c.setFirstResult(criteria.getMaxResults());
                if (criteria.getFirstResult() > 0) {
                    c.setMaxResults(criteria.getMaxResults());
                }
            }
            List results = c.list();
            Hibernate.initialize((Object)results);
            names = new HashSet<String>(results);
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot get relationship names. ", (Throwable)e);
        }
        return names;
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx) throws IdentityException, OperationNotSupportedException {
        return this.getRelationshipNames(ctx, (IdentityObjectSearchCriteria)null);
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectSearchCriteria criteria) throws IdentityException, OperationNotSupportedException {
        HashSet<String> names;
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        org.hibernate.Session hibernateSession = this.getHibernateSession(ctx);
        try {
            Criteria c = hibernateSession.createCriteria(HibernateIdentityObjectRelationship.class).setCacheable(true).createAlias("name", "n").setProjection((Projection)Projections.property((String)"n.name"));
            if (criteria != null) {
                if (criteria.isAscending()) {
                    c.addOrder(Order.asc((String)"n.name"));
                } else {
                    c.addOrder(Order.desc((String)"n.name"));
                }
            }
            c.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"fromIdentityObject", (Object)hibernateObject), (Criterion)Restrictions.eq((String)"toIdentityObject", (Object)hibernateObject)));
            if (criteria != null && criteria.isPaged()) {
                c.setFirstResult(criteria.getFirstResult());
                if (criteria.getMaxResults() > 0) {
                    c.setMaxResults(criteria.getMaxResults());
                }
            }
            List results = c.list();
            Hibernate.initialize((Object)results);
            names = new HashSet<String>(results);
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot get relationship names. ", (Throwable)e);
        }
        return names;
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObject identity) throws IdentityException, OperationNotSupportedException {
        return this.getRelationshipNames(ctx, identity, null);
    }

    public Map<String, String> getRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        org.hibernate.Session hibernateSession = this.getHibernateSession(ctx);
        try {
            HibernateIdentityObjectRelationshipName hiorn = (HibernateIdentityObjectRelationshipName)hibernateSession.createCriteria(HibernateIdentityObjectRelationshipName.class).setCacheable(true).createAlias("realm", "r").add((Criterion)Restrictions.eq((String)"name", (Object)name)).add((Criterion)Restrictions.eq((String)"r.name", (Object)this.getRealmName(ctx))).uniqueResult();
            if (hiorn == null) {
                throw new IdentityException("Relationship name doesn't exist");
            }
            Hibernate.initialize(hiorn.getProperties());
            return new HashMap<String, String>(hiorn.getProperties());
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot get relationship name properties: " + name, (Throwable)e);
        }
    }

    public void setRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Map<String, String> properties) throws IdentityException, OperationNotSupportedException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        org.hibernate.Session hibernateSession = this.getHibernateSession(ctx);
        try {
            HibernateIdentityObjectRelationshipName hiorn = (HibernateIdentityObjectRelationshipName)hibernateSession.createCriteria(HibernateIdentityObjectRelationshipName.class).setCacheable(true).createAlias("realm", "r").add((Criterion)Restrictions.eq((String)"name", (Object)name)).add((Criterion)Restrictions.eq((String)"r.name", (Object)this.getRealmName(ctx))).uniqueResult();
            if (hiorn == null) {
                throw new IdentityException("Relationship name doesn't exist");
            }
            hiorn.getProperties().putAll(properties);
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot set relationship name properties: " + name, (Throwable)e);
        }
    }

    public void removeRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Set<String> properties) throws IdentityException, OperationNotSupportedException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        org.hibernate.Session hibernateSession = this.getHibernateSession(ctx);
        try {
            HibernateIdentityObjectRelationshipName hiorn = (HibernateIdentityObjectRelationshipName)hibernateSession.createCriteria(HibernateIdentityObjectRelationshipName.class).setCacheable(true).createAlias("realm", "r").add((Criterion)Restrictions.eq((String)"name", (Object)name)).add((Criterion)Restrictions.eq((String)"r.name", (Object)this.getRealmName(ctx))).uniqueResult();
            if (hiorn == null) {
                throw new IdentityException("Relationship name doesn't exist");
            }
            Hibernate.initialize(hiorn.getProperties());
            for (String property : properties) {
                hiorn.getProperties().remove(property);
            }
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot remove relationship name properties: " + name, (Throwable)e);
        }
    }

    public Map<String, String> getRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship) throws IdentityException, OperationNotSupportedException {
        HibernateIdentityObject fromIO = this.safeGet(ctx, relationship.getFromIdentityObject());
        HibernateIdentityObject toIO = this.safeGet(ctx, relationship.getToIdentityObject());
        HibernateIdentityObjectRelationshipType type = this.getHibernateIdentityObjectRelationshipType(ctx, relationship.getType());
        Criteria criteria = this.getHibernateSession(ctx).createCriteria(HibernateIdentityObjectRelationship.class).setCacheable(true).createAlias("type", "t").add((Criterion)Restrictions.eq((String)"t.name", (Object)type.getName())).add((Criterion)Restrictions.eq((String)"fromIdentityObject", (Object)fromIO)).add((Criterion)Restrictions.eq((String)"toIdentityObject", (Object)toIO));
        if (relationship.getName() != null) {
            HibernateIdentityObjectRelationshipName relationshipName = (HibernateIdentityObjectRelationshipName)this.getHibernateSession(ctx).createCriteria(HibernateIdentityObjectRelationshipName.class).add((Criterion)Restrictions.eq((String)"name", (Object)relationship.getName())).setCacheable(true).uniqueResult();
            if (relationshipName == null) {
                throw new IdentityException("Relationship name not present in the store");
            }
            criteria.createAlias("name", "n").add((Criterion)Restrictions.eq((String)"n.name", (Object)relationship.getName()));
        }
        try {
            HibernateIdentityObjectRelationship hibernateRelationship = (HibernateIdentityObjectRelationship)criteria.uniqueResult();
            Hibernate.initialize(hibernateRelationship.getProperties());
            return new HashMap<String, String>(hibernateRelationship.getProperties());
        }
        catch (HibernateException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot obtain relationship properties: ", (Throwable)e);
        }
    }

    public void setRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Map<String, String> properties) throws IdentityException, OperationNotSupportedException {
        HibernateIdentityObject fromIO = this.safeGet(ctx, relationship.getFromIdentityObject());
        HibernateIdentityObject toIO = this.safeGet(ctx, relationship.getToIdentityObject());
        HibernateIdentityObjectRelationshipType type = this.getHibernateIdentityObjectRelationshipType(ctx, relationship.getType());
        Criteria criteria = this.getHibernateSession(ctx).createCriteria(HibernateIdentityObjectRelationship.class).setCacheable(true).createAlias("type", "t").add((Criterion)Restrictions.eq((String)"t.name", (Object)type.getName())).add((Criterion)Restrictions.eq((String)"fromIdentityObject", (Object)fromIO)).add((Criterion)Restrictions.eq((String)"toIdentityObject", (Object)toIO));
        if (relationship.getName() != null) {
            HibernateIdentityObjectRelationshipName relationshipName = (HibernateIdentityObjectRelationshipName)this.getHibernateSession(ctx).createCriteria(HibernateIdentityObjectRelationshipName.class).add((Criterion)Restrictions.eq((String)"name", (Object)relationship.getName())).setCacheable(true).uniqueResult();
            if (relationshipName == null) {
                throw new IdentityException("Relationship name not present in the store");
            }
            criteria.createAlias("name", "n").add((Criterion)Restrictions.eq((String)"n.name", (Object)relationship.getName()));
        }
        try {
            HibernateIdentityObjectRelationship hibernateRelationship = (HibernateIdentityObjectRelationship)criteria.uniqueResult();
            hibernateRelationship.getProperties().putAll(properties);
        }
        catch (HibernateException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot update relationship properties: ", (Throwable)e);
        }
    }

    public void removeRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Set<String> properties) throws IdentityException, OperationNotSupportedException {
        HibernateIdentityObject fromIO = this.safeGet(ctx, relationship.getFromIdentityObject());
        HibernateIdentityObject toIO = this.safeGet(ctx, relationship.getToIdentityObject());
        HibernateIdentityObjectRelationshipType type = this.getHibernateIdentityObjectRelationshipType(ctx, relationship.getType());
        Criteria criteria = this.getHibernateSession(ctx).createCriteria(HibernateIdentityObjectRelationship.class).setCacheable(true).createAlias("type", "t").add((Criterion)Restrictions.eq((String)"t.name", (Object)type.getName())).add((Criterion)Restrictions.eq((String)"fromIdentityObject", (Object)fromIO)).add((Criterion)Restrictions.eq((String)"toIdentityObject", (Object)toIO));
        if (relationship.getName() == null) {
            HibernateIdentityObjectRelationshipName relationshipName = (HibernateIdentityObjectRelationshipName)this.getHibernateSession(ctx).createCriteria(HibernateIdentityObjectRelationshipName.class).add((Criterion)Restrictions.eq((String)"name", (Object)relationship.getName())).setCacheable(true).uniqueResult();
            if (relationshipName == null) {
                throw new IdentityException("Relationship name not present in the store");
            }
            criteria.createAlias("name", "n").add((Criterion)Restrictions.eq((String)"n.name", (Object)relationship.getName()));
        }
        try {
            HibernateIdentityObjectRelationship hibernateRelationship = (HibernateIdentityObjectRelationship)criteria.uniqueResult();
            Hibernate.initialize(hibernateRelationship.getProperties());
            for (String property : properties) {
                hibernateRelationship.getProperties().remove(property);
            }
        }
        catch (HibernateException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot update relationship properties: ", (Throwable)e);
        }
    }

    public Set<String> getSupportedAttributeNames(IdentityStoreInvocationContext ctx, IdentityObjectType identityType) throws IdentityException {
        this.checkIOType(identityType);
        if (this.attributeMappings.containsKey(identityType.getName())) {
            return this.attributeMappings.get(identityType.getName());
        }
        return new HashSet<String>();
    }

    public IdentityObjectAttribute getAttribute(IdentityStoreInvocationContext ctx, IdentityObject identity, String name) throws IdentityException {
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        Set<HibernateIdentityObjectAttribute> storeAttributes = hibernateObject.getAttributes();
        Hibernate.initialize(storeAttributes);
        for (HibernateIdentityObjectAttribute attribute : storeAttributes) {
            String mappedName = this.resolveAttributeNameFromStoreMapping(identity.getIdentityType(), name);
            if (mappedName == null) continue;
            return attribute;
        }
        return null;
    }

    public Map<String, IdentityObjectAttribute> getAttributes(IdentityStoreInvocationContext ctx, IdentityObject identity) throws IdentityException {
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        HashMap<String, IdentityObjectAttribute> result = new HashMap<String, IdentityObjectAttribute>();
        if (hibernateObject == null) {
            return result;
        }
        Set<HibernateIdentityObjectAttribute> storeAttributes = hibernateObject.getAttributes();
        Hibernate.initialize(storeAttributes);
        for (HibernateIdentityObjectAttribute attribute : storeAttributes) {
            String name = this.resolveAttributeNameFromStoreMapping(identity.getIdentityType(), attribute.getName());
            if (name == null) continue;
            result.put(name, attribute);
        }
        return result;
    }

    public Map<String, IdentityObjectAttributeMetaData> getAttributesMetaData(IdentityStoreInvocationContext invocationContext, IdentityObjectType identityType) {
        return this.attributesMetaData.get(identityType.getName());
    }

    public void updateAttributes(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        if (attributes == null) {
            throw new IllegalArgumentException("attributes are null");
        }
        HashMap<String, IdentityObjectAttribute> mappedAttributes = new HashMap<String, IdentityObjectAttribute>();
        Map<String, IdentityObjectAttributeMetaData> mdMap = this.attributesMetaData.get(identity.getIdentityType().getName());
        for (IdentityObjectAttribute attribute : attributes) {
            IdentityObject checkIdentity;
            String name = this.resolveAttributeStoreMapping(identity.getIdentityType(), attribute.getName());
            mappedAttributes.put(name, attribute);
            if (!(mdMap != null && mdMap.containsKey(attribute.getName()) || this.isAllowNotDefinedAttributes)) {
                throw new IdentityException("Cannot add not defined attribute. Use 'allowNotDefinedAttributes' option if needed. Attribute name: " + attribute.getName());
            }
            if (mdMap == null || !mdMap.containsKey(attribute.getName())) continue;
            IdentityObjectAttributeMetaData amd = mdMap.get(attribute.getName());
            if (!amd.isMultivalued() && attribute.getSize() > 1) {
                throw new IdentityException("Cannot assigned multiply values to single valued attribute: " + attribute.getName());
            }
            if (amd.isReadonly()) {
                mappedAttributes.remove(name);
                continue;
            }
            if (amd.isUnique() && (checkIdentity = this.findIdentityObjectByUniqueAttribute(ctx, identity.getIdentityType(), attribute)) != null && !checkIdentity.getName().equals(identity.getName())) {
                throw new IdentityException("Unique attribute '" + attribute.getName() + " value already set for identityObject: " + checkIdentity);
            }
            String type = amd.getType();
            for (HibernateIdentityObjectAttribute value : attribute.getValues()) {
                if (type.equals("text") && !(value instanceof String)) {
                    throw new IdentityException("Cannot update text type attribute with not String type value: " + attribute.getName() + " / " + value);
                }
                if (!type.equals("binary") || value instanceof byte[]) continue;
                throw new IdentityException("Cannot update binary type attribute with not byte[] type value: " + attribute.getName() + " / " + value);
            }
            if (!type.equals("binary") || attribute.getValues().size() <= 1) continue;
            throw new IdentityException("Cannot add binary type attribute with more than one value - this implementationsupport only single value binary attributes: " + attribute.getName());
        }
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        Hibernate.initialize(hibernateObject.getAttributes());
        for (String name : mappedAttributes.keySet()) {
            IdentityObjectAttribute attribute;
            attribute = (IdentityObjectAttribute)mappedAttributes.get(name);
            IdentityObjectAttributeMetaData amd = null;
            if (mdMap != null) {
                amd = mdMap.get(attribute.getName());
            }
            String type = amd != null ? amd.getType() : "text";
            boolean present = false;
            for (HibernateIdentityObjectAttribute storeAttribute : hibernateObject.getAttributes()) {
                if (!storeAttribute.getName().equals(name)) continue;
                present = true;
                if (storeAttribute.getType().equals("text")) {
                    if (!type.equals("text")) {
                        throw new IdentityException("Wrong attribute mapping. Attribute persisted as text is mapped with: " + type + ". Attribute name: " + name);
                    }
                    HashSet<String> v = new HashSet<String>();
                    for (Object value : attribute.getValues()) {
                        v.add(value.toString());
                    }
                    storeAttribute.setTextValues(v);
                    break;
                }
                if (storeAttribute.getType().equals("binary")) {
                    if (!type.equals("binary")) {
                        throw new IdentityException("Wrong attribute mapping. Attribute persisted as binary is mapped with: " + type + ". Attribute name: " + name);
                    }
                    HibernateIdentityObjectAttributeBinaryValue bv = new HibernateIdentityObjectAttributeBinaryValue((byte[])attribute.getValue());
                    this.getHibernateSession(ctx).persist((Object)bv);
                    storeAttribute.setBinaryValue(bv);
                    break;
                }
                throw new IdentityException("Internal identity store error");
            }
            if (present || attribute.getValues() == null || attribute.getValues().size() <= 0) continue;
            HibernateIdentityObjectAttribute newAttribute = new HibernateIdentityObjectAttribute(hibernateObject, name, type);
            if (type.equals("text")) {
                newAttribute.setTextValues(attribute.getValues());
            } else if (type.equals("binary")) {
                HibernateIdentityObjectAttributeBinaryValue bv = new HibernateIdentityObjectAttributeBinaryValue((byte[])attribute.getValue());
                this.getHibernateSession(ctx).persist((Object)bv);
                newAttribute.setBinaryValue(bv);
            }
            hibernateObject.addAttribute(newAttribute);
        }
    }

    public void addAttributes(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        if (attributes == null) {
            throw new IllegalArgumentException("attributes are null");
        }
        HashMap<String, IdentityObjectAttribute> mappedAttributes = new HashMap<String, IdentityObjectAttribute>();
        Map<String, IdentityObjectAttributeMetaData> mdMap = this.attributesMetaData.get(identity.getIdentityType().getName());
        org.hibernate.Session hibernateSession = this.getHibernateSession(ctx);
        for (IdentityObjectAttribute attribute : attributes) {
            IdentityObject checkIdentity;
            String name = this.resolveAttributeStoreMapping(identity.getIdentityType(), attribute.getName());
            mappedAttributes.put(name, attribute);
            if (!(mdMap != null && mdMap.containsKey(attribute.getName()) || this.isAllowNotDefinedAttributes)) {
                throw new IdentityException("Cannot add not defined attribute. Use 'allowNotDefinedAttributes' option if needed. Attribute name: " + attribute.getName());
            }
            IdentityObjectAttributeMetaData amd = null;
            if (mdMap != null) {
                amd = mdMap.get(attribute.getName());
            }
            if (amd == null) continue;
            if (!amd.isMultivalued() && attribute.getSize() > 1) {
                throw new IdentityException("Cannot add multiply values to single valued attribute: " + attribute.getName());
            }
            if (amd.isReadonly()) {
                mappedAttributes.remove(name);
                continue;
            }
            if (amd.isUnique() && (checkIdentity = this.findIdentityObjectByUniqueAttribute(ctx, identity.getIdentityType(), attribute)) != null && !checkIdentity.getName().equals(identity.getName())) {
                throw new IdentityException("Unique attribute '" + attribute.getName() + " value already set for identityObject: " + checkIdentity);
            }
            String type = amd.getType();
            for (HibernateIdentityObjectAttribute value : attribute.getValues()) {
                if (type.equals("text") && !(value instanceof String)) {
                    throw new IdentityException("Cannot add text type attribute with not String type value: " + attribute.getName() + " / " + value);
                }
                if (!type.equals("binary") || value instanceof byte[]) continue;
                throw new IdentityException("Cannot add binary type attribute with not byte[] type value: " + attribute.getName() + " / " + value);
            }
            if (!type.equals("binary") || attribute.getValues().size() <= 1) continue;
            throw new IdentityException("Cannot add binary type attribute with more than one value - this implementationsupport only single value binary attributes: " + attribute.getName());
        }
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        Hibernate.initialize(hibernateObject.getAttributes());
        for (String name : mappedAttributes.keySet()) {
            HashSet<String> values;
            IdentityObjectAttribute attribute;
            attribute = (IdentityObjectAttribute)mappedAttributes.get(name);
            IdentityObjectAttributeMetaData amd = mdMap != null ? mdMap.get(attribute.getName()) : null;
            String type = amd != null ? amd.getType() : "text";
            HibernateIdentityObjectAttribute hibernateAttribute = null;
            for (HibernateIdentityObjectAttribute storeAttribute : hibernateObject.getAttributes()) {
                if (!storeAttribute.getName().equals(name)) continue;
                hibernateAttribute = storeAttribute;
                break;
            }
            if (hibernateAttribute != null) {
                if (hibernateAttribute.getType().equals("text")) {
                    if (!type.equals("text")) {
                        throw new IdentityException("Wrong attribute mapping. Attribute persisted as text is mapped with: " + type + ". Attribute name: " + name);
                    }
                    HashSet<String> mergedValues = new HashSet<String>(hibernateAttribute.getValues());
                    for (Object value : attribute.getValues()) {
                        mergedValues.add(value.toString());
                    }
                    hibernateAttribute.setTextValues(mergedValues);
                    break;
                }
                if (hibernateAttribute.getType().equals("binary")) {
                    if (!type.equals("binary")) {
                        throw new IdentityException("Wrong attribute mapping. Attribute persisted as binary is mapped with: " + type + ". Attribute name: " + name);
                    }
                    HibernateIdentityObjectAttributeBinaryValue bv = new HibernateIdentityObjectAttributeBinaryValue((byte[])attribute.getValue());
                    this.getHibernateSession(ctx).persist((Object)bv);
                    hibernateAttribute.setBinaryValue(bv);
                    break;
                }
                throw new IdentityException("Internal identity store error");
            }
            if (type.equals("text")) {
                values = new HashSet<String>();
                for (Object value : attribute.getValues()) {
                    values.add(value.toString());
                }
                hibernateAttribute = new HibernateIdentityObjectAttribute(hibernateObject, name, "text");
                hibernateAttribute.setTextValues(values);
            } else if (type.equals("binary")) {
                values = new HashSet();
                for (Object value : attribute.getValues()) {
                    values.add((String)((byte[])value));
                }
                hibernateAttribute = new HibernateIdentityObjectAttribute(hibernateObject, name, "binary");
                HibernateIdentityObjectAttributeBinaryValue bv = new HibernateIdentityObjectAttributeBinaryValue((byte[])attribute.getValue());
                this.getHibernateSession(ctx).persist((Object)bv);
                hibernateAttribute.setBinaryValue(bv);
            }
            hibernateObject.addAttribute(hibernateAttribute);
        }
    }

    public void removeAttributes(IdentityStoreInvocationContext ctx, IdentityObject identity, String[] attributes) throws IdentityException {
        if (attributes == null) {
            throw new IllegalArgumentException("attributes are null");
        }
        String[] mappedAttributes = new String[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            String name;
            mappedAttributes[i] = name = this.resolveAttributeStoreMapping(identity.getIdentityType(), attributes[i]);
            Map<String, IdentityObjectAttributeMetaData> mdMap = this.attributesMetaData.get(identity.getIdentityType().getName());
            if (mdMap != null) {
                IdentityObjectAttributeMetaData amd = mdMap.get(attributes[i]);
                if (amd == null || !amd.isRequired()) continue;
                throw new IdentityException("Cannot remove required attribute: " + attributes[i]);
            }
            if (this.isAllowNotDefinedAttributes) continue;
            throw new IdentityException("Cannot remove not defined attribute. Use 'allowNotDefinedAttributes' option if needed. Attribute name: " + attributes[i]);
        }
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        Hibernate.initialize(hibernateObject.getAttributes());
        for (String attr : mappedAttributes) {
            hibernateObject.removeAttribute(attr);
        }
    }

    public IdentityObject findIdentityObjectByUniqueAttribute(IdentityStoreInvocationContext invocationCtx, IdentityObjectType identityObjectType, IdentityObjectAttribute attribute) throws IdentityException {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        this.checkIOType(identityObjectType);
        String attrMappedName = this.resolveAttributeStoreMapping(identityObjectType, attribute.getName());
        HibernateIdentityObjectType hiot = this.getHibernateIdentityObjectType(invocationCtx, identityObjectType);
        org.hibernate.Session session = this.getHibernateSession(invocationCtx);
        HibernateRealm realm = this.getRealm(session, invocationCtx);
        if (attribute.getValues() == null || attribute.getValues().size() == 0) {
            return null;
        }
        boolean attrDuctTypeText = true;
        if (attribute.getValue() instanceof byte[]) {
            attrDuctTypeText = false;
        }
        StringBuffer queryString = new StringBuffer("select a from HibernateIdentityObjectAttribute a where a.identityObject.identityType = :identityType and a.name = :attributeName and a.identityObject.realm = :realm");
        if (attrDuctTypeText) {
            for (int i = 0; i < attribute.getValues().size(); ++i) {
                String paramName = " :value" + i;
                queryString.append(" and").append(paramName).append(" = any elements(a.textValues)");
            }
        } else {
            queryString.append(" and :value = a.binaryValue");
        }
        Query q = session.createQuery(queryString.toString());
        q.setParameter("identityType", (Object)hiot).setParameter("attributeName", (Object)attrMappedName).setParameter("realm", (Object)realm);
        if (attrDuctTypeText) {
            int i = 0;
            for (Object o : attribute.getValues()) {
                String value = o.toString();
                String paramName = "value" + i;
                q.setParameter(paramName, (Object)value);
                ++i;
            }
        } else {
            q.setParameter("value", attribute.getValue());
        }
        List attrs = q.list();
        if (attrs.size() == 0) {
            return null;
        }
        if (attrs.size() > 1) {
            throw new IdentityException("Illegal state - more than one IdentityObject with the same unique attribute value: " + attribute);
        }
        return ((HibernateIdentityObjectAttribute)attrs.get(0)).getIdentityObject();
    }

    public boolean validateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        if (credential == null) {
            throw new IllegalArgumentException();
        }
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identityObject);
        if (this.supportedFeatures.isCredentialSupported((IdentityObjectType)hibernateObject.getIdentityType(), credential.getType())) {
            HibernateIdentityObjectCredential hibernateCredential = null;
            hibernateCredential = (HibernateIdentityObjectCredential)this.getHibernateSession(ctx).createCriteria(HibernateIdentityObjectCredential.class).createAlias("type", "t").add((Criterion)Restrictions.eq((String)"t.name", (Object)credential.getType().getName())).add((Criterion)Restrictions.eq((String)"identityObject", (Object)hibernateObject)).setCacheable(true).uniqueResult();
            if (hibernateCredential == null) {
                return false;
            }
            Object value = null;
            value = credential.getEncodedValue() != null ? credential.getEncodedValue() : credential.getValue();
            if (value instanceof String && hibernateCredential.getTextValue() != null) {
                return value.toString().equals(hibernateCredential.getTextValue());
            }
            if (value instanceof byte[] && hibernateCredential.getBinaryValue() != null) {
                return Arrays.equals((byte[])value, hibernateCredential.getBinaryValue().getValue());
            }
            throw new IdentityException("Not supported credential value: " + value.getClass());
        }
        throw new IdentityException("CredentialType not supported for a given IdentityObjectType");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        if (credential == null) {
            throw new IllegalArgumentException();
        }
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identityObject);
        org.hibernate.Session hibernateSession = this.getHibernateSession(ctx);
        if (!this.supportedFeatures.isCredentialSupported((IdentityObjectType)hibernateObject.getIdentityType(), credential.getType())) throw new IdentityException("CredentialType not supported for a given IdentityObjectType");
        HibernateIdentityObjectCredentialType hibernateCredentialType = this.getHibernateIdentityObjectCredentialType(ctx, credential.getType());
        if (hibernateCredentialType == null) {
            throw new IllegalStateException("Credential type not present in this store: " + credential.getType().getName());
        }
        HibernateIdentityObjectCredential hibernateCredential = hibernateObject.getCredential(credential.getType());
        if (hibernateCredential == null) {
            hibernateCredential = new HibernateIdentityObjectCredential();
            hibernateCredential.setType(hibernateCredentialType);
            hibernateObject.addCredential(hibernateCredential);
        }
        Object value = null;
        value = credential.getEncodedValue() != null ? credential.getEncodedValue() : credential.getValue();
        if (value instanceof String) {
            hibernateCredential.setTextValue(value.toString());
        } else {
            if (!(value instanceof byte[])) throw new IdentityException("Not supported credential value: " + value.getClass());
            HibernateIdentityObjectCredentialBinaryValue bv = new HibernateIdentityObjectCredentialBinaryValue((byte[])value);
            this.getHibernateSession(ctx).persist((Object)bv);
            hibernateCredential.setBinaryValue(bv);
        }
        hibernateSession.persist((Object)hibernateCredential);
        hibernateObject.addCredential(hibernateCredential);
        hibernateSession.flush();
    }

    public void addIdentityObjectType(IdentityStoreInvocationContext ctx, IdentityObjectType type) throws IdentityException {
        HibernateIdentityObjectType hibernateType = new HibernateIdentityObjectType(type);
        this.getHibernateSession(ctx).persist((Object)hibernateType);
        this.getHibernateSession(ctx).flush();
    }

    public void addIdentityObjectRelationshipType(IdentityStoreInvocationContext ctx, IdentityObjectRelationshipType type) throws IdentityException {
        HibernateIdentityObjectRelationshipType hibernateType = new HibernateIdentityObjectRelationshipType(type);
        this.getHibernateSession(ctx).persist((Object)hibernateType);
        this.getHibernateSession(ctx).flush();
    }

    protected org.hibernate.Session getHibernateSession(IdentityStoreInvocationContext ctx) throws IdentityException {
        try {
            return (org.hibernate.Session)ctx.getIdentityStoreSession().getSessionContext();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot obtain Hibernate Session", (Throwable)e);
        }
    }

    private void checkIOInstance(IdentityObject io) {
        if (io == null) {
            throw new IllegalArgumentException("IdentityObject is null");
        }
    }

    private HibernateIdentityObject safeGet(IdentityStoreInvocationContext ctx, IdentityObject io) throws IdentityException {
        this.checkIOInstance(io);
        if (io instanceof HibernateIdentityObject) {
            return (HibernateIdentityObject)io;
        }
        return this.getHibernateIdentityObject(ctx, io);
    }

    private void checkIOType(IdentityObjectType iot) throws IdentityException {
        if (iot == null) {
            throw new IllegalArgumentException("IdentityObjectType is null");
        }
        if (!this.getSupportedFeatures().isIdentityObjectTypeSupported(iot) && !this.isAllowNotDefinedIdentityObjectTypes()) {
            throw new IdentityException("IdentityType not supported by this IdentityStore implementation: " + iot);
        }
    }

    private HibernateIdentityObjectType getHibernateIdentityObjectType(IdentityStoreInvocationContext ctx, IdentityObjectType type) throws IdentityException {
        this.checkIOType(type);
        HibernateIdentityObjectType hibernateType = null;
        org.hibernate.Session hibernateSession = this.getHibernateSession(ctx);
        try {
            Criteria crit = hibernateSession.createCriteria(HibernateIdentityObjectType.class).add((Criterion)Restrictions.eq((String)"name", (Object)type.getName())).setCacheable(true);
            hibernateType = (HibernateIdentityObjectType)crit.uniqueResult();
            if (hibernateType == null) {
                if (this.isAllowNotDefinedIdentityObjectTypes()) {
                    this.populateObjectTypes(hibernateSession, new String[]{type.getName()});
                }
                hibernateType = (HibernateIdentityObjectType)crit.uniqueResult();
            }
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("IdentityObjectType[" + type.getName() + "] not present in the store.", (Throwable)e);
        }
        if (hibernateType == null) {
            throw new IdentityException("IdentityObjectType[" + type.getName() + "] not present in the store.");
        }
        return hibernateType;
    }

    private HibernateIdentityObject getHibernateIdentityObject(IdentityStoreInvocationContext ctx, IdentityObject io) throws IdentityException {
        HibernateIdentityObject hibernateObject = null;
        org.hibernate.Session hibernateSession = this.getHibernateSession(ctx);
        try {
            hibernateObject = (HibernateIdentityObject)hibernateSession.createCriteria(HibernateIdentityObject.class).add((Criterion)Restrictions.eq((String)"name", (Object)io.getName())).createAlias("identityType", "type").add((Criterion)Restrictions.eq((String)"type.name", (Object)io.getIdentityType().getName())).createAlias("realm", "rm").add((Criterion)Restrictions.eq((String)"rm.name", (Object)this.getRealmName(ctx))).setCacheable(true).uniqueResult();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("IdentityObject[ " + io.getName() + " | " + io.getIdentityType().getName() + "] not present in the store.", (Throwable)e);
        }
        return hibernateObject;
    }

    private HibernateIdentityObjectRelationshipType getHibernateIdentityObjectRelationshipType(IdentityStoreInvocationContext ctx, IdentityObjectRelationshipType iot) throws IdentityException {
        HibernateIdentityObjectRelationshipType relationshipType = null;
        org.hibernate.Session hibernateSession = this.getHibernateSession(ctx);
        try {
            relationshipType = (HibernateIdentityObjectRelationshipType)hibernateSession.createCriteria(HibernateIdentityObjectRelationshipType.class).add((Criterion)Restrictions.eq((String)"name", (Object)iot.getName())).setCacheable(true).uniqueResult();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("IdentityObjectRelationshipType[ " + iot.getName() + "] not present in the store.");
        }
        return relationshipType;
    }

    private HibernateIdentityObjectCredentialType getHibernateIdentityObjectCredentialType(IdentityStoreInvocationContext ctx, IdentityObjectCredentialType credentialType) throws IdentityException {
        org.hibernate.Session session = this.getHibernateSession(ctx);
        HibernateIdentityObjectCredentialType hibernateType = null;
        try {
            hibernateType = (HibernateIdentityObjectCredentialType)session.createCriteria(HibernateIdentityObjectCredentialType.class).add((Criterion)Restrictions.eq((String)"name", (Object)credentialType.getName())).setCacheable(true).uniqueResult();
        }
        catch (HibernateException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("IdentityObjectCredentialType[ " + credentialType.getName() + "] not present in the store.");
        }
        return hibernateType;
    }

    public void populateObjectTypes(org.hibernate.Session hibernateSession, String[] typeNames) throws Exception {
        for (String typeName : typeNames) {
            HibernateIdentityObjectType hibernateType = (HibernateIdentityObjectType)hibernateSession.createCriteria(HibernateIdentityObjectType.class).add((Criterion)Restrictions.eq((String)"name", (Object)typeName)).uniqueResult();
            if (hibernateType != null) continue;
            hibernateType = new HibernateIdentityObjectType(typeName);
            hibernateSession.persist((Object)hibernateType);
        }
    }

    public void populateRelationshipTypes(org.hibernate.Session hibernateSession, String[] typeNames) throws Exception {
        for (String typeName : typeNames) {
            HibernateIdentityObjectRelationshipType hibernateType = (HibernateIdentityObjectRelationshipType)hibernateSession.createCriteria(HibernateIdentityObjectRelationshipType.class).add((Criterion)Restrictions.eq((String)"name", (Object)typeName)).uniqueResult();
            if (hibernateType != null) continue;
            hibernateType = new HibernateIdentityObjectRelationshipType(typeName);
            hibernateSession.persist((Object)hibernateType);
        }
    }

    public void populateCredentialTypes(org.hibernate.Session hibernateSession, String[] typeNames) throws Exception {
        for (String typeName : typeNames) {
            HibernateIdentityObjectCredentialType hibernateType = (HibernateIdentityObjectCredentialType)hibernateSession.createCriteria(HibernateIdentityObjectCredentialType.class).add((Criterion)Restrictions.eq((String)"name", (Object)typeName)).uniqueResult();
            if (hibernateType != null) continue;
            hibernateType = new HibernateIdentityObjectCredentialType(typeName);
            hibernateSession.persist((Object)hibernateType);
        }
    }

    public void addRealm(org.hibernate.Session hibernateSession, String realmName) throws IdentityException {
        try {
            HibernateRealm realm = new HibernateRealm(realmName);
            hibernateSession.persist((Object)realm);
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Failed to create store realm", (Throwable)e);
        }
    }

    private HibernateRealm getRealm(org.hibernate.Session hibernateSession, IdentityStoreInvocationContext ctx) throws IdentityException {
        if (this.getRealmName(ctx) == null) {
            throw new IllegalStateException("Realm Id not present");
        }
        HibernateRealm realm = null;
        if (!this.isRealmAware()) {
            realm = (HibernateRealm)hibernateSession.createCriteria(HibernateRealm.class).add((Criterion)Restrictions.eq((String)"name", (Object)DEFAULT_REALM_NAME)).setCacheable(true).uniqueResult();
            if (realm == null) {
                throw new IllegalStateException("Default store realm is not present: " + DEFAULT_REALM_NAME);
            }
        } else {
            realm = (HibernateRealm)hibernateSession.createCriteria(HibernateRealm.class).add((Criterion)Restrictions.eq((String)"name", (Object)this.getRealmName(ctx))).setCacheable(true).uniqueResult();
            if (realm == null) {
                HibernateRealm newRealm = new HibernateRealm(this.getRealmName(ctx));
                hibernateSession.persist((Object)newRealm);
                return newRealm;
            }
        }
        return realm;
    }

    private String getRealmName(IdentityStoreInvocationContext ctx) {
        if (this.isRealmAware()) {
            return ctx.getRealmId();
        }
        return DEFAULT_REALM_NAME;
    }

    private boolean isRealmAware() {
        return this.isRealmAware;
    }

    private boolean isAllowNotDefinedAttributes() {
        return this.isAllowNotDefinedAttributes;
    }

    private String resolveAttributeStoreMapping(IdentityObjectType type, String name) throws IdentityException {
        IdentityObjectAttributeMetaData amd;
        String mapping = null;
        if (this.attributesMetaData.containsKey(type.getName()) && (amd = this.attributesMetaData.get(type.getName()).get(name)) != null) {
            mapping = amd.getStoreMapping() != null ? amd.getStoreMapping() : amd.getName();
            return mapping;
        }
        if (this.isAllowNotDefinedAttributes()) {
            mapping = name;
            return mapping;
        }
        throw new IdentityException("Attribute name is not configured in this store");
    }

    private String resolveAttributeNameFromStoreMapping(IdentityObjectType type, String mapping) {
        Map<String, String> map;
        if (this.reverseAttributeMappings.containsKey(type.getName()) && (map = this.reverseAttributeMappings.get(type.getName())) != null) {
            String name = map.containsKey(mapping) ? map.get(mapping) : mapping;
            return name;
        }
        if (this.isAllowNotDefinedAttributes()) {
            return mapping;
        }
        return null;
    }

    private void filterByAttributesValues(Collection<IdentityObject> objects, Map<String, String[]> attrs) {
        HashSet<IdentityObject> toRemove = new HashSet<IdentityObject>();
        block2: for (IdentityObject object : objects) {
            Map<String, Collection> presentAttrs = ((HibernateIdentityObject)object).getAttributesAsMap();
            block3: for (Map.Entry<String, String[]> entry : attrs.entrySet()) {
                String mappedAttributeName = null;
                try {
                    mappedAttributeName = this.resolveAttributeStoreMapping(object.getIdentityType(), entry.getKey());
                }
                catch (IdentityException e) {
                    // empty catch block
                }
                if (mappedAttributeName == null) {
                    toRemove.add(object);
                    continue block2;
                }
                if (presentAttrs.containsKey(mappedAttributeName)) {
                    HashSet<Object> given = new HashSet<Object>(Arrays.asList((Object[])entry.getValue()));
                    Collection present = presentAttrs.get(mappedAttributeName);
                    for (String string : given) {
                        String regex = Tools.wildcardToRegex((String)string);
                        boolean matches = false;
                        for (Object o : present) {
                            if (!o.toString().matches(regex)) continue;
                            matches = true;
                        }
                        if (matches) continue;
                        toRemove.add(object);
                        continue block3;
                    }
                    continue;
                }
                toRemove.add(object);
                continue block2;
            }
        }
        for (IdentityObject identityObject : toRemove) {
            objects.remove(identityObject);
        }
    }

    private <T> List<T> cutPageFromResults(List<T> objects, IdentityObjectSearchCriteria criteria) {
        LinkedList<T> results = new LinkedList<T>();
        if (criteria.getMaxResults() == 0) {
            for (int i = criteria.getFirstResult(); i < objects.size(); ++i) {
                if (i >= objects.size()) continue;
                results.add(objects.get(i));
            }
        } else {
            for (int i = criteria.getFirstResult(); i < criteria.getFirstResult() + criteria.getMaxResults(); ++i) {
                if (i >= objects.size()) continue;
                results.add(objects.get(i));
            }
        }
        return results;
    }

    protected boolean isAllowNotDefinedIdentityObjectTypes() {
        return this.isAllowNotDefinedIdentityObjectTypes;
    }

    public boolean isManageTransactionDuringBootstrap() {
        return this.isManageTransactionDuringBootstrap;
    }

    public boolean isAllowNotCaseSensitiveSearch() {
        return this.isAllowNotCaseSensitiveSearch;
    }

    static {
        supportedIdentityObjectSearchCriteria.add(IdentityObjectSearchCriteriaType.ATTRIBUTE_FILTER);
        supportedIdentityObjectSearchCriteria.add(IdentityObjectSearchCriteriaType.NAME_FILTER);
        supportedIdentityObjectSearchCriteria.add(IdentityObjectSearchCriteriaType.PAGE);
        supportedIdentityObjectSearchCriteria.add(IdentityObjectSearchCriteriaType.SORT);
        supportedCredentialTypes.add(CREDENTIAL_TYPE_PASSWORD);
        supportedCredentialTypes.add(CREDENTIAL_TYPE_BINARY);
    }
}

