/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.store.hibernate;

import java.util.Map;
import java.util.Random;
import junit.framework.Assert;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.api.SimpleAttribute;
import org.picketlink.idm.impl.configuration.IdentityConfigurationImpl;
import org.picketlink.idm.impl.configuration.IdentityStoreConfigurationContextImpl;
import org.picketlink.idm.impl.configuration.jaxb2.JAXB2IdentityConfiguration;
import org.picketlink.idm.impl.store.CommonIdentityStoreTest;
import org.picketlink.idm.impl.store.IdentityStoreTestContext;
import org.picketlink.idm.impl.store.IdentityTypeEnum;
import org.picketlink.idm.impl.store.hibernate.HibernateIdentityStoreImpl;
import org.picketlink.idm.spi.configuration.IdentityConfigurationContextRegistry;
import org.picketlink.idm.spi.configuration.IdentityStoreConfigurationContext;
import org.picketlink.idm.spi.configuration.metadata.IdentityConfigurationMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityStoreConfigurationMetaData;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectAttribute;
import org.picketlink.idm.spi.model.IdentityObjectType;
import org.picketlink.idm.spi.store.IdentityStore;
import org.picketlink.idm.spi.store.IdentityStoreInvocationContext;
import org.picketlink.idm.spi.store.IdentityStoreSession;
import org.picketlink.idm.test.support.hibernate.HibernateTestPOJO;

public class HibernateIdentityStoreTestCase
extends HibernateTestPOJO
implements IdentityStoreTestContext {
    protected HibernateIdentityStoreImpl store;
    protected IdentityStoreInvocationContext ctx;
    protected CommonIdentityStoreTest commonTest;

    public void setUp() throws Exception {
        super.start();
        this.setIdentityConfig("store-test-config.xml");
        this.commonTest = new CommonIdentityStoreTest((IdentityStoreTestContext)this);
        IdentityConfigurationMetaData configurationMD = JAXB2IdentityConfiguration.createConfigurationMetaData((String)this.getIdentityConfig());
        IdentityConfigurationContextRegistry identityConfiguration = (IdentityConfigurationContextRegistry)new IdentityConfigurationImpl().configure(configurationMD);
        IdentityStoreConfigurationMetaData storeMD = null;
        for (IdentityStoreConfigurationMetaData metaData : configurationMD.getIdentityStores()) {
            if (!metaData.getId().equals("HibernateTestStore")) continue;
            storeMD = metaData;
            break;
        }
        IdentityStoreConfigurationContextImpl context = new IdentityStoreConfigurationContextImpl(configurationMD, identityConfiguration, storeMD);
        this.store = new HibernateIdentityStoreImpl("HibernateTestStore"){

            protected Session getHibernateSession(IdentityStoreInvocationContext ctx) {
                return HibernateIdentityStoreTestCase.this.getHibernateSupport().getSessionFactory().getCurrentSession();
            }

            protected SessionFactory bootstrapHibernateSessionFactory(IdentityStoreConfigurationContext configurationContext) throws IdentityException {
                return HibernateIdentityStoreTestCase.this.getHibernateSupport().getSessionFactory();
            }
        };
        this.store.bootstrap((IdentityStoreConfigurationContext)context);
        this.ctx = new IdentityStoreInvocationContext(){

            public IdentityStoreSession getIdentityStoreSession() {
                return null;
            }

            public String getRealmId() {
                return "testRealm";
            }

            public String getSessionId() {
                return "";
            }
        };
    }

    protected void tearDown() throws Exception {
        super.stop();
    }

    public void begin() {
        this.getHibernateSupport().openSession();
    }

    public void commit() {
        Assert.assertTrue((boolean)this.getHibernateSupport().commitTransaction());
    }

    public void flush() throws Exception {
        this.getHibernateSupport().getSessionFactory().getCurrentSession().flush();
    }

    public IdentityStore getStore() {
        return this.store;
    }

    public IdentityStoreInvocationContext getCtx() {
        return this.ctx;
    }

    public void testStorePersistence() throws Exception {
        this.commonTest.testStorePersistence();
    }

    public void testFindMethods() throws Exception {
        this.commonTest.testFindMethods();
    }

    public void testBinaryAttributes() throws Exception {
        this.begin();
        IdentityObject user1 = this.store.createIdentityObject(this.ctx, "Adam", (IdentityObjectType)IdentityTypeEnum.USER);
        IdentityObject user2 = this.store.createIdentityObject(this.ctx, "Eva", (IdentityObjectType)IdentityTypeEnum.USER);
        this.flush();
        IdentityObjectAttribute[] attrs = new IdentityObjectAttribute[]{new SimpleAttribute("key1", (Object[])new String[]{"val1", "val2", "val3"}), new SimpleAttribute("key2", (Object[])new String[]{"val1", "val2", "val3", "val4"})};
        this.store.addAttributes(this.ctx, user1, attrs);
        Random random = new Random();
        byte[] picture1 = new byte[921600];
        random.nextBytes(picture1);
        byte[] picture2 = new byte[921600];
        random.nextBytes(picture2);
        attrs = new IdentityObjectAttribute[]{new SimpleAttribute("key1", (Object[])new byte[][]{picture1})};
        this.store.addAttributes(this.ctx, user1, attrs);
        attrs = new IdentityObjectAttribute[]{new SimpleAttribute("key2", (Object[])new byte[][]{picture1, picture2})};
        this.store.addAttributes(this.ctx, user1, attrs);
        attrs = new IdentityObjectAttribute[]{new SimpleAttribute("key1", (Object[])new byte[][]{picture2})};
        this.store.updateAttributes(this.ctx, user1, attrs);
        this.store.removeAttributes(this.ctx, user1, new String[]{"key1", "key2"});
        Assert.assertNull((Object)this.store.findIdentityObjectByUniqueAttribute(this.ctx, (IdentityObjectType)IdentityTypeEnum.USER, (IdentityObjectAttribute)new SimpleAttribute("key1", (Object[])new String[]{"toto"})));
        this.commit();
    }

    public void testAttributes() throws Exception {
        this.begin();
        IdentityObject user1 = this.store.createIdentityObject(this.ctx, "Adam", (IdentityObjectType)IdentityTypeEnum.USER);
        IdentityObject user2 = this.store.createIdentityObject(this.ctx, "Eva", (IdentityObjectType)IdentityTypeEnum.USER);
        this.flush();
        IdentityObjectAttribute[] attrs = new IdentityObjectAttribute[]{new SimpleAttribute("key1", (Object[])new String[]{"val1", "val2", "val3"}), new SimpleAttribute("key2", (Object[])new String[]{"val1", "val2", "val3", "val4"})};
        this.store.addAttributes(this.ctx, user1, attrs);
        this.flush();
        Map persistedAttrs = this.store.getAttributes(this.ctx, user1);
        Assert.assertEquals((int)2, (int)persistedAttrs.keySet().size());
        Assert.assertTrue((boolean)persistedAttrs.containsKey("key1"));
        Assert.assertEquals((int)3, (int)((IdentityObjectAttribute)persistedAttrs.get("key1")).getSize());
        Assert.assertTrue((boolean)persistedAttrs.containsKey("key2"));
        Assert.assertEquals((int)4, (int)((IdentityObjectAttribute)persistedAttrs.get("key2")).getSize());
        this.flush();
        attrs = new IdentityObjectAttribute[]{new SimpleAttribute("key3", (Object[])new String[]{"val1"})};
        this.store.addAttributes(this.ctx, user1, attrs);
        this.flush();
        persistedAttrs = this.store.getAttributes(this.ctx, user1);
        Assert.assertEquals((int)3, (int)persistedAttrs.keySet().size());
        Assert.assertTrue((boolean)persistedAttrs.containsKey("key1"));
        Assert.assertEquals((int)3, (int)((IdentityObjectAttribute)persistedAttrs.get("key1")).getSize());
        Assert.assertTrue((boolean)persistedAttrs.containsKey("key2"));
        Assert.assertEquals((int)4, (int)((IdentityObjectAttribute)persistedAttrs.get("key2")).getSize());
        Assert.assertTrue((boolean)persistedAttrs.containsKey("key3"));
        Assert.assertEquals((int)1, (int)((IdentityObjectAttribute)persistedAttrs.get("key3")).getSize());
        this.flush();
        attrs = new IdentityObjectAttribute[]{new SimpleAttribute("key3", (Object[])new String[]{"val2"})};
        this.store.addAttributes(this.ctx, user1, attrs);
        this.flush();
        persistedAttrs = this.store.getAttributes(this.ctx, user1);
        Assert.assertEquals((int)3, (int)persistedAttrs.keySet().size());
        Assert.assertTrue((boolean)persistedAttrs.containsKey("key3"));
        Assert.assertEquals((int)2, (int)((IdentityObjectAttribute)persistedAttrs.get("key3")).getSize());
        this.flush();
        this.store.updateAttributes(this.ctx, user1, attrs);
        this.flush();
        persistedAttrs = this.store.getAttributes(this.ctx, user1);
        Assert.assertEquals((int)3, (int)persistedAttrs.keySet().size());
        Assert.assertTrue((boolean)persistedAttrs.containsKey("key3"));
        Assert.assertEquals((int)1, (int)((IdentityObjectAttribute)persistedAttrs.get("key3")).getSize());
        this.flush();
        attrs = new IdentityObjectAttribute[]{new SimpleAttribute("key4", (Object[])new String[]{"val2"})};
        this.store.updateAttributes(this.ctx, user1, attrs);
        this.flush();
        persistedAttrs = this.store.getAttributes(this.ctx, user1);
        Assert.assertEquals((int)4, (int)persistedAttrs.keySet().size());
        Assert.assertEquals((String)"val2", (String)((IdentityObjectAttribute)persistedAttrs.get("key4")).getValue().toString());
        this.store.removeAttributes(this.ctx, user1, new String[]{"key3"});
        this.flush();
        persistedAttrs = this.store.getAttributes(this.ctx, user1);
        Assert.assertEquals((int)3, (int)persistedAttrs.keySet().size());
        this.commit();
    }

    public void testMD() throws Exception {
        Assert.assertEquals((int)2, (int)this.store.getSupportedFeatures().getSupportedRelationshipTypes().size());
    }

    public void testRelationships() throws Exception {
        this.commonTest.testRelationships();
    }

    public void testPasswordCredentials() throws Exception {
        this.commonTest.testPasswordCredential();
    }

    public void testBinaryCredentials() throws Exception {
        this.commonTest.testBinaryCredential();
    }

    public void testCriteria() throws Exception {
        this.commonTest.testCriteria();
    }
}

