/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.store.hibernate;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Random;
import junit.framework.Assert;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Projections;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObject;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectAttribute;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectAttributeBinaryValue;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectType;
import org.picketlink.idm.impl.model.hibernate.HibernateRealm;
import org.picketlink.idm.test.support.hibernate.HibernateTestPOJO;

public class EvilBinaryTestCase
extends HibernateTestPOJO {
    public void setUp() throws Exception {
        super.start();
    }

    public void tearDown() throws Exception {
        super.stop();
    }

    public void testBinary() throws Exception {
        this.begin();
        Session session = this.getSessionFactory().getCurrentSession();
        HibernateRealm realm = new HibernateRealm("default");
        session.persist((Object)realm);
        HibernateIdentityObjectType userType = new HibernateIdentityObjectType("User");
        session.persist((Object)userType);
        HibernateIdentityObject user1 = new HibernateIdentityObject("user1", userType, realm);
        session.persist((Object)user1);
        HashSet<String> values1 = new HashSet<String>();
        values1.add("Val1");
        values1.add("Val2");
        values1.add("Val3");
        HibernateIdentityObjectAttribute attr = new HibernateIdentityObjectAttribute(user1, "simple1", "text");
        attr.setTextValues(values1);
        user1.getAttributes().add(attr);
        this.commit();
        this.begin();
        session = this.getSessionFactory().getCurrentSession();
        user1 = (HibernateIdentityObject)session.get(HibernateIdentityObject.class, (Serializable)new Long(user1.getId()));
        Random random = new Random();
        byte[] picture = new byte[512000];
        random.nextBytes(picture);
        attr = new HibernateIdentityObjectAttribute(user1, "simple2", "binary");
        attr.setBinaryValue(new HibernateIdentityObjectAttributeBinaryValue(picture));
        user1.addAttribute(attr);
        values1 = new HashSet();
        values1.add("Val1");
        attr = new HibernateIdentityObjectAttribute(user1, "simple3", "text");
        attr.setTextValues(values1);
        user1.getAttributes().add(attr);
        values1 = new HashSet();
        values1.add("Val8");
        values1.add("Val15");
        attr = new HibernateIdentityObjectAttribute(user1, "simple4", "text");
        attr.setTextValues(values1);
        user1.getAttributes().add(attr);
        this.commit();
        this.begin();
        session = this.getSessionFactory().getCurrentSession();
        user1 = (HibernateIdentityObject)session.get(HibernateIdentityObject.class, (Serializable)new Long(user1.getId()));
        picture = new byte[921600];
        random.nextBytes(picture);
        attr = new HibernateIdentityObjectAttribute(user1, "simple5", "binary");
        attr.setBinaryValue(new HibernateIdentityObjectAttributeBinaryValue(picture));
        user1.getAttributes().add(attr);
        this.commit();
        this.begin();
        session = this.getSessionFactory().getCurrentSession();
        user1 = (HibernateIdentityObject)session.get(HibernateIdentityObject.class, (Serializable)new Long(user1.getId()));
        Assert.assertEquals((int)5, (int)user1.getAttributes().size());
        int binaryCount = (Integer)session.createCriteria(HibernateIdentityObjectAttributeBinaryValue.class).setProjection(Projections.rowCount()).uniqueResult();
        Assert.assertEquals((int)2, (int)binaryCount);
        int attrCount = (Integer)session.createCriteria(HibernateIdentityObjectAttribute.class).setProjection(Projections.rowCount()).uniqueResult();
        Assert.assertEquals((int)5, (int)attrCount);
        session.delete((Object)user1);
        attrCount = (Integer)session.createCriteria(HibernateIdentityObjectAttribute.class).setProjection(Projections.rowCount()).uniqueResult();
        Assert.assertEquals((int)0, (int)attrCount);
        binaryCount = (Integer)session.createCriteria(HibernateIdentityObjectAttributeBinaryValue.class).setProjection(Projections.rowCount()).uniqueResult();
        Assert.assertEquals((int)0, (int)binaryCount);
        this.commit();
    }
}

