/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.store.hibernate;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import junit.framework.Assert;
import org.hibernate.Query;
import org.hibernate.Session;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObject;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectAttribute;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectRelationship;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectRelationshipType;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectType;
import org.picketlink.idm.impl.model.hibernate.HibernateRealm;
import org.picketlink.idm.test.support.hibernate.HibernateTestPOJO;

public class HibernateModelTestCase
extends HibernateTestPOJO {
    public void setUp() throws Exception {
        super.start();
    }

    public void tearDown() throws Exception {
        super.stop();
    }

    public void testPersistence() {
        this.begin();
        Session session = this.getSessionFactory().getCurrentSession();
        HibernateRealm defaultRealm = new HibernateRealm("default");
        session.persist((Object)defaultRealm);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("test", "testValue");
        defaultRealm.setProperties(props);
        defaultRealm = (HibernateRealm)session.get(HibernateRealm.class, (Serializable)defaultRealm.getId());
        Assert.assertEquals((int)defaultRealm.getProperties().keySet().size(), (int)1);
        HibernateIdentityObjectType iot = new HibernateIdentityObjectType();
        iot.setName("User");
        session.persist((Object)iot);
        Assert.assertTrue((boolean)session.contains((Object)iot));
        HibernateIdentityObject io = new HibernateIdentityObject();
        io.setName("John Kowalski");
        io.setRealm(defaultRealm);
        io.setIdentityType(iot);
        session.persist((Object)io);
        Assert.assertTrue((boolean)session.contains((Object)io));
        session.delete((Object)io);
        Assert.assertFalse((boolean)session.contains((Object)io));
        HibernateIdentityObjectRelationshipType iort = new HibernateIdentityObjectRelationshipType();
        iort.setName("Member");
        session.persist((Object)iort);
        Assert.assertTrue((boolean)session.contains((Object)iort));
        Assert.assertTrue((boolean)session.contains((Object)iort));
        session.delete((Object)iort);
        Assert.assertFalse((boolean)session.contains((Object)iort));
        this.commit();
    }

    public void testRelationships() {
        this.begin();
        Session session = this.getSessionFactory().getCurrentSession();
        HibernateRealm realm = new HibernateRealm("default");
        session.persist((Object)realm);
        HibernateIdentityObjectType groupType = new HibernateIdentityObjectType("Group");
        session.persist((Object)groupType);
        HibernateIdentityObjectType userType = new HibernateIdentityObjectType("User");
        session.persist((Object)userType);
        HibernateIdentityObject user1 = new HibernateIdentityObject("user1", userType, realm);
        session.persist((Object)user1);
        HibernateIdentityObject user2 = new HibernateIdentityObject("user2", userType, realm);
        session.persist((Object)user2);
        HibernateIdentityObject user3 = new HibernateIdentityObject("user3", userType, realm);
        session.persist((Object)user3);
        HibernateIdentityObject group1 = new HibernateIdentityObject("group1", groupType, realm);
        session.persist((Object)group1);
        HibernateIdentityObject group2 = new HibernateIdentityObject("group2", groupType, realm);
        session.persist((Object)group2);
        HibernateIdentityObject group3 = new HibernateIdentityObject("group3", groupType, realm);
        session.persist((Object)group3);
        HibernateIdentityObjectRelationshipType memberType = new HibernateIdentityObjectRelationshipType("member");
        session.persist((Object)memberType);
        HibernateIdentityObjectRelationship relationship = new HibernateIdentityObjectRelationship(memberType, group1, user1);
        session.persist((Object)relationship);
        relationship = new HibernateIdentityObjectRelationship(memberType, group1, user2);
        session.persist((Object)relationship);
        relationship = new HibernateIdentityObjectRelationship(memberType, group2, user3);
        session.persist((Object)relationship);
        relationship = new HibernateIdentityObjectRelationship(memberType, group2, group1);
        session.persist((Object)relationship);
        this.commit();
        this.begin();
        session = this.getSessionFactory().getCurrentSession();
        Query ioQuery = session.createQuery("select o from HibernateIdentityObject o where o.name like :name");
        group1 = (HibernateIdentityObject)ioQuery.setParameter("name", (Object)"group1").uniqueResult();
        Assert.assertEquals((int)2, (int)group1.getFromRelationships().size());
        Assert.assertEquals((int)1, (int)group1.getToRelationships().size());
        group2 = (HibernateIdentityObject)ioQuery.setParameter("name", (Object)"group2").uniqueResult();
        Assert.assertEquals((int)2, (int)group2.getFromRelationships().size());
        Assert.assertEquals((int)0, (int)group2.getToRelationships().size());
        user3 = (HibernateIdentityObject)ioQuery.setParameter("name", (Object)"user3").uniqueResult();
        Assert.assertEquals((int)1, (int)user3.getToRelationships().size());
        Assert.assertEquals((int)0, (int)user3.getFromRelationships().size());
        Assert.assertEquals((String)"group2", (String)((HibernateIdentityObjectRelationship)user3.getToRelationships().iterator().next()).getFromIdentityObject().getName());
        this.commit();
    }

    public void testNameTypeConstraint() throws Exception {
        this.begin();
        Session session = this.getSessionFactory().getCurrentSession();
        HibernateRealm realm = new HibernateRealm("default");
        session.persist((Object)realm);
        HibernateIdentityObjectType groupType = new HibernateIdentityObjectType("Group");
        session.persist((Object)groupType);
        HibernateIdentityObjectType userType = new HibernateIdentityObjectType("User");
        session.persist((Object)userType);
        HibernateIdentityObject user1 = new HibernateIdentityObject("user1", userType, realm);
        session.persist((Object)user1);
        HibernateIdentityObject user2 = new HibernateIdentityObject("user2", userType, realm);
        session.persist((Object)user2);
        this.commit();
        this.begin();
        session = this.getSessionFactory().getCurrentSession();
        try {
            HibernateIdentityObject user3 = new HibernateIdentityObject("user2", userType, realm);
            session.persist((Object)user3);
            Assert.assertFalse((boolean)this.getHibernateSupport().commitTransaction());
        }
        catch (Exception e) {
            this.getHibernateSupport().rollbackTransaction();
        }
        this.begin();
        session = this.getSessionFactory().getCurrentSession();
        HibernateIdentityObject user4 = new HibernateIdentityObject("group1", userType, realm);
        session.persist((Object)user4);
        HibernateIdentityObject group1 = new HibernateIdentityObject("group1", groupType, realm);
        session.persist((Object)group1);
        HibernateIdentityObject group2 = new HibernateIdentityObject("group2", groupType, realm);
        session.persist((Object)group2);
        try {
            HibernateIdentityObject group3 = new HibernateIdentityObject("group2", groupType, realm);
            session.persist((Object)group3);
            Assert.assertFalse((boolean)this.getHibernateSupport().commitTransaction());
        }
        catch (Exception e) {
            this.getHibernateSupport().rollbackTransaction();
        }
        this.begin();
        session = this.getSessionFactory().getCurrentSession();
        HibernateIdentityObject group4 = new HibernateIdentityObject("user1", groupType, realm);
        session.persist((Object)group4);
        session.flush();
        this.commit();
    }

    public void testAttributes() throws Exception {
        this.begin();
        Session session = this.getSessionFactory().getCurrentSession();
        HibernateRealm realm = new HibernateRealm("default");
        session.persist((Object)realm);
        HibernateIdentityObjectType userType = new HibernateIdentityObjectType("User");
        session.persist((Object)userType);
        HibernateIdentityObject user1 = new HibernateIdentityObject("user1", userType, realm);
        session.persist((Object)user1);
        HashSet<String> values1 = new HashSet<String>();
        values1.add("Val1");
        values1.add("Val2");
        values1.add("Val3");
        HibernateIdentityObjectAttribute attr = new HibernateIdentityObjectAttribute(user1, "simple1", "text");
        attr.setTextValues(values1);
        user1.getAttributes().add(attr);
        attr = new HibernateIdentityObjectAttribute(user1, "simple2", "text");
        attr.setTextValues(values1);
        user1.getAttributes().add(attr);
        this.commit();
        this.begin();
        session = this.getSessionFactory().getCurrentSession();
        user1 = (HibernateIdentityObject)session.get(HibernateIdentityObject.class, (Serializable)new Long(user1.getId()));
        Assert.assertEquals((int)2, (int)user1.getAttributes().size());
        this.commit();
    }
}

