/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.test.support.hibernate;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.transaction.Synchronization;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.cfg.Configuration;
import org.jboss.logging.Logger;
import org.picketlink.idm.test.support.IOTools;
import org.picketlink.idm.test.support.XMLTools;
import org.picketlink.idm.test.support.hibernate.DataSourceConfig;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HibernateSupport {
    protected Logger log = Logger.getLogger(HibernateSupport.class);
    protected String jndiName;
    protected Collection mappings;
    protected Config config;
    protected SessionFactory factory;
    protected Session session;
    protected Configuration cfg;
    protected DataSourceConfig dsc;
    private static Map configs;

    public Collection getMappings() {
        return this.mappings;
    }

    public void setMappings(Collection mappings) {
        this.mappings = mappings;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public DataSourceConfig getDataSourceConfig() {
        return this.dsc;
    }

    public void setDataSourceConfig(DataSourceConfig dsc) {
        this.dsc = dsc;
    }

    public SessionFactory getSessionFactory() {
        return this.factory;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJNDIName(String jndiName) {
        this.jndiName = jndiName;
        this.log = jndiName == null ? Logger.getLogger(HibernateSupport.class) : Logger.getLogger((String)jndiName);
    }

    protected void createConfiguration() {
        Configuration cfg = new Configuration();
        for (String mapping : this.mappings) {
            this.log.debug((Object)("Adding mapping " + mapping));
            cfg.addResource(mapping, Thread.currentThread().getContextClassLoader());
        }
        Properties props = new Properties();
        for (Map.Entry entry : this.config.properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            this.log.debug((Object)("Adding property " + key + " = " + value));
            cfg.setProperty(key, value);
        }
        cfg.addProperties(props);
        if (this.jndiName != null) {
            this.log.debug((Object)("Setting jndi name to " + this.jndiName));
            cfg.setProperty("hibernate.session_factory_name", this.jndiName);
        }
        if (this.dsc != null) {
            cfg.setProperty("hibernate.connection.url", this.dsc.getConnectionURL());
            cfg.setProperty("hibernate.connection.driver_class", this.dsc.getDriverClass());
            cfg.setProperty("hibernate.connection.username", this.dsc.getUserName());
            cfg.setProperty("hibernate.connection.password", this.dsc.getPassword());
        }
        this.cfg = cfg;
    }

    protected void createSessionFactory() {
        this.factory = this.cfg.buildSessionFactory();
    }

    protected void destroySessionFactory() {
        this.factory.close();
    }

    protected void destroyConfiguration() {
        this.config = null;
    }

    public void create() throws Exception {
    }

    public void start() throws Exception {
        this.createConfiguration();
        this.createSessionFactory();
    }

    public void stop() throws Exception {
        try {
            Session currentSession = this.getCurrentSession();
            if (currentSession != null && this.commitTransaction()) {
                System.out.println("Warning : commited a transaction for the test case");
            }
        }
        catch (HibernateException e) {
            e.printStackTrace();
        }
        this.destroySessionFactory();
        this.destroyConfiguration();
    }

    public void destroy() {
    }

    public boolean commitTransaction() {
        Session currentSession = this.getCurrentSession();
        if (currentSession == null) {
            throw new IllegalStateException("No current session");
        }
        if (currentSession.getTransaction() == null) {
            throw new IllegalStateException("No current transaction");
        }
        try {
            Transaction tx = currentSession.getTransaction();
            if (tx.isActive()) {
                tx.commit();
                return true;
            }
            return false;
        }
        catch (TransactionException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void rollbackTransaction() {
        Session currentSession = this.getCurrentSession();
        if (currentSession == null) {
            throw new IllegalStateException("No current session");
        }
        if (currentSession.getTransaction() == null) {
            throw new IllegalStateException("No current transaction");
        }
        try {
            Transaction tx = currentSession.getTransaction();
            tx.rollback();
        }
        catch (TransactionException transactionException) {
            // empty catch block
        }
    }

    public Session getCurrentSession() {
        try {
            if (this.session != null) {
                return this.session;
            }
            this.session = this.factory.getCurrentSession();
            Transaction tx = this.session.getTransaction();
            tx.registerSynchronization(new Synchronization(){

                public void beforeCompletion() {
                }

                public void afterCompletion(int i) {
                    HibernateSupport.this.session = null;
                }
            });
            return this.session;
        }
        catch (HibernateException e) {
            return null;
        }
    }

    public Session openSession() {
        if (this.getCurrentSession() != null) {
            throw new IllegalStateException("Cannot have more than one active session");
        }
        this.session = this.factory.openSession();
        Transaction tx = this.session.beginTransaction();
        tx.registerSynchronization(new Synchronization(){

            public void beforeCompletion() {
            }

            public void afterCompletion(int i) {
                HibernateSupport.this.session = null;
            }
        });
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map fromXML(URL url) throws Exception {
        LinkedHashMap<String, Config> configs = new LinkedHashMap<String, Config>();
        BufferedInputStream in = null;
        try {
            in = IOTools.safeBufferedWrapper((InputStream)url.openStream());
            Document doc = XMLTools.getDocumentBuilderFactory().newDocumentBuilder().parse(in);
            Iterator i = XMLTools.getChildrenIterator((Element)doc.getDocumentElement(), (String)"configuration");
            while (i.hasNext()) {
                Element childElt = (Element)i.next();
                Element configurationNameElt = XMLTools.getUniqueChild((Element)childElt, (String)"configuration-name", (boolean)true);
                String configurationName = XMLTools.asString((Element)configurationNameElt);
                HashMap<String, String> properties = new HashMap<String, String>();
                Element propertiesElt = XMLTools.getUniqueChild((Element)childElt, (String)"properties", (boolean)false);
                if (propertiesElt != null) {
                    Iterator j = XMLTools.getChildrenIterator((Element)propertiesElt, (String)"property");
                    while (j.hasNext()) {
                        Element propertyElt = (Element)j.next();
                        Element nameElt = XMLTools.getUniqueChild((Element)propertyElt, (String)"name", (boolean)true);
                        Element valueElt = XMLTools.getUniqueChild((Element)propertyElt, (String)"value", (boolean)true);
                        String name = XMLTools.asString((Element)nameElt);
                        String value = XMLTools.asString((Element)valueElt);
                        properties.put(name, value);
                    }
                }
                Config config = new Config(configurationName, properties);
                configs.put(configurationName, config);
            }
            LinkedHashMap<String, Config> linkedHashMap = configs;
            return linkedHashMap;
        }
        finally {
            IOTools.safeClose((InputStream)in);
        }
    }

    public static synchronized Config getConfig(String name, String hibernates) throws Exception {
        Config ourConfig;
        Config defaultCfg;
        if (configs == null) {
            URL url = Thread.currentThread().getContextClassLoader().getResource(hibernates);
            configs = HibernateSupport.fromXML(url);
            defaultCfg = (Config)configs.get("default");
            for (Config cfg : configs.values()) {
                if ("default".equals(cfg.getName())) continue;
                HashMap tmp = new HashMap(defaultCfg.properties);
                tmp.putAll(cfg.properties);
                cfg.properties = tmp;
            }
        }
        if ((ourConfig = (Config)configs.get(name)) == null) {
            defaultCfg = (Config)configs.get("default");
            ourConfig = new Config(name, defaultCfg.properties);
            configs.put(name, ourConfig);
        }
        return (Config)configs.get(name);
    }

    public static synchronized Config getConfig(String name) throws Exception {
        return HibernateSupport.getConfig(name, "hibernates.xml");
    }

    public static class Config {
        private String name;
        private Map properties;

        public Config(String name, Map properties) {
            this.name = name;
            this.properties = properties;
        }

        public String getName() {
            return this.name;
        }

        public Map getProperties() {
            return this.properties;
        }
    }
}

