/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.test.support.hibernate;

import java.util.LinkedList;
import junit.framework.Assert;
import org.hibernate.SessionFactory;
import org.picketlink.idm.test.support.IdentityTestPOJO;
import org.picketlink.idm.test.support.JNDISupport;
import org.picketlink.idm.test.support.hibernate.DataSourceConfig;
import org.picketlink.idm.test.support.hibernate.HibernateSupport;

public class HibernateTestPOJO
extends IdentityTestPOJO {
    protected String dataSourceName = "hsqldb";
    protected String hibernateConfig = "datasources/hibernates.xml";
    protected String datasources = "datasources/datasources.xml";
    protected HibernateSupport hibernateSupport;

    public void start() throws Exception {
        this.overrideFromProperties();
        JNDISupport jndiSupport = new JNDISupport();
        jndiSupport.start();
        this.identityConfig = "hibernate-test-identity-config.xml";
        DataSourceConfig dataSourceConfig = DataSourceConfig.obtainConfig(this.datasources, this.dataSourceName);
        HibernateSupport.Config hibernateSupportConfig = HibernateSupport.getConfig(this.dataSourceName, this.hibernateConfig);
        this.hibernateSupport = new HibernateSupport();
        this.hibernateSupport.setConfig(hibernateSupportConfig);
        this.hibernateSupport.setDataSourceConfig(dataSourceConfig);
        this.hibernateSupport.setJNDIName("java:/jbossidentity/HibernateStoreSessionFactory");
        String prefix = "mappings/";
        if (this.dataSourceName.startsWith("sybase-")) {
            prefix = "sybase-mappings/";
        }
        LinkedList<String> mappings = new LinkedList<String>();
        mappings.add(prefix + "HibernateIdentityObject.hbm.xml");
        mappings.add(prefix + "HibernateIdentityObjectCredentialBinaryValue.hbm.xml");
        mappings.add(prefix + "HibernateIdentityObjectAttributeBinaryValue.hbm.xml");
        mappings.add(prefix + "HibernateIdentityObjectAttribute.hbm.xml");
        mappings.add(prefix + "HibernateIdentityObjectCredential.hbm.xml");
        mappings.add(prefix + "HibernateIdentityObjectCredentialType.hbm.xml");
        mappings.add(prefix + "HibernateIdentityObjectRelationship.hbm.xml");
        mappings.add(prefix + "HibernateIdentityObjectRelationshipName.hbm.xml");
        mappings.add(prefix + "HibernateIdentityObjectRelationshipType.hbm.xml");
        mappings.add(prefix + "HibernateIdentityObjectType.hbm.xml");
        mappings.add(prefix + "HibernateRealm.hbm.xml");
        this.hibernateSupport.setMappings(mappings);
        this.hibernateSupport.start();
    }

    public void stop() throws Exception {
        this.hibernateSupport.getSessionFactory().getStatistics().logSummary();
        this.hibernateSupport.stop();
    }

    public void overrideFromProperties() throws Exception {
        String dsName = System.getProperties().getProperty("dataSourceName");
        if (dsName != null && dsName.length() > 0 && !dsName.startsWith("$")) {
            this.setDataSourceName(dsName);
        }
    }

    public SessionFactory getSessionFactory() {
        return this.getHibernateSupport().getSessionFactory();
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public void setHibernateConfig(String hibernateConfig) {
        this.hibernateConfig = hibernateConfig;
    }

    public void setDatasources(String datasources) {
        this.datasources = datasources;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getHibernateConfig() {
        return this.hibernateConfig;
    }

    public String getDatasources() {
        return this.datasources;
    }

    public HibernateSupport getHibernateSupport() {
        return this.hibernateSupport;
    }

    public void begin() {
        this.getHibernateSupport().getCurrentSession().getTransaction().begin();
    }

    public void commit() {
        Assert.assertTrue((boolean)this.getHibernateSupport().commitTransaction());
    }
}

