/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.test.support.hibernate;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.logging.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectRelationshipType;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectType;

public class HibernateTestSupport {
    private static Logger logger = Logger.getLogger(HibernateTestSupport.class.getName());
    protected SessionFactory sessionFactory;
    private Connection connection;
    private final String databaseName;
    private final String hibernateConfiguration;

    public HibernateTestSupport(String databaseName, String hibernateConfiguration) {
        this.databaseName = databaseName;
        this.hibernateConfiguration = hibernateConfiguration;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void start() throws Exception {
        try {
            logger.info("Starting in-memory HSQL database for unit tests");
            Class.forName("org.hsqldb.jdbcDriver");
            this.connection = DriverManager.getConnection("jdbc:hsqldb:mem:" + this.databaseName, "sa", "");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.fine("Exception during HSQL database startup.");
            throw ex;
        }
        try {
            logger.info("Building Hibernate SessionFactory for unit tests");
            this.sessionFactory = new Configuration().configure(this.hibernateConfiguration).buildSessionFactory();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.fine("Exception during Hibernate SessionFactory instanciation.");
            throw ex;
        }
    }

    public void stop() throws Exception {
        logger.info("Shuting down Hibernate layer.");
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
        }
        logger.info("Stopping in-memory HSQL database.");
        this.connection.createStatement().execute("SHUTDOWN");
    }

    public void populateObjectTypes(String[] typeNames) throws Exception {
        this.sessionFactory.getCurrentSession().getTransaction().begin();
        for (String typeName : typeNames) {
            HibernateIdentityObjectType hibernateType = new HibernateIdentityObjectType(typeName);
            this.sessionFactory.getCurrentSession().persist((Object)hibernateType);
        }
        this.sessionFactory.getCurrentSession().getTransaction().commit();
    }

    public void populateRelationshipTypes(String[] typeNames) throws Exception {
        this.sessionFactory.getCurrentSession().getTransaction().begin();
        for (String typeName : typeNames) {
            HibernateIdentityObjectRelationshipType hibernateType = new HibernateIdentityObjectRelationshipType(typeName);
            this.sessionFactory.getCurrentSession().persist((Object)hibernateType);
        }
        this.sessionFactory.getCurrentSession().getTransaction().commit();
    }
}

