/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.api.query;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentitySearchCriteria;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.User;
import org.picketlink.idm.api.query.QueryException;
import org.picketlink.idm.impl.NotYetImplementedException;
import org.picketlink.idm.impl.api.IdentitySearchCriteriaImpl;
import org.picketlink.idm.impl.api.query.AbstractQueryExecutor;
import org.picketlink.idm.impl.api.query.UserQueryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserQueryExecutorImpl
extends AbstractQueryExecutor
implements Serializable {
    private static final long serialVersionUID = -4196998772910705233L;

    public UserQueryExecutorImpl(IdentitySession identitySession) {
        super(identitySession);
    }

    public Collection<User> execute(UserQueryImpl q) throws QueryException {
        List<Object> resultsMain = new LinkedList<User>();
        try {
            User uniqueUser = null;
            LinkedList<User> resultsAssociatedGroups = new LinkedList<User>();
            LinkedList<User> resultsConnectedWithRoleGroups = new LinkedList<User>();
            LinkedList<User> resultsRelatedGroups = new LinkedList<User>();
            if (q.userId == null && q.groupsAssociatedWith.size() == 0 && q.groupsConnectedWithRole.size() == 0 && q.groupsRelated.size() == 0) {
                return this.identitySession.getPersistenceManager().findUser((IdentitySearchCriteria)q.searchCriteria);
            }
            if (q.userId != null) {
                uniqueUser = this.identitySession.getPersistenceManager().findUser(q.userId);
            }
            if (q.groupsAssociatedWith.size() > 0) {
                for (Group group : q.groupsAssociatedWith) {
                    this.addAllPreservingDuplicates(resultsAssociatedGroups, this.identitySession.getRelationshipManager().findAssociatedUsers(group, false, (IdentitySearchCriteria)q.searchCriteria));
                }
            }
            if (q.groupsConnectedWithRole.size() > 0) {
                for (Group group : q.groupsConnectedWithRole) {
                    this.addAllPreservingDuplicates(resultsConnectedWithRoleGroups, this.identitySession.getRoleManager().findUsersWithRelatedRole(group, (IdentitySearchCriteria)q.searchCriteria));
                }
            }
            if (q.groupsRelated.size() > 0) {
                for (Group group : q.groupsRelated) {
                    this.addAllPreservingDuplicates(resultsRelatedGroups, this.identitySession.getRelationshipManager().findRelatedUsers(group, (IdentitySearchCriteria)q.searchCriteria));
                }
            }
            if (q.userId != null && uniqueUser != null && q.groupsAssociatedWith.size() == 0 && resultsAssociatedGroups.size() == 0 && q.groupsConnectedWithRole.size() == 0 && resultsConnectedWithRoleGroups.size() == 0 && q.groupsRelated.size() == 0 && resultsRelatedGroups.size() == 0) {
                resultsMain.add(uniqueUser);
                resultsMain = IdentitySearchCriteriaImpl.applyCriteria(this.identitySession, q.searchCriteria, resultsMain);
                return resultsMain;
            }
            if (q.userId == null && uniqueUser == null && q.groupsAssociatedWith.size() > 0 && resultsAssociatedGroups.size() > 0 && q.groupsConnectedWithRole.size() == 0 && resultsConnectedWithRoleGroups.size() == 0 && q.groupsRelated.size() == 0 && resultsRelatedGroups.size() == 0) {
                return resultsAssociatedGroups;
            }
            if (q.userId == null && uniqueUser == null && q.groupsAssociatedWith.size() == 0 && resultsAssociatedGroups.size() == 0 && q.groupsConnectedWithRole.size() > 0 && resultsConnectedWithRoleGroups.size() > 0 && q.groupsRelated.size() == 0 && resultsRelatedGroups.size() == 0) {
                return resultsConnectedWithRoleGroups;
            }
            if (q.userId == null && uniqueUser == null && q.groupsAssociatedWith.size() == 0 && resultsAssociatedGroups.size() == 0 && q.groupsConnectedWithRole.size() == 0 && resultsConnectedWithRoleGroups.size() == 0 && q.groupsRelated.size() > 0 && resultsRelatedGroups.size() > 0) {
                return resultsRelatedGroups;
            }
            boolean first = true;
            if (q.userId != null && uniqueUser != null) {
                first = false;
                resultsMain.add(uniqueUser);
            }
            if (q.groupsAssociatedWith.size() > 0) {
                if (first) {
                    resultsMain = resultsAssociatedGroups;
                    first = false;
                } else {
                    resultsMain = this.mergeIdentityTypeWithAND(resultsMain, resultsAssociatedGroups);
                }
            }
            if (q.groupsConnectedWithRole.size() > 0) {
                if (first) {
                    resultsMain = resultsConnectedWithRoleGroups;
                    first = false;
                } else {
                    resultsMain = this.mergeIdentityTypeWithAND(resultsMain, resultsConnectedWithRoleGroups);
                }
            }
            if (q.groupsRelated.size() > 0) {
                if (first) {
                    resultsMain = resultsRelatedGroups;
                    first = false;
                } else {
                    resultsMain = this.mergeIdentityTypeWithAND(resultsMain, resultsRelatedGroups);
                }
            }
            if (resultsMain.size() > 0) {
                resultsMain = IdentitySearchCriteriaImpl.applyCriteria(this.identitySession, q.searchCriteria, resultsMain);
            }
        }
        catch (Exception e) {
            throw new QueryException("Failed to execute query", (Throwable)e);
        }
        return resultsMain;
    }

    public User uniqueResult(UserQueryImpl userQuery) throws QueryException {
        Collection<User> results = this.execute(userQuery);
        if (results.size() > 1) {
            throw new QueryException("More than one result returned");
        }
        if (results.size() == 1) {
            return results.iterator().next();
        }
        return null;
    }

    public List<User> list(UserQueryImpl userQuery) throws QueryException {
        Collection<User> results = this.execute(userQuery);
        if (results instanceof List) {
            return (List)results;
        }
        throw new NotYetImplementedException();
    }
}

