/*
* JBoss, a division of Red Hat
* Copyright 2006, Red Hat Middleware, LLC, and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.picketlink.idm.api;

/**
 * Describes capabilities of PersistenceManager
 *
 * @author <a href="mailto:boleslaw.dawidowicz at redhat.com">Boleslaw Dawidowicz</a>
 * @version : 0.1 $
 */
public interface PersistenceManagerFeaturesDescription
{

   /**
    * Check if User objects can be created and removed
    * @return
    */
   boolean isUsersAddRemoveSupported();

   /**
    * Check if Group objects can be created and removed
    * 
    * @param groupType
    * @return
    */
   boolean isGroupsAddRemoveSupported(String groupType);

   /**
    * Check if criterium can be used in Identity search methods
    *
    * @param criteriumType
    * @return
    */
   boolean isUsersSearchCriteriumTypeSupported(IdentitySearchCriteriumType criteriumType);

   /**
    * Check if criterium  can be used in Group search methods
    *
    * @param groupType
    * @param criteriumType
    * @return
    */
   boolean isGroupsSearchCriteriumTypeSupported(String groupType, IdentitySearchCriteriumType criteriumType);

}