/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.api.session.managers;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentitySearchCriteria;
import org.picketlink.idm.api.IdentitySearchCriteriumType;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.RelationshipManager;
import org.picketlink.idm.api.RelationshipManagerFeaturesDescription;
import org.picketlink.idm.api.User;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.api.IdentitySearchCriteriaImpl;
import org.picketlink.idm.impl.api.model.GroupKey;
import org.picketlink.idm.impl.api.model.SimpleGroup;
import org.picketlink.idm.impl.api.model.SimpleUser;
import org.picketlink.idm.impl.api.session.IdentitySessionImpl;
import org.picketlink.idm.impl.api.session.managers.AbstractManager;
import org.picketlink.idm.impl.cache.GroupSearchImpl;
import org.picketlink.idm.impl.cache.RelationshipSearchImpl;
import org.picketlink.idm.impl.cache.UserSearchImpl;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectRelationship;
import org.picketlink.idm.spi.model.IdentityObjectRelationshipType;
import org.picketlink.idm.spi.model.IdentityObjectType;
import org.picketlink.idm.spi.store.IdentityObjectSearchCriteriaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipManagerImpl
extends AbstractManager
implements RelationshipManager,
Serializable {
    RelationshipManagerFeaturesDescription featuresDescription = new RelationshipManagerFeaturesDescription(){

        public boolean isIdentityAssociationSupported(String fromGroupType) {
            IdentityObjectType identityOT = RelationshipManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType();
            IdentityObjectType groupIdentityOT = RelationshipManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(fromGroupType);
            try {
                return RelationshipManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isRelationshipTypeSupported(groupIdentityOT, identityOT, MEMBER);
            }
            catch (IdentityException e) {
                return false;
            }
        }

        public boolean isGroupAssociationSupported(String fromGroupType, String toGroupType) {
            IdentityObjectType toGroupOT = RelationshipManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(toGroupType);
            IdentityObjectType fromGroupOT = RelationshipManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(fromGroupType);
            try {
                return RelationshipManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isRelationshipTypeSupported(fromGroupOT, toGroupOT, MEMBER);
            }
            catch (IdentityException e) {
                return false;
            }
        }

        public boolean isIdentitiesSearchCriteriumTypeSupported(IdentitySearchCriteriumType constraintType) {
            IdentityObjectType objectType = RelationshipManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType();
            IdentityObjectSearchCriteriaType constraint = IdentityObjectSearchCriteriaType.valueOf(constraintType.name());
            if (constraint != null) {
                return RelationshipManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isSearchCriteriaTypeSupported(objectType, constraint);
            }
            return false;
        }

        public boolean isGroupsSearchCriteriumTypeSupported(String groupType, IdentitySearchCriteriumType constraintType) {
            IdentityObjectType objectType = RelationshipManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(groupType);
            IdentityObjectSearchCriteriaType constraint = IdentityObjectSearchCriteriaType.valueOf(constraintType.name());
            if (constraint != null) {
                return RelationshipManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isSearchCriteriaTypeSupported(objectType, constraint);
            }
            return false;
        }
    };
    public static final IdentityObjectRelationshipType MEMBER = new IdentityObjectRelationshipType(){

        public String getName() {
            return "JBOSS_IDENTITY_MEMBERSHIP";
        }
    };
    private static final long serialVersionUID = -1054805796187123311L;

    public RelationshipManagerImpl(IdentitySessionImpl session) {
        super(session);
    }

    @Override
    public RelationshipManagerFeaturesDescription getFeaturesDescription() {
        return this.featuresDescription;
    }

    @Override
    public void associateGroups(Collection<Group> parents, Collection<Group> members) throws IdentityException {
        this.checkNotNullArgument(parents, "parents");
        this.checkNotNullArgument(members, "members");
        for (Group parent : parents) {
            for (Group member : members) {
                this.associateGroups(parent, member);
            }
        }
    }

    @Override
    public void associateGroups(Group parent, Collection<Group> members) throws IdentityException {
        this.checkNotNullArgument(parent, "parent");
        this.checkNotNullArgument(members, "members");
        this.associateGroups(Arrays.asList(parent), members);
    }

    @Override
    public void associateGroupsByKeys(Collection<String> parentIds, Collection<String> memberIds) throws IdentityException {
        this.checkNotNullArgument(parentIds, "Parents Ids");
        this.checkNotNullArgument(memberIds, "Members Ids");
        for (String parentId : parentIds) {
            for (String memberId : memberIds) {
                this.associateGroupsByKeys(parentId, memberId);
            }
        }
    }

    @Override
    public void associateGroupsByKeys(String parentId, Collection<String> memberIds) throws IdentityException {
        this.checkNotNullArgument(parentId, "Parent Id");
        this.associateGroupsByKeys(Arrays.asList(parentId), memberIds);
    }

    @Override
    public void associateGroups(Group parent, Group member) throws IdentityException {
        this.checkNotNullArgument(parent, "Parent group");
        this.checkNotNullArgument(member, "Member group");
        this.preGroupAssociationCreate(parent, member);
        this.getRepository().createRelationship(this.getInvocationContext(), this.createIdentityObject(parent), this.createIdentityObject(member), MEMBER, null, true);
        if (this.cache != null) {
            this.cache.invalidateAllQueries(this.cacheNS);
            this.cache.invalidateAllSearches(this.cacheNS);
        }
        this.postGroupAssociationCreate(parent, member);
    }

    @Override
    public void associateGroupsByKeys(String parentId, String memberId) throws IdentityException {
        this.checkNotNullArgument(parentId, "Parent Id");
        this.checkNotNullArgument(memberId, "Member Id");
        SimpleGroup parent = new SimpleGroup(new GroupKey(parentId));
        SimpleGroup member = new SimpleGroup(new GroupKey(memberId));
        this.preGroupAssociationCreate(parent, member);
        this.getRepository().createRelationship(this.getInvocationContext(), this.createIdentityObjectForGroupId(parentId), this.createIdentityObjectForGroupId(memberId), MEMBER, null, true);
        if (this.cache != null) {
            this.cache.invalidateAllQueries(this.cacheNS);
            this.cache.invalidateAllSearches(this.cacheNS);
        }
        this.postGroupAssociationCreate(parent, member);
    }

    @Override
    public void associateUsers(Collection<Group> parents, Collection<User> members) throws IdentityException {
        this.checkNotNullArgument(parents, "parents");
        this.checkNotNullArgument(members, "members");
        for (Group parent : parents) {
            for (User member : members) {
                this.associateUser(parent, member);
            }
        }
    }

    @Override
    public void associateUser(Group parent, Collection<User> members) throws IdentityException {
        this.checkNotNullArgument(parent, "Parent group");
        this.associateUsers(Arrays.asList(parent), members);
    }

    @Override
    public void associateUsersByKeys(Collection<String> parents, Collection<String> members) throws IdentityException {
        this.checkNotNullArgument(parents, "parents");
        this.checkNotNullArgument(members, "members");
        for (String parent : parents) {
            for (String member : members) {
                this.associateUserByKeys(parent, member);
            }
        }
    }

    @Override
    public void associateUsersByKeys(String parentId, Collection<String> members) throws IdentityException {
        this.checkNotNullArgument(parentId, "Parent Id");
        this.associateUsersByKeys(Arrays.asList(parentId), members);
    }

    @Override
    public void associateUser(Group parent, User member) throws IdentityException {
        this.checkNotNullArgument(parent, "Parent group");
        this.checkNotNullArgument(member, "Member user");
        this.preUserAssociationCreate(parent, member);
        this.getRepository().createRelationship(this.getInvocationContext(), this.createIdentityObject(parent), this.createIdentityObject(member), MEMBER, null, true);
        if (this.cache != null) {
            this.cache.invalidateAllQueries(this.cacheNS);
            this.cache.invalidateAllSearches(this.cacheNS);
        }
        this.postUserAssociationCreate(parent, member);
    }

    @Override
    public void associateUserByKeys(String parentId, String memberId) throws IdentityException {
        this.checkNotNullArgument(parentId, "Parent group Id");
        this.checkNotNullArgument(memberId, "Member user Id");
        SimpleGroup parent = new SimpleGroup(new GroupKey(parentId));
        SimpleUser member = new SimpleUser(memberId);
        this.preUserAssociationCreate(parent, member);
        this.getRepository().createRelationship(this.getInvocationContext(), this.createIdentityObjectForGroupId(parentId), this.createIdentityObjectForUserName(memberId), MEMBER, null, true);
        if (this.cache != null) {
            this.cache.invalidateAllQueries(this.cacheNS);
            this.cache.invalidateAllSearches(this.cacheNS);
        }
        this.postUserAssociationCreate(parent, member);
    }

    @Override
    public void disassociateGroups(User user) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        Collection<Group> groups = this.findAssociatedGroups(user, (String)null);
        HashSet<User> users = new HashSet<User>();
        users.add(user);
        this.disassociateUsers(groups, users);
    }

    @Override
    public void disassociateGroups(String userId) throws IdentityException {
        this.checkNotNullArgument(userId, "User Id");
        this.disassociateGroups(this.createUserFromId(userId));
    }

    @Override
    public void disassociateGroups(Collection<Group> parents, Collection<Group> members) throws IdentityException {
        this.checkNotNullArgument(parents, "parents");
        this.checkNotNullArgument(members, "members");
        for (Group parent : parents) {
            for (Group member : members) {
                this.preGroupAssociationRemove(parent, member);
                this.getRepository().removeRelationship(this.getInvocationContext(), this.createIdentityObject(parent), this.createIdentityObject(member), MEMBER, null);
                if (this.cache != null) {
                    this.cache.invalidateAllQueries(this.cacheNS);
                    this.cache.invalidateAllSearches(this.cacheNS);
                }
                this.postGroupAssociationRemove(parent, member);
            }
        }
    }

    @Override
    public void disassociateGroups(Group parent, Collection<Group> members) throws IdentityException {
        this.checkNotNullArgument(parent, "Parent");
        this.disassociateGroups(Arrays.asList(parent), members);
    }

    @Override
    public void disassociateGroupsByKeys(Collection<String> parents, Collection<String> members) throws IdentityException {
        this.checkNotNullArgument(parents, "parents");
        this.checkNotNullArgument(members, "members");
        for (String parent : parents) {
            for (String member : members) {
                SimpleGroup parentGroup = new SimpleGroup(new GroupKey(parent));
                SimpleGroup memberGroup = new SimpleGroup(new GroupKey(member));
                this.preGroupAssociationRemove(parentGroup, memberGroup);
                this.getRepository().removeRelationship(this.getInvocationContext(), this.createIdentityObjectForGroupId(parent), this.createIdentityObjectForGroupId(member), MEMBER, null);
                if (this.cache != null) {
                    this.cache.invalidateAllQueries(this.cacheNS);
                    this.cache.invalidateAllSearches(this.cacheNS);
                }
                this.postGroupAssociationRemove(parentGroup, memberGroup);
            }
        }
    }

    @Override
    public void disassociateGroupsByKeys(String parent, Collection<String> members) throws IdentityException {
        this.checkNotNullArgument(parent, "Parent Id");
        this.disassociateGroupsByKeys(Arrays.asList(parent), members);
    }

    @Override
    public void disassociateUsers(Collection<Group> parents, Collection<User> members) throws IdentityException {
        this.checkNotNullArgument(parents, "parents");
        this.checkNotNullArgument(members, "members");
        for (Group parent : parents) {
            for (User member : members) {
                this.preUserAssociationRemove(parent, member);
                this.getRepository().removeRelationship(this.getInvocationContext(), this.createIdentityObject(parent), this.createIdentityObject(member), MEMBER, null);
                if (this.cache != null) {
                    this.cache.invalidateAllQueries(this.cacheNS);
                    this.cache.invalidateAllSearches(this.cacheNS);
                }
                this.postUserAssociationRemove(parent, member);
            }
        }
    }

    @Override
    public void disassociateUsers(Group parent, Collection<User> members) throws IdentityException {
        this.checkNotNullArgument(parent, "Parent group");
        this.disassociateUsers(Arrays.asList(parent), members);
    }

    @Override
    public void disassociateUsersByKeys(Collection<String> parents, Collection<String> members) throws IdentityException {
        this.checkNotNullArgument(parents, "parents");
        this.checkNotNullArgument(members, "members");
        for (String parent : parents) {
            for (String member : members) {
                SimpleGroup parentGroup = new SimpleGroup(new GroupKey(parent));
                SimpleUser memberUser = new SimpleUser(member);
                this.preUserAssociationRemove(parentGroup, memberUser);
                this.getRepository().removeRelationship(this.getInvocationContext(), this.createIdentityObjectForGroupId(parent), this.createIdentityObjectForUserName(member), MEMBER, null);
                if (this.cache != null) {
                    this.cache.invalidateAllQueries(this.cacheNS);
                    this.cache.invalidateAllSearches(this.cacheNS);
                }
                this.postUserAssociationRemove(parentGroup, memberUser);
            }
        }
    }

    @Override
    public void disassociateUsersByKeys(String parent, Collection<String> members) throws IdentityException {
        this.checkNotNullArgument(parent, "Parent Id");
        this.disassociateUsersByKeys(Arrays.asList(parent), members);
    }

    @Override
    public <G extends IdentityType, I extends IdentityType> boolean isAssociated(Collection<G> parents, Collection<I> members) throws IdentityException {
        RelationshipSearchImpl search;
        this.checkNotNullArgument(parents, "parents");
        this.checkNotNullArgument(members, "members");
        if (this.cache != null) {
            search = new RelationshipSearchImpl();
            for (IdentityType parent : parents) {
                search.addParent(parent);
            }
            for (IdentityType member : members) {
                search.addMember(member);
            }
            Boolean result = this.cache.getRelationshipSearch(this.cacheNS, search);
            if (result != null) {
                return result;
            }
        }
        for (IdentityType parent : parents) {
            for (IdentityType member : members) {
                Set<IdentityObjectRelationship> relationships = this.getRepository().resolveRelationships(this.getInvocationContext(), this.createIdentityObject(parent), this.createIdentityObject(member), MEMBER);
                if (relationships.size() != 0) continue;
                if (this.cache != null) {
                    RelationshipSearchImpl search2 = new RelationshipSearchImpl();
                    for (IdentityType p : parents) {
                        search2.addParent(p);
                    }
                    for (IdentityType m : members) {
                        search2.addMember(m);
                    }
                    this.cache.putRelationshipSearch(this.cacheNS, search2, false);
                }
                return false;
            }
        }
        if (this.cache != null) {
            search = new RelationshipSearchImpl();
            for (IdentityType p : parents) {
                search.addParent(p);
            }
            for (IdentityType m : members) {
                search.addMember(m);
            }
            this.cache.putRelationshipSearch(this.cacheNS, search, true);
        }
        return true;
    }

    @Override
    public boolean isAssociatedByKeys(Collection<String> parents, Collection<String> members) throws IdentityException {
        RelationshipSearchImpl search;
        this.checkNotNullArgument(parents, "parents");
        this.checkNotNullArgument(members, "members");
        if (this.cache != null) {
            search = new RelationshipSearchImpl();
            for (String parent : parents) {
                search.addParent(parent);
            }
            for (String member : members) {
                search.addMember(member);
            }
            Boolean result = this.cache.getRelationshipSearch(this.cacheNS, search);
            if (result != null) {
                return result;
            }
        }
        for (String parent : parents) {
            for (String member : members) {
                Set<IdentityObjectRelationship> relationships = this.getRepository().resolveRelationships(this.getInvocationContext(), this.createIdentityObject(parent), this.createIdentityObject(member), MEMBER);
                if (relationships.size() != 0) continue;
                if (this.cache != null) {
                    RelationshipSearchImpl search2 = new RelationshipSearchImpl();
                    for (String p : parents) {
                        search2.addParent(p);
                    }
                    for (String m : members) {
                        search2.addMember(m);
                    }
                    this.cache.putRelationshipSearch(this.cacheNS, search2, false);
                }
                return false;
            }
        }
        if (this.cache != null) {
            search = new RelationshipSearchImpl();
            for (String p : parents) {
                search.addParent(p);
            }
            for (String m : members) {
                search.addMember(m);
            }
            this.cache.putRelationshipSearch(this.cacheNS, search, true);
        }
        return true;
    }

    @Override
    public <G extends IdentityType, I extends IdentityType> boolean isAssociated(G parent, I member) throws IdentityException {
        this.checkNotNullArgument(parent, "Parent IdentityType");
        this.checkNotNullArgument(member, "Member IdentityType");
        HashSet<G> parents = new HashSet<G>();
        parents.add(parent);
        HashSet<I> members = new HashSet<I>();
        members.add(member);
        return this.isAssociated((G)((Object)parents), (I)((Object)members));
    }

    @Override
    public boolean isAssociatedByKeys(String parent, String member) throws IdentityException {
        this.checkNotNullArgument(parent, "Parent Id");
        this.checkNotNullArgument(member, "Member Id");
        if (this.cache != null) {
            RelationshipSearchImpl search = new RelationshipSearchImpl();
            search.addParent(parent);
            search.addMember(member);
            Boolean result = this.cache.getRelationshipSearch(this.cacheNS, search);
            if (result != null) {
                return result;
            }
        }
        Set<IdentityObjectRelationship> relationships = this.getRepository().resolveRelationships(this.getInvocationContext(), this.createIdentityObject(parent), this.createIdentityObject(member), MEMBER);
        boolean result = true;
        if (relationships.size() == 0) {
            result = false;
        }
        if (this.cache != null) {
            RelationshipSearchImpl search = new RelationshipSearchImpl();
            search.addParent(parent);
            search.addMember(member);
            this.cache.putRelationshipSearch(this.cacheNS, search, result);
        }
        return result;
    }

    private Collection<Group> findAssociatedGroupsCascaded(Collection<Group> previous, Group group, String groupType, boolean parent, IdentitySearchCriteria criteria) throws IdentityException {
        Collection<Group> results = this.findAssociatedGroups(group, groupType, parent, false, criteria);
        LinkedList<Group> newResults = new LinkedList<Group>();
        for (Group result : results) {
            if (previous.contains(result)) continue;
            newResults.add(result);
            previous.add(result);
            newResults.addAll(this.findAssociatedGroupsCascaded(previous, result, groupType, parent, criteria));
        }
        return newResults;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Collection<Group> findAssociatedGroups(Group group, String groupType, boolean parent, boolean cascade, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(group, "Group");
        if (this.cache != null) {
            search = new GroupSearchImpl();
            search.addAssociatedGroupId(group.getKey());
            search.setGroupType(groupType);
            search.setParent(parent);
            search.setCascade(cascade);
            search.setSearchCriteria(criteria);
            results = this.cache.getGroupSearch(this.cacheNS, search);
            if (results != null) {
                return results;
            }
        }
        identities = new LinkedList<E>();
        v0 = iot = groupType != null ? this.getIdentityObjectType(groupType) : null;
        if (cascade) {
            prev = new HashSet<Group>();
            prev.add(group);
            identities = (List)this.findAssociatedGroupsCascaded(prev, group, groupType, parent, criteria);
            try {
                if (criteria == null) ** GOTO lbl32
                IdentitySearchCriteriaImpl.applyCriteria(this.identitySession, this.convertSearchControls(criteria), identities);
            }
            catch (Exception e) {
                throw new IdentityException("Failed to apply criteria", e);
            }
        } else {
            ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.createIdentityObject(group), RelationshipManagerImpl.MEMBER, parent, this.convertSearchControls(criteria));
            for (IdentityObject io : ios) {
                if ((iot != null || io.getIdentityType().getName().equals(this.getUserObjectType().getName())) && (iot == null || !io.getIdentityType().getName().equals(iot.getName()))) continue;
                identities.add(this.createGroup(io));
            }
        }
lbl32:
        // 3 sources

        if (this.cache != null) {
            search = new GroupSearchImpl();
            search.addAssociatedGroupId(group.getKey());
            search.setGroupType(groupType);
            search.setParent(parent);
            search.setCascade(cascade);
            search.setSearchCriteria(criteria);
            this.cache.putGroupSearch(this.cacheNS, search, identities);
        }
        return identities;
    }

    @Override
    public Collection<Group> findAssociatedGroups(String groupId, String groupType, boolean parent, boolean cascade, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(groupId, "Group Id");
        Group group = this.createGroupFromId(groupId);
        return this.findAssociatedGroups(group, groupType, parent, cascade, criteria);
    }

    @Override
    public Collection<Group> findAssociatedGroups(Group group, String groupType, boolean parent, boolean cascade) throws IdentityException {
        this.checkNotNullArgument(group, "Group");
        return this.findAssociatedGroups(group, groupType, parent, cascade, null);
    }

    @Override
    public Collection<Group> findAssociatedGroups(User user, String groupType, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        if (this.cache != null) {
            GroupSearchImpl search = new GroupSearchImpl();
            search.addAssociatedUserId(user.getKey());
            search.setGroupType(groupType);
            search.setSearchCriteria(criteria);
            Collection<Group> results = this.cache.getGroupSearch(this.cacheNS, search);
            if (results != null) {
                return results;
            }
        }
        LinkedList<Group> identities = new LinkedList<Group>();
        IdentityObjectType iot = groupType != null ? this.getIdentityObjectType(groupType) : null;
        Collection<IdentityObject> ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.createIdentityObject(user), MEMBER, false, this.convertSearchControls(criteria));
        for (IdentityObject io : ios) {
            if (iot != null && !io.getIdentityType().getName().equals(iot.getName())) continue;
            identities.add(this.createGroup(io));
        }
        if (this.cache != null) {
            GroupSearchImpl search = new GroupSearchImpl();
            search.addAssociatedUserId(user.getKey());
            search.setGroupType(groupType);
            search.setSearchCriteria(criteria);
            this.cache.putGroupSearch(this.cacheNS, search, identities);
        }
        return identities;
    }

    @Override
    public Collection<Group> findAssociatedGroups(String userName, String groupType, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(userName, "User name");
        User user = this.createUserFromId(userName);
        return this.findAssociatedGroups(user, groupType, criteria);
    }

    @Override
    public Collection<Group> findAssociatedGroups(User user, String groupType) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        return this.findAssociatedGroups(user, groupType, null);
    }

    @Override
    public Collection<Group> findAssociatedGroups(User user, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        if (this.cache != null) {
            GroupSearchImpl search = new GroupSearchImpl();
            search.addAssociatedUserId(user.getKey());
            search.setSearchCriteria(criteria);
            Collection<Group> results = this.cache.getGroupSearch(this.cacheNS, search);
            if (results != null) {
                return results;
            }
        }
        LinkedList<Group> identities = new LinkedList<Group>();
        Collection<IdentityObject> ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.createIdentityObject(user), MEMBER, false, this.convertSearchControls(criteria));
        String userTypeName = this.getUserObjectType().getName();
        for (IdentityObject io : ios) {
            if (io.getIdentityType().getName().equals(userTypeName)) continue;
            identities.add(this.createGroup(io));
        }
        if (this.cache != null) {
            GroupSearchImpl search = new GroupSearchImpl();
            search.addAssociatedUserId(user.getKey());
            search.setSearchCriteria(criteria);
            this.cache.putGroupSearch(this.cacheNS, search, identities);
        }
        return identities;
    }

    @Override
    public Collection<Group> findAssociatedGroups(String userName, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(userName, "User name");
        User user = this.createUserFromId(userName);
        return this.findAssociatedGroups(user, criteria);
    }

    @Override
    public Collection<Group> findAssociatedGroups(User user) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        return this.findAssociatedGroups(user, (IdentitySearchCriteria)null);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Collection<User> findAssociatedUsers(Group group, boolean cascade, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(group, "Group");
        if (this.cache != null) {
            search = new UserSearchImpl();
            search.addAssociatedGroupId(group.getKey());
            search.setCascade(cascade);
            search.setSearchCriteria(criteria);
            results = this.cache.getUserSearch(this.cacheNS, search);
            if (results != null) {
                return results;
            }
        }
        identities = new LinkedList<User>();
        if (cascade) {
            identities.addAll(this.findAssociatedUsers(group, false, criteria));
            groups = this.findAssociatedGroups(group, null, true, true, criteria);
            for (Group asociatedGroup : groups) {
                identities.addAll(this.findAssociatedUsers(asociatedGroup, false, criteria));
            }
            try {
                if (criteria == null) ** GOTO lbl33
                IdentitySearchCriteriaImpl.applyCriteria(this.identitySession, this.convertSearchControls(criteria), identities);
            }
            catch (Exception e) {
                throw new IdentityException("Failed to apply criteria", e);
            }
        } else {
            ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.createIdentityObject(group), RelationshipManagerImpl.MEMBER, true, this.convertSearchControls(criteria));
            userTypeName = this.getUserObjectType().getName();
            for (IdentityObject io : ios) {
                if (!io.getIdentityType().getName().equals(userTypeName)) continue;
                identities.add(this.createUser(io));
            }
        }
lbl33:
        // 3 sources

        if (this.cache != null) {
            search = new UserSearchImpl();
            search.addAssociatedGroupId(group.getKey());
            search.setCascade(cascade);
            search.setSearchCriteria(criteria);
            this.cache.putUserSearch(this.cacheNS, search, identities);
        }
        return identities;
    }

    @Override
    public Collection<User> findAssociatedUsers(String groupId, boolean cascade, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(groupId, "Group Id");
        Group group = this.createGroupFromId(groupId);
        return this.findAssociatedUsers(group, cascade, criteria);
    }

    @Override
    public Collection<User> findAssociatedUsers(Group group, boolean cascade) throws IdentityException {
        this.checkNotNullArgument(group, "Group");
        return this.findAssociatedUsers(group, cascade, null);
    }

    @Override
    public Collection<Group> findRelatedGroups(User user, String groupType, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        if (this.cache != null) {
            GroupSearchImpl search = new GroupSearchImpl();
            search.addRelatedUserId(user.getKey());
            search.setGroupType(groupType);
            search.setSearchCriteria(criteria);
            Collection<Group> results = this.cache.getGroupSearch(this.cacheNS, search);
            if (results != null) {
                return results;
            }
        }
        LinkedList<Group> identities = new LinkedList<Group>();
        Collection<IdentityObject> ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.createIdentityObject(user), null, false, this.convertSearchControls(criteria));
        String userTypeName = this.getUserObjectType().getName();
        for (IdentityObject io : ios) {
            if (io.getIdentityType().getName().equals(userTypeName)) continue;
            identities.add(this.createGroup(io));
        }
        if (this.cache != null) {
            GroupSearchImpl search = new GroupSearchImpl();
            search.addRelatedUserId(user.getKey());
            search.setGroupType(groupType);
            search.setSearchCriteria(criteria);
            Collection<Group> results = this.cache.getGroupSearch(this.cacheNS, search);
            if (results != null) {
                return results;
            }
        }
        return identities;
    }

    @Override
    public Collection<Group> findRelatedGroups(String userName, String groupType, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(userName, "User name");
        User user = this.createUserFromId(userName);
        return this.findRelatedGroups(user, groupType, criteria);
    }

    @Override
    public Collection<User> findRelatedUsers(Group group, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(group, "Group");
        if (this.cache != null) {
            UserSearchImpl search = new UserSearchImpl();
            search.addRelatedGroupId(group.getKey());
            search.setSearchCriteria(criteria);
            Collection<User> results = this.cache.getUserSearch(this.cacheNS, search);
            if (results != null) {
                return results;
            }
        }
        LinkedList<User> identities = new LinkedList<User>();
        Collection<IdentityObject> ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.createIdentityObject(group), null, true, this.convertSearchControls(criteria));
        String userTypeName = this.getUserObjectType().getName();
        for (IdentityObject io : ios) {
            User user;
            if (!io.getIdentityType().getName().equals(userTypeName) || identities.contains(user = this.createUser(io))) continue;
            identities.add(this.createUser(io));
        }
        if (this.cache != null) {
            UserSearchImpl search = new UserSearchImpl();
            search.addRelatedGroupId(group.getKey());
            search.setSearchCriteria(criteria);
            this.cache.putUserSearch(this.cacheNS, search, identities);
        }
        return identities;
    }

    @Override
    public Collection<User> findRelatedUsers(String groupId, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(groupId, "Group Id");
        Group group = this.createGroupFromId(groupId);
        return this.findRelatedUsers(group, criteria);
    }
}

