/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.List;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jgroups.ChannelException;
import org.jgroups.ChannelFactory;
import org.jgroups.JChannelFactory;
import org.jgroups.blocks.DistributedQueue;

public class DistributedQueueDemo
extends Frame
implements WindowListener,
ActionListener,
DistributedQueue.Notification {
    DistributedQueue h = null;
    final JButton add = new JButton("Add");
    final JButton quit = new JButton("Quit");
    final JButton get_all = new JButton("All");
    final JButton remove = new JButton("Remove");
    final JLabel value = new JLabel("Value");
    final JLabel err_msg = new JLabel("Error");
    final JTextField value_field = new JTextField();
    final List listbox = new List();
    final Font default_font = new Font("Helvetica", 0, 12);

    public DistributedQueueDemo() {
        this.addWindowListener(this);
    }

    private void showMsg(String msg) {
        this.err_msg.setText(msg);
        this.err_msg.setVisible(true);
    }

    private void clearMsg() {
        this.err_msg.setVisible(false);
    }

    private void removeItem() {
        this.h.remove();
    }

    private void showAll() {
        if (this.listbox.getItemCount() > 0) {
            this.listbox.removeAll();
        }
        if (this.h.size() == 0) {
            return;
        }
        this.clearMsg();
        Vector v = this.h.getContents();
        for (int i = 0; i < v.size(); ++i) {
            this.listbox.add((String)v.elementAt(i));
        }
    }

    public void start(String groupname, ChannelFactory factory, String props) throws ChannelException {
        this.h = new DistributedQueue(groupname, factory, props, 10000L);
        this.h.addNotifier(this);
        this.setLayout(null);
        this.setSize(400, 300);
        this.setFont(this.default_font);
        this.value.setBounds(new Rectangle(10, 60, 60, 30));
        this.value_field.setBounds(new Rectangle(100, 60, 100, 30));
        this.listbox.setBounds(new Rectangle(210, 30, 150, 160));
        this.err_msg.setBounds(new Rectangle(10, 200, 350, 30));
        this.err_msg.setFont(new Font("Helvetica", 2, 12));
        this.err_msg.setForeground(Color.red);
        this.err_msg.setVisible(false);
        this.add.setBounds(new Rectangle(60, 250, 60, 30));
        this.quit.setBounds(new Rectangle(130, 250, 70, 30));
        this.get_all.setBounds(new Rectangle(210, 250, 60, 30));
        this.remove.setBounds(new Rectangle(280, 250, 90, 30));
        this.add.addActionListener(this);
        this.quit.addActionListener(this);
        this.get_all.addActionListener(this);
        this.remove.addActionListener(this);
        this.add(this.value);
        this.add(this.value_field);
        this.add(this.err_msg);
        this.add(this.add);
        this.add(this.quit);
        this.add(this.get_all);
        this.add(this.remove);
        this.add(this.listbox);
        this.setTitle("DistributedQueue Demo");
        this.showAll();
        this.setVisible(true);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        System.exit(0);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        try {
            if (command == "Add") {
                String value_name = this.value_field.getText();
                if (value_name == null || value_name.length() == 0) {
                    this.showMsg("Value is empty !");
                    return;
                }
                this.showMsg("Adding value " + value_name + ':');
                this.h.add(value_name);
            } else if (command == "All") {
                this.showAll();
            } else if (command == "Quit") {
                this.setVisible(false);
                System.exit(0);
            } else if (command == "Remove") {
                this.removeItem();
            } else {
                System.out.println("Unknown action");
            }
        }
        catch (Exception ex) {
            this.value_field.setText("");
            this.showMsg(ex.toString());
        }
    }

    public void entryAdd(Object value) {
        this.showAll();
    }

    public void entryRemoved(Object key) {
        this.showAll();
    }

    public void viewChange(Vector joined, Vector left) {
        System.out.println("New members: " + joined + ", left members: " + left);
    }

    public void contentsSet(Collection new_entries) {
        System.out.println("Contents Set:" + new_entries);
    }

    public void contentsCleared() {
        System.out.println("Contents cleared()");
    }

    public static void main(String[] args) {
        String groupname = "QueueDemo";
        DistributedQueueDemo client = new DistributedQueueDemo();
        JChannelFactory factory = new JChannelFactory();
        boolean trace = false;
        boolean persist = false;
        String props = "udp.xml";
        try {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if ("-trace".equals(arg)) {
                    trace = true;
                    continue;
                }
                if ("-groupname".equals(args[i])) {
                    groupname = args[++i];
                    continue;
                }
                DistributedQueueDemo.help();
                return;
            }
        }
        catch (Exception e) {
            DistributedQueueDemo.help();
            return;
        }
        try {
            client.start(groupname, factory, props);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static void help() {
        System.out.println("DistributedQueueDemo [-help]");
    }
}

