/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.repository;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.repository.AbstractIdentityStoreRepository;
import org.picketlink.idm.impl.repository.RepositoryIdentityStoreSessionImpl;
import org.picketlink.idm.impl.store.SimpleIdentityStoreInvocationContext;
import org.picketlink.idm.spi.configuration.IdentityRepositoryConfigurationContext;
import org.picketlink.idm.spi.configuration.IdentityStoreConfigurationContext;
import org.picketlink.idm.spi.configuration.metadata.IdentityObjectAttributeMetaData;
import org.picketlink.idm.spi.exception.OperationNotSupportedException;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectAttribute;
import org.picketlink.idm.spi.model.IdentityObjectCredential;
import org.picketlink.idm.spi.model.IdentityObjectRelationship;
import org.picketlink.idm.spi.model.IdentityObjectRelationshipType;
import org.picketlink.idm.spi.model.IdentityObjectType;
import org.picketlink.idm.spi.search.IdentityObjectSearchCriteria;
import org.picketlink.idm.spi.store.AttributeStore;
import org.picketlink.idm.spi.store.FeaturesMetaData;
import org.picketlink.idm.spi.store.IdentityStore;
import org.picketlink.idm.spi.store.IdentityStoreInvocationContext;
import org.picketlink.idm.spi.store.IdentityStoreSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapperIdentityStoreRepository
extends AbstractIdentityStoreRepository {
    private final String id;

    public WrapperIdentityStoreRepository(String id) {
        this.id = id;
    }

    @Override
    public void bootstrap(IdentityRepositoryConfigurationContext configurationContext, Map<String, IdentityStore> bootstrappedIdentityStores, Map<String, AttributeStore> bootstrappedAttributeStores) throws IdentityException {
        super.bootstrap(configurationContext, bootstrappedIdentityStores, bootstrappedAttributeStores);
    }

    public void bootstrap(IdentityStoreConfigurationContext configurationContext) throws IdentityException {
    }

    public IdentityStoreSession createIdentityStoreSession() throws IdentityException {
        HashMap<String, IdentityStoreSession> sessions = new HashMap<String, IdentityStoreSession>();
        sessions.put(this.defaultAttributeStore.getId(), this.defaultAttributeStore.createIdentityStoreSession());
        if (!sessions.containsKey(this.defaultIdentityStore.getId())) {
            sessions.put(this.defaultIdentityStore.getId(), this.defaultIdentityStore.createIdentityStoreSession());
        }
        return new RepositoryIdentityStoreSessionImpl(sessions);
    }

    public IdentityStoreSession createIdentityStoreSession(Map<String, Object> sessionOptions) throws IdentityException {
        HashMap<String, IdentityStoreSession> sessions = new HashMap<String, IdentityStoreSession>();
        sessions.put(this.defaultAttributeStore.getId(), this.defaultAttributeStore.createIdentityStoreSession(sessionOptions));
        if (!sessions.containsKey(this.defaultIdentityStore.getId())) {
            sessions.put(this.defaultIdentityStore.getId(), this.defaultIdentityStore.createIdentityStoreSession(sessionOptions));
        }
        return new RepositoryIdentityStoreSessionImpl(sessions);
    }

    IdentityStoreInvocationContext resolveIdentityStoreInvocationContext(IdentityStoreInvocationContext invocationCtx) {
        return this.resolveInvocationContext(this.defaultIdentityStore.getId(), invocationCtx);
    }

    IdentityStoreInvocationContext resolveAttributeStoreInvocationContext(IdentityStoreInvocationContext invocationCtx) {
        return this.resolveInvocationContext(this.defaultAttributeStore.getId(), invocationCtx);
    }

    IdentityStoreInvocationContext resolveInvocationContext(String id, IdentityStoreInvocationContext invocationCtx) {
        RepositoryIdentityStoreSessionImpl repoSession = (RepositoryIdentityStoreSessionImpl)invocationCtx.getIdentityStoreSession();
        IdentityStoreSession targetSession = repoSession.getIdentityStoreSession(id);
        return new SimpleIdentityStoreInvocationContext(targetSession, invocationCtx.getRealmId(), String.valueOf(this.hashCode()));
    }

    public String getId() {
        return this.id;
    }

    public FeaturesMetaData getSupportedFeatures() {
        return this.defaultIdentityStore.getSupportedFeatures();
    }

    public IdentityObject createIdentityObject(IdentityStoreInvocationContext invocationCtx, String name, IdentityObjectType identityObjectType) throws IdentityException {
        return this.defaultIdentityStore.createIdentityObject(this.resolveIdentityStoreInvocationContext(invocationCtx), name, identityObjectType);
    }

    public IdentityObject createIdentityObject(IdentityStoreInvocationContext invocationCtx, String name, IdentityObjectType identityObjectType, Map<String, String[]> attributes) throws IdentityException {
        return this.defaultIdentityStore.createIdentityObject(this.resolveIdentityStoreInvocationContext(invocationCtx), name, identityObjectType, attributes);
    }

    public void removeIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObject identity) throws IdentityException {
        this.defaultIdentityStore.removeIdentityObject(this.resolveIdentityStoreInvocationContext(invocationCtx), identity);
    }

    public int getIdentityObjectsCount(IdentityStoreInvocationContext invocationCtx, IdentityObjectType identityType) throws IdentityException {
        return this.defaultIdentityStore.getIdentityObjectsCount(this.resolveIdentityStoreInvocationContext(invocationCtx), identityType);
    }

    public IdentityObject findIdentityObject(IdentityStoreInvocationContext invocationContext, String name, IdentityObjectType identityObjectType) throws IdentityException {
        return this.defaultIdentityStore.findIdentityObject(this.resolveIdentityStoreInvocationContext(invocationContext), name, identityObjectType);
    }

    public IdentityObject findIdentityObject(IdentityStoreInvocationContext invocationContext, String id) throws IdentityException {
        return this.defaultIdentityStore.findIdentityObject(this.resolveIdentityStoreInvocationContext(invocationContext), id);
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObjectType identityType, IdentityObjectSearchCriteria criteria) throws IdentityException {
        return this.defaultIdentityStore.findIdentityObject(this.resolveIdentityStoreInvocationContext(invocationCtx), identityType, criteria);
    }

    public int getIdentityObjectCount(IdentityStoreInvocationContext invocationCxt, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        return this.defaultIdentityStore.getIdentityObjectCount(invocationCxt, identity, relationshipType, parent, criteria);
    }

    public int getIdentityObjectCount(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, Collection<IdentityObjectType> excludes, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        return this.defaultIdentityStore.getIdentityObjectCount(ctx, identity, relationshipType, excludes, parent, criteria);
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, Collection<IdentityObjectType> excludes, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        return this.defaultIdentityStore.findIdentityObject(this.resolveIdentityStoreInvocationContext(invocationCtx), identity, relationshipType, excludes, parent, criteria);
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        return this.defaultIdentityStore.findIdentityObject(this.resolveIdentityStoreInvocationContext(invocationCtx), identity, relationshipType, parent, criteria);
    }

    public IdentityObjectRelationship createRelationship(IdentityStoreInvocationContext invocationCxt, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String relationshipName, boolean createNames) throws IdentityException {
        return this.defaultIdentityStore.createRelationship(this.resolveIdentityStoreInvocationContext(invocationCxt), fromIdentity, toIdentity, relationshipType, relationshipName, createNames);
    }

    public void removeRelationship(IdentityStoreInvocationContext invocationCxt, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String relationshipName) throws IdentityException {
        this.defaultIdentityStore.removeRelationship(this.resolveIdentityStoreInvocationContext(invocationCxt), fromIdentity, toIdentity, relationshipType, relationshipName);
    }

    public void removeRelationships(IdentityStoreInvocationContext invocationCtx, IdentityObject identity1, IdentityObject identity2, boolean named) throws IdentityException {
        this.defaultIdentityStore.removeRelationships(this.resolveIdentityStoreInvocationContext(invocationCtx), identity1, identity2, named);
    }

    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext invocationCxt, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType) throws IdentityException {
        return this.defaultIdentityStore.resolveRelationships(this.resolveIdentityStoreInvocationContext(invocationCxt), fromIdentity, toIdentity, relationshipType);
    }

    public int getRelationshipsCount(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType type, boolean parent, boolean named, String name, IdentityObjectSearchCriteria searchCriteria) throws IdentityException {
        return this.defaultIdentityStore.getRelationshipsCount(ctx, identity, type, parent, named, name, searchCriteria);
    }

    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, boolean named, String name, IdentityObjectSearchCriteria criteria) throws IdentityException {
        return this.defaultIdentityStore.resolveRelationships(this.resolveIdentityStoreInvocationContext(invocationCtx), identity, relationshipType, parent, named, name, criteria);
    }

    public String createRelationshipName(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        return this.defaultIdentityStore.createRelationshipName(this.resolveIdentityStoreInvocationContext(ctx), name);
    }

    public String removeRelationshipName(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        return this.defaultIdentityStore.removeRelationshipName(this.resolveIdentityStoreInvocationContext(ctx), name);
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObjectSearchCriteria criteria) throws IdentityException, OperationNotSupportedException {
        return this.defaultIdentityStore.getRelationshipNames(this.resolveIdentityStoreInvocationContext(ctx), criteria);
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectSearchCriteria criteria) throws IdentityException, OperationNotSupportedException {
        return this.defaultIdentityStore.getRelationshipNames(this.resolveIdentityStoreInvocationContext(ctx), identity, criteria);
    }

    public Map<String, String> getRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        return this.defaultIdentityStore.getRelationshipNameProperties(this.resolveAttributeStoreInvocationContext(ctx), name);
    }

    public void setRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Map<String, String> properties) throws IdentityException, OperationNotSupportedException {
        this.defaultIdentityStore.setRelationshipNameProperties(this.resolveIdentityStoreInvocationContext(ctx), name, properties);
    }

    public void removeRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Set<String> properties) throws IdentityException, OperationNotSupportedException {
        this.defaultIdentityStore.removeRelationshipNameProperties(this.resolveIdentityStoreInvocationContext(ctx), name, properties);
    }

    public Map<String, String> getRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship) throws IdentityException, OperationNotSupportedException {
        return this.defaultIdentityStore.getRelationshipProperties(this.resolveIdentityStoreInvocationContext(ctx), relationship);
    }

    public void setRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Map<String, String> properties) throws IdentityException, OperationNotSupportedException {
        this.defaultIdentityStore.setRelationshipProperties(this.resolveIdentityStoreInvocationContext(ctx), relationship, properties);
    }

    public void removeRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Set<String> properties) throws IdentityException, OperationNotSupportedException {
        this.defaultIdentityStore.removeRelationshipProperties(this.resolveIdentityStoreInvocationContext(ctx), relationship, properties);
    }

    public boolean validateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        return this.defaultIdentityStore.validateCredential(this.resolveIdentityStoreInvocationContext(ctx), identityObject, credential);
    }

    public void updateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        this.defaultIdentityStore.updateCredential(this.resolveIdentityStoreInvocationContext(ctx), identityObject, credential);
    }

    public Set<String> getSupportedAttributeNames(IdentityStoreInvocationContext invocationContext, IdentityObjectType identityType) throws IdentityException {
        return this.defaultAttributeStore.getSupportedAttributeNames(this.resolveAttributeStoreInvocationContext(invocationContext), identityType);
    }

    public Map<String, IdentityObjectAttributeMetaData> getAttributesMetaData(IdentityStoreInvocationContext invocationContext, IdentityObjectType identityType) {
        return this.defaultAttributeStore.getAttributesMetaData(this.resolveAttributeStoreInvocationContext(invocationContext), identityType);
    }

    public Map<String, IdentityObjectAttribute> getAttributes(IdentityStoreInvocationContext invocationContext, IdentityObject identity) throws IdentityException {
        return this.defaultAttributeStore.getAttributes(this.resolveAttributeStoreInvocationContext(invocationContext), identity);
    }

    public IdentityObjectAttribute getAttribute(IdentityStoreInvocationContext invocationContext, IdentityObject identity, String name) throws IdentityException {
        return this.defaultAttributeStore.getAttribute(this.resolveAttributeStoreInvocationContext(invocationContext), identity, name);
    }

    public void updateAttributes(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        this.defaultAttributeStore.updateAttributes(this.resolveAttributeStoreInvocationContext(invocationCtx), identity, attributes);
    }

    public void addAttributes(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        this.defaultAttributeStore.addAttributes(this.resolveAttributeStoreInvocationContext(invocationCtx), identity, attributes);
    }

    public void removeAttributes(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, String[] attributeNames) throws IdentityException {
        this.defaultAttributeStore.removeAttributes(this.resolveAttributeStoreInvocationContext(invocationCtx), identity, attributeNames);
    }

    public IdentityObject findIdentityObjectByUniqueAttribute(IdentityStoreInvocationContext invocationCtx, IdentityObjectType identityObjectType, IdentityObjectAttribute attribute) throws IdentityException {
        return this.defaultAttributeStore.findIdentityObjectByUniqueAttribute(this.resolveAttributeStoreInvocationContext(invocationCtx), identityObjectType, attribute);
    }
}

