/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import junit.framework.TestCase;
import org.jgroups.TimeoutException;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class PromiseTest
extends TestCase {
    Promise p;

    public PromiseTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.p = new Promise();
    }

    public void tearDown() throws Exception {
        this.p.reset();
        super.tearDown();
    }

    public void testGetResultNoTimeout() {
        new ResultSetter(this.p, 500L).start();
        Object result = this.p.getResult(0L);
        PromiseTest.assertEquals((Object)Boolean.TRUE, result);
    }

    public void testGetResultNoTimeout_ResultAlreadySet() {
        new ResultSetter(this.p, 1L).start();
        Util.sleep(100L);
        Object result = this.p.getResult(0L);
        PromiseTest.assertEquals((Object)Boolean.TRUE, result);
    }

    public void testGetResultWithTimeout() {
        try {
            this.p.getResultWithTimeout(500L);
            PromiseTest.fail((String)"this should throw a TimeoutException");
        }
        catch (TimeoutException e) {
            PromiseTest.assertNotNull((Object)e);
        }
    }

    public void testGetResultWithTimeoutNoException() {
        Object ret = this.p.getResult(500L);
        PromiseTest.assertNull(ret);
    }

    public void testGetResultWithTimeoutAndInterrupt() {
        new Interrupter(Thread.currentThread(), 100L).start();
        Object result = this.p.getResult(500L);
        PromiseTest.assertNull(result);
    }

    public void testGetResultWithTimeoutAndResultSetter() {
        Thread t = new Thread(){

            public void run() {
                Util.sleep(500L);
                System.out.println("-- setting promise to \"Bela\"");
                PromiseTest.this.p.setResult("Bela");
            }
        };
        t.start();
        long start = System.currentTimeMillis();
        Object result = this.p.getResult(100000L);
        long stop = System.currentTimeMillis();
        System.out.println("-- waited for " + (stop - start) + "ms, result is " + result);
        PromiseTest.assertNotNull(result);
        PromiseTest.assertEquals((Object)"Bela", result);
        PromiseTest.assertFalse((String)"promise was reset after getResult()", (boolean)this.p.hasResult());
    }

    static class Interrupter
    extends Thread {
        long wait_time = 2000L;
        Thread target = null;

        Interrupter(Thread target, long wait_time) {
            this.target = target;
            this.wait_time = wait_time;
        }

        public void run() {
            Util.sleep(this.wait_time);
            this.target.interrupt();
        }
    }

    static class ResultSetter
    extends Thread {
        long wait_time = 2000L;
        Promise target = null;

        ResultSetter(Promise target, long wait_time) {
            this.target = target;
            this.wait_time = wait_time;
        }

        public void run() {
            Util.sleep(this.wait_time);
            this.target.setResult(Boolean.TRUE);
        }
    }
}

