/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import org.jgroups.util.ThreadDecorator;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.ThreadManager;

public class DefaultThreadFactory
implements ThreadFactory,
ThreadManager {
    protected final ThreadGroup group;
    protected final String baseName;
    protected final boolean createDaemons;
    protected short counter = 0;
    protected final boolean use_numbering;
    protected boolean includeClusterName = false;
    protected boolean includeLocalAddress = false;
    protected String clusterName = null;
    protected String address = null;
    protected ThreadDecorator threadDecorator = null;

    public DefaultThreadFactory(ThreadGroup group, String baseName, boolean createDaemons) {
        this(group, baseName, createDaemons, false);
    }

    public DefaultThreadFactory(ThreadGroup group, String baseName, boolean createDaemons, boolean use_numbering) {
        this.group = group;
        this.baseName = baseName;
        this.createDaemons = createDaemons;
        this.use_numbering = use_numbering;
    }

    public void setPattern(String pattern) {
        if (pattern != null) {
            this.includeClusterName = pattern.contains("c");
            this.includeLocalAddress = pattern.contains("l");
        }
    }

    public void setIncludeClusterName(boolean includeClusterName) {
        this.includeClusterName = includeClusterName;
    }

    public void setClusterName(String channelName) {
        this.clusterName = channelName;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public ThreadDecorator getThreadDecorator() {
        return this.threadDecorator;
    }

    public void setThreadDecorator(ThreadDecorator threadDecorator) {
        this.threadDecorator = threadDecorator;
    }

    public Thread newThread(Runnable r, String name) {
        return this.newThread(this.group, r, name);
    }

    public Thread newThread(Runnable r) {
        return this.newThread(this.group, r, this.baseName);
    }

    public Thread newThread(ThreadGroup group, Runnable r, String name) {
        return this.newThread(group, r, name, null, null);
    }

    protected Thread newThread(ThreadGroup group, Runnable r, String name, String address, String cluster_name) {
        Thread retval = new Thread(group, r, name);
        retval.setDaemon(this.createDaemons);
        this.renameThread(retval, address, cluster_name);
        if (this.threadDecorator != null) {
            this.threadDecorator.threadCreated(retval);
        }
        return retval;
    }

    public void renameThread(String base_name, Thread thread) {
        this.renameThread(base_name, thread, this.address, this.clusterName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameThread(String base_name, Thread thread, String address, String cluster_name) {
        if (thread == null) {
            return;
        }
        StringBuilder sb = new StringBuilder(base_name != null ? base_name : thread.getName());
        if (this.use_numbering) {
            short id;
            DefaultThreadFactory defaultThreadFactory = this;
            synchronized (defaultThreadFactory) {
                id = this.counter = (short)(this.counter + 1);
            }
            sb.append("-" + id);
        }
        if (this.includeClusterName) {
            sb.append(',');
            if (cluster_name != null) {
                sb.append(cluster_name);
            } else {
                sb.append(this.clusterName);
            }
        }
        if (this.includeLocalAddress) {
            sb.append(',');
            if (address != null) {
                sb.append(address);
            } else {
                sb.append(this.address);
            }
        }
        if (this.use_numbering || this.includeClusterName || this.includeLocalAddress) {
            thread.setName(sb.toString());
        }
    }

    protected void renameThread(Thread thread, String address, String cluster_name) {
        this.renameThread(null, thread, address, cluster_name);
    }

    public void renameThread(Thread thread) {
        this.renameThread(null, thread);
    }
}

