/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.cfg.Configuration;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tool.hbm2x.Cfg2HbmTool;
import org.hibernate.tool.hbm2x.GenericExporter;
import org.hibernate.tool.hbm2x.HibernateMappingGlobalSettings;
import org.hibernate.tool.hbm2x.TemplateProducer;
import org.hibernate.tool.hbm2x.pojo.POJOClass;

public class HibernateMappingExporter
extends GenericExporter {
    protected HibernateMappingGlobalSettings globalSettings = new HibernateMappingGlobalSettings();

    protected void setupContext() {
        super.setupContext();
        this.getTemplateHelper().putInContext("hmgs", this.globalSettings);
    }

    public void setGlobalSettings(HibernateMappingGlobalSettings hgs) {
        this.globalSettings = hgs;
    }

    public void doStart() {
        this.exportGeneralSettings();
        super.doStart();
    }

    private void exportGeneralSettings() {
        Configuration cfg;
        Cfg2HbmTool c2h = this.getCfg2HbmTool();
        if (c2h.isImportData(cfg = this.getConfiguration()) && c2h.isNamedQueries(cfg) && c2h.isNamedSQLQueries(cfg) && c2h.isFilterDefinitions(cfg)) {
            TemplateProducer producer = new TemplateProducer(this.getTemplateHelper(), this.getArtifactCollector());
            producer.produce(new HashMap(), "hbm/generalhbm.hbm.ftl", new File(this.getOutputDirectory(), "GeneralHbmSettings.hbm.xml"), this.getTemplateName(), "General Settings");
        }
    }

    public HibernateMappingExporter(Configuration cfg, File outputdir) {
        super(cfg, outputdir);
        this.init();
    }

    protected void init() {
        this.setTemplateName("hbm/hibernate-mapping.hbm.ftl");
        this.setFilePattern("{package-name}/{class-name}.hbm.xml");
    }

    public HibernateMappingExporter() {
        this.init();
    }

    protected String getClassNameForFile(POJOClass element) {
        return StringHelper.unqualify((String)((PersistentClass)element.getDecoratedObject()).getEntityName());
    }

    protected String getPackageNameForFile(POJOClass element) {
        return StringHelper.qualifier((String)((PersistentClass)element.getDecoratedObject()).getClassName());
    }

    protected void exportComponent(Map additionalContext, POJOClass element) {
    }

    public String getName() {
        return "hbm2hbmxml";
    }
}

