/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import org.infinispan.io.ByteBuffer;
import org.infinispan.io.ExposedByteArrayOutputStream;
import org.infinispan.marshall.AbstractMarshaller;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.marshall.jboss.ExtendedRiverMarshaller;
import org.infinispan.marshall.jboss.ExtendedRiverUnmarshaller;
import org.infinispan.marshall.jboss.JBossMarshallerFactory;
import org.infinispan.marshall.jboss.RiverCloseListener;
import org.infinispan.marshall.jboss.SerializeWithExtFactory;
import org.infinispan.util.ReflectionUtil;
import org.infinispan.util.Util;
import org.infinispan.util.logging.BasicLogFactory;
import org.jboss.logging.BasicLogger;
import org.jboss.marshalling.ClassExternalizerFactory;
import org.jboss.marshalling.Creator;
import org.jboss.marshalling.ExceptionListener;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.TraceInformation;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.reflect.SunReflectiveCreator;

public abstract class AbstractJBossMarshaller
extends AbstractMarshaller
implements StreamingMarshaller {
    protected static final BasicLogger log = BasicLogFactory.getLog(AbstractJBossMarshaller.class);
    protected static final boolean trace = log.isTraceEnabled();
    protected static final JBossMarshallerFactory factory = new JBossMarshallerFactory();
    protected static final int DEF_INSTANCE_COUNT = 16;
    protected static final int DEF_CLASS_COUNT = 8;
    private static final int PER_THREAD_REUSABLE_INSTANCES = 6;
    private static final int RIVER_INTERNAL_BUFFER = 512;
    protected final MarshallingConfiguration baseCfg;
    private final ThreadLocal<PerThreadInstanceHolder> marshallerTL = new ThreadLocal<PerThreadInstanceHolder>(){

        @Override
        protected PerThreadInstanceHolder initialValue() {
            MarshallingConfiguration cfg = AbstractJBossMarshaller.this.baseCfg.clone();
            return new PerThreadInstanceHolder(cfg);
        }
    };

    public AbstractJBossMarshaller() {
        this.baseCfg = new MarshallingConfiguration();
        this.baseCfg.setExternalizerCreator((Creator)new SunReflectiveCreator());
        this.baseCfg.setExceptionListener((ExceptionListener)new DebuggingExceptionListener());
        this.baseCfg.setClassExternalizerFactory((ClassExternalizerFactory)new SerializeWithExtFactory());
        this.baseCfg.setInstanceCount(16);
        this.baseCfg.setClassCount(8);
        this.baseCfg.setVersion(3);
    }

    @Override
    public final void objectToObjectStream(Object obj, ObjectOutput out) throws IOException {
        out.writeObject(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final ByteBuffer objectToBuffer(Object o, int estimatedSize) throws IOException {
        ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream(estimatedSize);
        ObjectOutput marshaller = this.startObjectOutput(baos, false, estimatedSize);
        try {
            this.objectToObjectStream(o, marshaller);
        }
        finally {
            this.finishObjectOutput(marshaller);
        }
        return new ByteBuffer(baos.getRawBuffer(), 0, baos.size());
    }

    @Override
    public final ObjectOutput startObjectOutput(OutputStream os, boolean isReentrant, int estimatedSize) throws IOException {
        PerThreadInstanceHolder instanceHolder = this.marshallerTL.get();
        ExtendedRiverMarshaller marshaller = instanceHolder.getMarshaller(estimatedSize);
        marshaller.start(Marshalling.createByteOutput((OutputStream)os));
        return marshaller;
    }

    @Override
    public final ObjectOutput startObjectOutput(OutputStream os, boolean isReentrant) throws IOException {
        return this.startObjectOutput(os, isReentrant, 512);
    }

    @Override
    public final void finishObjectOutput(ObjectOutput oo) {
        try {
            if (trace) {
                log.trace((Object)"Stop marshaller");
            }
            ((Marshaller)oo).finish();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object objectFromByteBuffer(byte[] buf, int offset, int length) throws IOException, ClassNotFoundException {
        ByteArrayInputStream is = new ByteArrayInputStream(buf, offset, length);
        ObjectInput unmarshaller = this.startObjectInput(is, false);
        Object o = null;
        try {
            o = this.objectFromObjectStream(unmarshaller);
        }
        finally {
            this.finishObjectInput(unmarshaller);
        }
        return o;
    }

    @Override
    public final ObjectInput startObjectInput(InputStream is, boolean isReentrant) throws IOException {
        PerThreadInstanceHolder instanceHolder = this.marshallerTL.get();
        Unmarshaller unmarshaller = instanceHolder.getUnmarshaller();
        if (trace) {
            log.tracef("Start unmarshaller after retrieving marshaller from %s", (Object)(isReentrant ? "factory" : "thread local"));
        }
        unmarshaller.start(Marshalling.createByteInput((InputStream)is));
        return unmarshaller;
    }

    @Override
    public final Object objectFromObjectStream(ObjectInput in) throws IOException, ClassNotFoundException {
        return in.readObject();
    }

    @Override
    public final void finishObjectInput(ObjectInput oi) {
        try {
            if (trace) {
                log.trace((Object)"Stop unmarshaller");
            }
            if (oi != null) {
                ((Unmarshaller)oi).finish();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isMarshallable(Object o) throws Exception {
        Class<?> clazz = o.getClass();
        boolean containsMarshallable = this.marshallableTypeHints.isKnownMarshallable(clazz);
        if (containsMarshallable) {
            boolean marshallable = this.marshallableTypeHints.isMarshallable(clazz);
            if (trace) {
                log.tracef("Marshallable type '%s' known and is marshallable=%b", (Object)clazz.getName(), (Object)marshallable);
            }
            return marshallable;
        }
        if (this.isMarshallableCandidate(o)) {
            boolean isMarshallable = true;
            try {
                this.objectToBuffer(o);
            }
            catch (Exception e) {
                isMarshallable = false;
                throw e;
            }
            finally {
                this.marshallableTypeHints.markMarshallable(clazz, isMarshallable);
            }
            return isMarshallable;
        }
        return false;
    }

    @Override
    public void stop() {
        this.marshallableTypeHints.clear();
    }

    protected boolean isMarshallableCandidate(Object o) {
        return o instanceof Serializable;
    }

    private static final class PerThreadInstanceHolder
    implements RiverCloseListener {
        final MarshallingConfiguration configuration;
        final ExtendedRiverMarshaller[] reusableMarshaller = new ExtendedRiverMarshaller[6];
        int availableMarshallerIndex = 0;
        final ExtendedRiverUnmarshaller[] reusableUnMarshaller = new ExtendedRiverUnmarshaller[6];
        int availableUnMarshallerIndex = 0;

        PerThreadInstanceHolder(MarshallingConfiguration threadDedicatedConfiguration) {
            this.configuration = threadDedicatedConfiguration;
        }

        Unmarshaller getUnmarshaller() throws IOException {
            if (this.availableUnMarshallerIndex == 6) {
                this.configuration.setBufferSize(512);
                return factory.createUnmarshaller(this.configuration);
            }
            ExtendedRiverUnmarshaller unMarshaller = this.reusableUnMarshaller[this.availableUnMarshallerIndex];
            if (unMarshaller != null) {
                ++this.availableUnMarshallerIndex;
                return unMarshaller;
            }
            this.configuration.setBufferSize(512);
            unMarshaller = factory.createUnmarshaller(this.configuration);
            unMarshaller.setCloseListener(this);
            this.reusableUnMarshaller[this.availableUnMarshallerIndex] = unMarshaller;
            ++this.availableUnMarshallerIndex;
            return unMarshaller;
        }

        ExtendedRiverMarshaller getMarshaller(int estimatedSize) throws IOException {
            if (this.availableMarshallerIndex == 6) {
                this.configuration.setBufferSize(estimatedSize);
                return factory.createMarshaller(this.configuration);
            }
            ExtendedRiverMarshaller marshaller = this.reusableMarshaller[this.availableMarshallerIndex];
            if (marshaller != null) {
                ++this.availableMarshallerIndex;
                return marshaller;
            }
            this.configuration.setBufferSize(512);
            marshaller = factory.createMarshaller(this.configuration);
            marshaller.setCloseListener(this);
            this.reusableMarshaller[this.availableMarshallerIndex] = marshaller;
            ++this.availableMarshallerIndex;
            return marshaller;
        }

        @Override
        public void closeMarshaller() {
            --this.availableMarshallerIndex;
        }

        @Override
        public void closeUnmarshaller() {
            --this.availableUnMarshallerIndex;
        }
    }

    protected static final class DebuggingExceptionListener
    implements ExceptionListener {
        private static final URL[] EMPTY_URLS = new URL[0];

        protected DebuggingExceptionListener() {
        }

        public void handleMarshallingException(Throwable problem, Object subject) {
            if (log.isDebugEnabled()) {
                TraceInformation.addUserInformation((Throwable)problem, (Serializable)((Object)("toString = " + subject.toString())));
            }
        }

        public void handleUnmarshallingException(Throwable problem, Class<?> subjectClass) {
            if (log.isDebugEnabled()) {
                StringBuilder builder = new StringBuilder();
                ClassLoader cl = subjectClass.getClassLoader();
                builder.append("classloader hierarchy:");
                for (ClassLoader parent = cl; parent != null; parent = parent.getParent()) {
                    if (parent.equals(cl)) {
                        builder.append("\n\t\t-> type classloader = ").append(parent);
                    } else {
                        builder.append("\n\t\t-> parent classloader = ").append(parent);
                    }
                    URL[] urls = DebuggingExceptionListener.getClassLoaderURLs(parent);
                    if (urls == null) continue;
                    for (URL u : urls) {
                        builder.append("\n\t\t->...").append(u);
                    }
                }
                TraceInformation.addUserInformation((Throwable)problem, (Serializable)((Object)builder.toString()));
            }
        }

        public void handleUnmarshallingException(Throwable problem) {
        }

        private static URL[] getClassLoaderURLs(ClassLoader cl) {
            URL[] urls = EMPTY_URLS;
            try {
                Class<?> returnType = urls.getClass();
                Class<?>[] parameterTypes = ReflectionUtil.EMPTY_CLASS_ARRAY;
                Method getURLs = cl.getClass().getMethod("getURLs", parameterTypes);
                if (returnType.isAssignableFrom(getURLs.getReturnType())) {
                    Object[] args = Util.EMPTY_OBJECT_ARRAY;
                    urls = (URL[])getURLs.invoke((Object)cl, args);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return urls;
        }
    }
}

