/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionSynchronizationRegistry;
import net.jcip.annotations.GuardedBy;
import org.infinispan.CacheException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.AbstractCacheTransaction;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.RemoteTransaction;
import org.infinispan.transaction.StaleTransactionCleanupService;
import org.infinispan.transaction.TransactionCoordinator;
import org.infinispan.transaction.synchronization.SyncLocalTransaction;
import org.infinispan.transaction.synchronization.SynchronizationAdapter;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.ConcurrentMapFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Listener(sync=false)
public class TransactionTable {
    public static final int CACHE_STOPPED_VIEW_ID = -1;
    private static final Log log = LogFactory.getLog(TransactionTable.class);
    private ConcurrentMap<Transaction, LocalTransaction> localTransactions;
    private ConcurrentMap<GlobalTransaction, RemoteTransaction> remoteTransactions;
    private final StaleTransactionCleanupService cleanupService = new StaleTransactionCleanupService(this);
    protected Configuration configuration;
    protected InvocationContextContainer icc;
    protected TransactionCoordinator txCoordinator;
    protected TransactionFactory txFactory;
    protected RpcManager rpcManager;
    protected CommandsFactory commandsFactory;
    private InterceptorChain invoker;
    private CacheNotifier notifier;
    private EmbeddedCacheManager cm;
    private TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    protected ClusteringDependentLogic clusteringLogic;
    protected boolean clustered = false;
    private Lock minViewRecalculationLock;
    private volatile int minTxViewId = -1;
    private volatile int currentViewId = -1;

    @Inject
    public void initialize(RpcManager rpcManager, Configuration configuration, InvocationContextContainer icc, InterceptorChain invoker, CacheNotifier notifier, TransactionFactory gtf, EmbeddedCacheManager cm, TransactionCoordinator txCoordinator, TransactionSynchronizationRegistry transactionSynchronizationRegistry, CommandsFactory commandsFactory, ClusteringDependentLogic clusteringDependentLogic) {
        this.rpcManager = rpcManager;
        this.configuration = configuration;
        this.icc = icc;
        this.invoker = invoker;
        this.notifier = notifier;
        this.txFactory = gtf;
        this.cm = cm;
        this.txCoordinator = txCoordinator;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        this.commandsFactory = commandsFactory;
        this.clusteringLogic = clusteringDependentLogic;
    }

    @Start(priority=9)
    private void start() {
        int concurrencyLevel = this.configuration.getConcurrencyLevel();
        this.localTransactions = ConcurrentMapFactory.makeConcurrentMap(concurrencyLevel, 0.75f, concurrencyLevel);
        if (this.configuration.getCacheMode().isClustered()) {
            this.minViewRecalculationLock = new ReentrantLock();
            this.remoteTransactions = ConcurrentMapFactory.makeConcurrentMap(concurrencyLevel, 0.75f, concurrencyLevel);
            this.cleanupService.start(this.configuration, this.rpcManager, this.invoker);
            this.cm.addListener(this.cleanupService);
            this.cm.addListener(this);
            this.notifier.addListener(this.cleanupService);
            this.currentViewId = this.minTxViewId = this.rpcManager.getTransport().getViewId();
            log.debugf("Min view id set to %s", this.minTxViewId);
            this.clustered = true;
        }
    }

    @Stop
    private void stop() {
        if (this.clustered) {
            this.notifier.removeListener(this.cleanupService);
            this.cm.removeListener(this.cleanupService);
            this.cleanupService.stop();
            this.cm.removeListener(this);
            this.currentViewId = -1;
        }
        this.shutDownGracefully();
    }

    public Set<Object> getLockedKeysForRemoteTransaction(GlobalTransaction gtx) {
        RemoteTransaction transaction = (RemoteTransaction)this.remoteTransactions.get(gtx);
        if (transaction == null) {
            return Collections.emptySet();
        }
        return transaction.getLockedKeys();
    }

    public void remoteTransactionPrepared(GlobalTransaction gtx) {
    }

    public void localTransactionPrepared(LocalTransaction localTransaction) {
    }

    public void enlist(Transaction transaction, LocalTransaction localTransaction) {
        if (!localTransaction.isEnlisted()) {
            SynchronizationAdapter sync = new SynchronizationAdapter(localTransaction, this.txCoordinator, this.commandsFactory, this.rpcManager, this, this.clusteringLogic, this.configuration);
            if (this.transactionSynchronizationRegistry != null) {
                try {
                    this.transactionSynchronizationRegistry.registerInterposedSynchronization((Synchronization)sync);
                }
                catch (Exception e) {
                    log.failedSynchronizationRegistration(e);
                    throw new CacheException(e);
                }
            }
            try {
                transaction.registerSynchronization((Synchronization)sync);
            }
            catch (Exception e) {
                log.failedSynchronizationRegistration(e);
                throw new CacheException(e);
            }
            ((SyncLocalTransaction)localTransaction).setEnlisted(true);
        }
    }

    public void failureCompletingTransaction(Transaction tx) {
        LocalTransaction localTransaction = (LocalTransaction)this.localTransactions.get(tx);
        if (localTransaction != null) {
            this.removeLocalTransaction(localTransaction);
        }
    }

    public boolean containsLocalTx(Transaction tx) {
        return tx != null && this.localTransactions.containsKey(tx);
    }

    public int getMinViewId() {
        return this.minTxViewId;
    }

    protected void updateStateOnNodesLeaving(Collection<Address> leavers) {
        HashSet<GlobalTransaction> toKill = new HashSet<GlobalTransaction>();
        for (GlobalTransaction gt : this.remoteTransactions.keySet()) {
            if (!leavers.contains(gt.getAddress())) continue;
            toKill.add(gt);
        }
        if (toKill.isEmpty()) {
            log.tracef("No global transactions pertain to originator(s) %s who have left the cluster.", leavers);
        } else {
            log.tracef("%s global transactions pertain to leavers list %s and need to be killed", toKill.size(), leavers);
        }
        for (GlobalTransaction gtx : toKill) {
            log.tracef("Killing remote transaction originating on leaver %s", gtx);
            RollbackCommand rc = new RollbackCommand(this.configuration.getName(), gtx);
            rc.init(this.invoker, this.icc, this);
            try {
                rc.perform(null);
                log.tracef("Rollback of transaction %s complete.", gtx);
            }
            catch (Throwable e) {
                log.unableToRollbackGlobalTx(gtx, e);
            }
        }
        log.trace("Completed cleaning transactions originating on leavers");
    }

    public RemoteTransaction getRemoteTransaction(GlobalTransaction txId) {
        return (RemoteTransaction)this.remoteTransactions.get(txId);
    }

    public void remoteTransactionRollback(GlobalTransaction gtx) {
        RemoteTransaction remove = this.removeRemoteTransaction(gtx);
        log.tracef("Removed local transaction %s? %b", gtx, remove);
    }

    public RemoteTransaction createRemoteTransaction(GlobalTransaction globalTx, WriteCommand[] modifications) {
        RemoteTransaction remoteTransaction = modifications == null ? this.txFactory.newRemoteTransaction(globalTx, this.currentViewId) : this.txFactory.newRemoteTransaction(modifications, globalTx, this.currentViewId);
        this.registerRemoteTransaction(globalTx, remoteTransaction);
        return remoteTransaction;
    }

    private void registerRemoteTransaction(GlobalTransaction gtx, RemoteTransaction rtx) {
        RemoteTransaction transaction = this.remoteTransactions.put(gtx, rtx);
        if (transaction != null) {
            log.remoteTxAlreadyRegistered();
            throw new IllegalStateException("A remote transaction with the given id was already registered!!!");
        }
        log.tracef("Created and registered remote transaction %s", rtx);
    }

    public LocalTransaction getOrCreateLocalTransaction(Transaction transaction, TxInvocationContext ctx) {
        LocalTransaction current = (LocalTransaction)this.localTransactions.get(transaction);
        if (current == null) {
            Address localAddress = this.rpcManager != null ? this.rpcManager.getTransport().getAddress() : null;
            GlobalTransaction tx = this.txFactory.newGlobalTransaction(localAddress, false);
            current = this.txFactory.newLocalTransaction(transaction, tx, ctx.isImplicitTransaction(), this.currentViewId);
            log.tracef("Created a new local transaction: %s", current);
            this.localTransactions.put(transaction, current);
            this.notifier.notifyTransactionRegistered(tx, ctx);
        }
        return current;
    }

    public boolean removeLocalTransaction(LocalTransaction localTransaction) {
        return localTransaction != null && this.removeLocalTransactionInternal(localTransaction.getTransaction()) != null;
    }

    public LocalTransaction removeLocalTransaction(Transaction tx) {
        return this.removeLocalTransactionInternal(tx);
    }

    protected final LocalTransaction removeLocalTransactionInternal(Transaction tx) {
        LocalTransaction removed = (LocalTransaction)this.localTransactions.remove(tx);
        this.releaseResources(removed);
        return removed;
    }

    private void releaseResources(CacheTransaction cacheTransaction) {
        if (cacheTransaction != null) {
            if (this.clustered) {
                this.recalculateMinViewIdIfNeeded(cacheTransaction);
            }
            log.tracef("Removed %s from transaction table.", cacheTransaction);
            cacheTransaction.notifyOnTransactionFinished();
        }
    }

    public void remoteTransactionCommitted(GlobalTransaction gtx) {
        if (this.configuration.isSecondPhaseAsync()) {
            this.removeRemoteTransaction(gtx);
        }
    }

    public final RemoteTransaction removeRemoteTransaction(GlobalTransaction txId) {
        RemoteTransaction removed = (RemoteTransaction)this.remoteTransactions.remove(txId);
        this.releaseResources(removed);
        return removed;
    }

    public int getRemoteTxCount() {
        return this.remoteTransactions.size();
    }

    public int getLocalTxCount() {
        return this.localTransactions.size();
    }

    public LocalTransaction getLocalTransaction(Transaction tx) {
        return (LocalTransaction)this.localTransactions.get(tx);
    }

    public boolean containRemoteTx(GlobalTransaction globalTransaction) {
        return this.remoteTransactions.containsKey(globalTransaction);
    }

    public Collection<RemoteTransaction> getRemoteTransactions() {
        return this.remoteTransactions.values();
    }

    protected final LocalTransaction getLocalTx(Transaction tx) {
        return (LocalTransaction)this.localTransactions.get(tx);
    }

    public final Collection<LocalTransaction> getLocalTransactions() {
        return this.localTransactions.values();
    }

    protected final void recalculateMinViewIdIfNeeded(CacheTransaction removedTransaction) {
        if (removedTransaction == null) {
            throw new IllegalArgumentException("Transaction cannot be null!");
        }
        if (this.currentViewId != -1) {
            int removedTransactionViewId = removedTransaction.getViewId();
            if (removedTransactionViewId < this.minTxViewId) {
                log.tracef("A transaction has a view ID (%s) that is smaller than the smallest transaction view ID (%s) this node knows about!  This can happen if a concurrent thread recalculates the minimum view ID after the current transaction has been removed from the transaction table.", removedTransactionViewId, this.minTxViewId);
            } else if (removedTransactionViewId == this.minTxViewId && removedTransactionViewId < this.currentViewId) {
                this.calculateMinViewId(removedTransactionViewId);
            }
        }
    }

    @ViewChanged
    public void recalculateMinViewIdOnTopologyChange(ViewChangedEvent vce) {
        if (this.clustered) {
            log.debugf("View changed, recalculating minViewId", new Object[0]);
            this.currentViewId = vce.getViewId();
            this.calculateMinViewId(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="minViewRecalculationLock")
    private void calculateMinViewId(int idOfRemovedTransaction) {
        this.minViewRecalculationLock.lock();
        try {
            if (idOfRemovedTransaction == -1 || idOfRemovedTransaction == this.minTxViewId && idOfRemovedTransaction < this.currentViewId) {
                int viewId;
                int minViewIdFound = this.currentViewId;
                for (AbstractCacheTransaction ct : this.localTransactions.values()) {
                    viewId = ct.getViewId();
                    if (viewId >= minViewIdFound) continue;
                    minViewIdFound = viewId;
                }
                for (AbstractCacheTransaction ct : this.remoteTransactions.values()) {
                    viewId = ct.getViewId();
                    if (viewId >= minViewIdFound) continue;
                    minViewIdFound = viewId;
                }
                if (minViewIdFound > this.minTxViewId) {
                    log.tracef("Changing minimum view ID from %s to %s", this.minTxViewId, minViewIdFound);
                    this.minTxViewId = minViewIdFound;
                } else {
                    log.tracef("Minimum view ID still is %s; nothing to change", minViewIdFound);
                }
            }
        }
        finally {
            this.minViewRecalculationLock.unlock();
        }
    }

    private boolean areTxsOnGoing() {
        return !this.localTransactions.isEmpty() || this.remoteTransactions != null && !this.remoteTransactions.isEmpty();
    }

    private void shutDownGracefully() {
        if (log.isDebugEnabled()) {
            log.debugf("Wait for on-going transactions to finish for %s.", Util.prettyPrintTime(this.configuration.getCacheStopTimeout(), TimeUnit.MILLISECONDS));
        }
        long failTime = Util.currentMillisFromNanotime() + (long)this.configuration.getCacheStopTimeout();
        boolean txsOnGoing = this.areTxsOnGoing();
        while (txsOnGoing && Util.currentMillisFromNanotime() < failTime) {
            try {
                Thread.sleep(30L);
                txsOnGoing = this.areTxsOnGoing();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (this.clustered) {
                    log.debugf("Interrupted waiting for on-going transactions to finish. %s local transactions and %s remote transactions", this.localTransactions.size(), this.remoteTransactions.size());
                    continue;
                }
                log.debugf("Interrupted waiting for %s on-going transactions to finish.", this.localTransactions.size());
            }
        }
        if (txsOnGoing) {
            log.unfinishedTransactionsRemain(this.localTransactions == null ? 0 : this.localTransactions.size(), this.remoteTransactions == null ? 0 : this.remoteTransactions.size());
        } else {
            log.debug("All transactions terminated");
        }
    }
}

