/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DldGlobalTransaction
extends GlobalTransaction {
    private static final Log log = LogFactory.getLog(DldGlobalTransaction.class);
    private static final boolean trace = log.isTraceEnabled();
    protected volatile long coinToss;
    protected volatile transient Object localLockIntention;
    protected volatile Collection<Object> remoteLockIntention = Collections.emptySet();
    protected volatile Set<Object> locksAtOrigin = Collections.emptySet();

    public DldGlobalTransaction() {
    }

    public DldGlobalTransaction(Address addr, boolean remote) {
        super(addr, remote);
    }

    public void setCoinToss(long coinToss) {
        this.coinToss = coinToss;
    }

    public long getCoinToss() {
        return this.coinToss;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DldGlobalTransaction)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DldGlobalTransaction that = (DldGlobalTransaction)o;
        return this.coinToss == that.coinToss;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.coinToss ^ this.coinToss >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return "DldGlobalTransaction{coinToss=" + this.coinToss + ", lockIntention=" + this.localLockIntention + ", affectedKeys=" + this.remoteLockIntention + ", locksAtOrigin=" + this.locksAtOrigin + "} " + super.toString();
    }

    public Object getLockIntention() {
        return this.localLockIntention;
    }

    public void setLockIntention(Object lockIntention) {
        if (trace) {
            log.tracef("Setting local lock intention to %s", lockIntention);
        }
        this.localLockIntention = lockIntention;
    }

    public boolean wouldLose(DldGlobalTransaction other) {
        return this.coinToss < other.coinToss;
    }

    public void setRemoteLockIntention(Collection<Object> remoteLockIntention) {
        if (trace) {
            log.tracef("Setting the remote lock intention: %s", remoteLockIntention);
        }
        this.remoteLockIntention = remoteLockIntention;
    }

    public Collection<Object> getRemoteLockIntention() {
        return this.remoteLockIntention;
    }

    public boolean hasLockAtOrigin(Collection<Object> remoteLockIntention) {
        log.tracef("Our(%s) locks at origin are: %s. Others remote lock intention is: %s", this, this.locksAtOrigin, remoteLockIntention);
        for (Object key : remoteLockIntention) {
            if (!this.locksAtOrigin.contains(key)) continue;
            return true;
        }
        return false;
    }

    public void setLocksHeldAtOrigin(Set<Object> locksAtOrigin) {
        if (trace) {
            log.tracef("Setting locks at origin for (%s) to %s", this, locksAtOrigin);
        }
        this.locksAtOrigin = locksAtOrigin;
    }

    public Set<Object> getLocksHeldAtOrigin() {
        return this.locksAtOrigin;
    }

    public static class Externalizer
    extends GlobalTransaction.AbstractGlobalTxExternalizer<DldGlobalTransaction> {
        @Override
        protected DldGlobalTransaction createGlobalTransaction() {
            return (DldGlobalTransaction)TransactionFactory.TxFactoryEnum.DLD_NORECOVERY_XA.newGlobalTransaction();
        }

        @Override
        public void writeObject(ObjectOutput output, DldGlobalTransaction ddGt) throws IOException {
            super.writeObject(output, ddGt);
            output.writeLong(ddGt.getCoinToss());
            if (ddGt.locksAtOrigin.isEmpty()) {
                output.writeObject(null);
            } else {
                output.writeObject(ddGt.locksAtOrigin);
            }
        }

        @Override
        public DldGlobalTransaction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            DldGlobalTransaction ddGt = (DldGlobalTransaction)super.readObject(input);
            ddGt.setCoinToss(input.readLong());
            Object locksAtOriginObj = input.readObject();
            if (locksAtOriginObj == null) {
                ddGt.setLocksHeldAtOrigin(Collections.<Object>emptySet());
            } else {
                ddGt.setLocksHeldAtOrigin((Set)locksAtOriginObj);
            }
            return ddGt;
        }

        @Override
        public Integer getId() {
            return 43;
        }

        @Override
        public Set<Class<? extends DldGlobalTransaction>> getTypeClasses() {
            return Util.asSet(DldGlobalTransaction.class);
        }
    }
}

