/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.api.query;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.SortOrder;
import org.picketlink.idm.api.query.UnsupportedQueryCriterium;
import org.picketlink.idm.api.query.UserQuery;
import org.picketlink.idm.api.query.UserQueryBuilder;
import org.picketlink.idm.impl.api.IdentitySearchCriteriaImpl;
import org.picketlink.idm.impl.api.query.AbstractQueryBuilder;
import org.picketlink.idm.impl.api.query.UserQueryImpl;

public class UserQueryBuilderImpl
extends AbstractQueryBuilder
implements UserQueryBuilder {
    private String userId;
    private Set<Group> groupsAssociatedWith = new HashSet<Group>();
    private Set<Group> groupsConnectedWithRole = new HashSet<Group>();
    private Set<Group> groupsRelated = new HashSet<Group>();

    @Override
    public UserQuery createQuery() {
        return new UserQueryImpl(this.searchCriteria, this.userId, this.groupsAssociatedWith, this.groupsConnectedWithRole, this.groupsRelated);
    }

    @Override
    public UserQueryBuilder reset() {
        this.searchCriteria = new IdentitySearchCriteriaImpl();
        this.userId = null;
        this.groupsAssociatedWith = new HashSet<Group>();
        this.groupsConnectedWithRole = new HashSet<Group>();
        this.groupsRelated = new HashSet<Group>();
        return this;
    }

    @Override
    public UserQueryBuilder withUserId(String id) {
        this.checkNotNullArgument(id, "User id");
        this.userId = id;
        return this;
    }

    @Override
    public UserQueryBuilder addAssociatedGroup(Group group) {
        this.checkNotNullArgument(group, "Group");
        this.groupsAssociatedWith.add(group);
        return this;
    }

    @Override
    public UserQueryBuilder addAssociatedGroup(String id) {
        this.checkNotNullArgument(id, "Group id");
        this.groupsAssociatedWith.add(this.createGroupFromId(id));
        return this;
    }

    @Override
    public UserQueryBuilder addAssociatedGroups(Collection<Group> groups) {
        this.checkNotNullArgument(groups, "Groups");
        this.groupsAssociatedWith.addAll(groups);
        return this;
    }

    @Override
    public UserQueryBuilder addAssociatedGroupsKeys(Collection<String> groups) {
        this.checkNotNullArgument(groups, "Groups");
        for (String groupId : groups) {
            this.groupsAssociatedWith.add(this.createGroupFromId(groupId));
        }
        return this;
    }

    @Override
    public UserQueryBuilder addGroupConnectedWithRole(Group group) {
        this.checkNotNullArgument(group, "Group");
        this.groupsConnectedWithRole.add(group);
        return this;
    }

    @Override
    public UserQueryBuilder addGroupConnectedWithRole(String id) {
        this.checkNotNullArgument(id, "Group id");
        this.groupsConnectedWithRole.add(this.createGroupFromId(id));
        return this;
    }

    @Override
    public UserQueryBuilder addGroupsConnectedWithRole(Collection<Group> groups) {
        this.checkNotNullArgument(groups, "Groups");
        this.groupsConnectedWithRole.addAll(groups);
        return this;
    }

    @Override
    public UserQueryBuilder addGroupsKeysConnectedWithRole(Collection<String> groups) {
        this.checkNotNullArgument(groups, "Groups");
        for (String groupId : groups) {
            this.groupsConnectedWithRole.add(this.createGroupFromId(groupId));
        }
        return this;
    }

    @Override
    public UserQueryBuilder addRelatedGroup(Group group) {
        this.checkNotNullArgument(group, "Group");
        this.groupsRelated.add(group);
        return this;
    }

    @Override
    public UserQueryBuilder addRelatedGroup(String id) {
        this.checkNotNullArgument(id, "Group id");
        this.groupsRelated.add(this.createGroupFromId(id));
        return this;
    }

    @Override
    public UserQueryBuilder addRelatedGroups(Collection<Group> group) {
        this.checkNotNullArgument(group, "Group");
        this.groupsRelated.addAll(group);
        return this;
    }

    @Override
    public UserQueryBuilder addRelatedGroupsKeys(Collection<String> ids) {
        this.checkNotNullArgument(ids, "Groups ids");
        for (String id : ids) {
            this.groupsRelated.add(this.createGroupFromId(id));
        }
        return this;
    }

    @Override
    public UserQueryBuilder sort(SortOrder order) throws UnsupportedQueryCriterium {
        return (UserQueryBuilder)super.sort(order);
    }

    @Override
    public UserQueryBuilder sortAttributeName(String name) throws UnsupportedQueryCriterium {
        return (UserQueryBuilder)super.sortAttributeName(name);
    }

    @Override
    public UserQueryBuilder page(int firstResult, int maxResults) throws UnsupportedQueryCriterium {
        return (UserQueryBuilder)super.page(firstResult, maxResults);
    }

    @Override
    public UserQueryBuilder attributeValuesFilter(String attributeName, String[] attributeValue) throws UnsupportedQueryCriterium {
        return (UserQueryBuilder)super.attributeValuesFilter(attributeName, attributeValue);
    }

    @Override
    public UserQueryBuilder idFilter(String idFilter) throws UnsupportedQueryCriterium {
        return (UserQueryBuilder)super.idFilter(idFilter);
    }
}

