/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.BoundedList;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

@MBean(description="Failure detection based on simple heartbeat protocol")
public class FD_ALL
extends Protocol {
    @Property(description="Interval at which a HEARTBEAT is sent to the cluster")
    long interval = 3000L;
    @Property(description="Timeout after which a node P is suspected if neither a heartbeat nor data were received from P")
    long timeout = 10000L;
    @Property(description="Interval at which the HEARTBEAT timeouts are checked")
    long timeout_check_interval = 2000L;
    @Property(description="Treat messages received from members as heartbeats. Note that this means we're updating a value in a hashmap every time a message is passing up the stack through FD_ALL, which is costly. Default is false")
    boolean msg_counts_as_heartbeat = false;
    @ManagedAttribute(description="Number of heartbeats sent")
    protected int num_heartbeats_sent;
    @ManagedAttribute(description="Number of heartbeats received")
    protected int num_heartbeats_received = 0;
    @ManagedAttribute(description="Number of suspected events received")
    protected int num_suspect_events = 0;
    private final Map<Address, Long> timestamps = Util.createConcurrentMap();
    private Address local_addr = null;
    private final List<Address> members = new ArrayList<Address>();
    protected final Set<Address> suspected_mbrs = new HashSet<Address>();
    private TimeScheduler timer = null;
    private Future<?> heartbeat_sender_future = null;
    private Future<?> timeout_checker_future = null;
    private final BoundedList<Tuple<Address, Long>> suspect_history = new BoundedList(20);
    private final Lock lock = new ReentrantLock();

    @ManagedAttribute(description="Member address")
    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    @ManagedAttribute(description="Lists members of a cluster")
    public String getMembers() {
        return this.members.toString();
    }

    @ManagedAttribute(description="Currently suspected members")
    public String getSuspectedMembers() {
        return this.suspected_mbrs.toString();
    }

    public int getHeartbeatsSent() {
        return this.num_heartbeats_sent;
    }

    public int getHeartbeatsReceived() {
        return this.num_heartbeats_received;
    }

    public int getSuspectEventsSent() {
        return this.num_suspect_events;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeoutCheckInterval() {
        return this.timeout_check_interval;
    }

    public void setTimeoutCheckInterval(long timeout_check_interval) {
        this.timeout_check_interval = timeout_check_interval;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute(description="Are heartbeat tasks running")
    public boolean isRunning() {
        this.lock.lock();
        try {
            boolean bl = this.isTimeoutCheckerRunning() && this.isHeartbeatSenderRunning();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @ManagedOperation(description="Prints suspect history")
    public String printSuspectHistory() {
        StringBuilder sb = new StringBuilder();
        for (Tuple tuple : this.suspect_history) {
            sb.append(new Date((Long)tuple.getVal2())).append(": ").append(tuple.getVal1()).append("\n");
        }
        return sb.toString();
    }

    @ManagedOperation(description="Prints timestamps")
    public String printTimestamps() {
        return this._printTimestamps();
    }

    @ManagedOperation(description="Stops checking for crashed members")
    public void stopFailureDetection() {
        this.stopTimeoutChecker();
    }

    @ManagedOperation(description="Resumes checking for crashed members")
    public void startFailureDetection() {
        this.startTimeoutChecker();
    }

    @Override
    public void resetStats() {
        this.num_suspect_events = 0;
        this.num_heartbeats_received = 0;
        this.num_heartbeats_sent = 0;
        this.suspect_history.clear();
    }

    @Override
    public void init() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer not set");
        }
    }

    @Override
    public void stop() {
        this.stopHeartbeatSender();
        this.stopTimeoutChecker();
        this.suspected_mbrs.clear();
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Address sender = msg.getSrc();
                Header hdr = msg.getHeader(this.id);
                if (hdr != null) {
                    this.update(sender);
                    ++this.num_heartbeats_received;
                    return null;
                }
                if (!this.msg_counts_as_heartbeat) break;
                this.update(sender);
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.down_prot.down(evt);
                View v = (View)evt.getArg();
                this.handleViewChange(v);
                return null;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 51: {
                Address member = (Address)evt.getArg();
                if (member == null) break;
                FD_ALL fD_ALL = this;
                synchronized (fD_ALL) {
                    this.suspected_mbrs.remove(member);
                }
                this.update(member);
            }
        }
        return this.down_prot.down(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTimeoutChecker() {
        this.lock.lock();
        try {
            if (!this.isTimeoutCheckerRunning()) {
                this.timeout_checker_future = this.timer.scheduleWithFixedDelay(new TimeoutChecker(), this.timeout_check_interval, this.timeout_check_interval, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopTimeoutChecker() {
        this.lock.lock();
        try {
            if (this.timeout_checker_future != null) {
                this.timeout_checker_future.cancel(true);
                this.timeout_checker_future = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startHeartbeatSender() {
        this.lock.lock();
        try {
            if (!this.isHeartbeatSenderRunning()) {
                this.heartbeat_sender_future = this.timer.scheduleWithFixedDelay(new HeartbeatSender(), this.interval, this.interval, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopHeartbeatSender() {
        this.lock.lock();
        try {
            if (this.heartbeat_sender_future != null) {
                this.heartbeat_sender_future.cancel(true);
                this.heartbeat_sender_future = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isTimeoutCheckerRunning() {
        return this.timeout_checker_future != null && !this.timeout_checker_future.isDone();
    }

    private boolean isHeartbeatSenderRunning() {
        return this.heartbeat_sender_future != null && !this.heartbeat_sender_future.isDone();
    }

    private void update(Address sender) {
        if (sender != null && !sender.equals(this.local_addr)) {
            this.timestamps.put(sender, System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleViewChange(View v) {
        List<Address> mbrs = v.getMembers();
        FD_ALL fD_ALL = this;
        synchronized (fD_ALL) {
            this.members.clear();
            this.members.addAll(mbrs);
            this.suspected_mbrs.retainAll(mbrs);
            this.timestamps.keySet().retainAll(mbrs);
        }
        for (Address member : mbrs) {
            this.update(member);
        }
        if (mbrs.size() > 1) {
            this.startHeartbeatSender();
            this.startTimeoutChecker();
        } else {
            this.stopHeartbeatSender();
            this.stopTimeoutChecker();
        }
    }

    private String _printTimestamps() {
        StringBuilder sb = new StringBuilder();
        long current_time = System.currentTimeMillis();
        for (Map.Entry<Address, Long> entry : this.timestamps.entrySet()) {
            sb.append(entry.getKey()).append(": ");
            sb.append(current_time - entry.getValue()).append(" ms old\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void suspect(List<Address> suspects) {
        Address first;
        if (suspects == null) {
            return;
        }
        this.num_suspect_events += suspects.size();
        ArrayList<Address> eligible_mbrs = new ArrayList<Address>();
        FD_ALL fD_ALL = this;
        synchronized (fD_ALL) {
            for (Address suspect : suspects) {
                this.suspect_history.add(new Tuple<Address, Long>(suspect, System.currentTimeMillis()));
                this.suspected_mbrs.add(suspect);
            }
            eligible_mbrs.addAll(this.members);
            eligible_mbrs.removeAll(this.suspected_mbrs);
        }
        if (this.local_addr != null && !eligible_mbrs.isEmpty() && this.local_addr.equals(first = (Address)eligible_mbrs.get(0))) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("suspecting " + this.suspected_mbrs);
            }
            for (Address suspect : suspects) {
                this.up_prot.up(new Event(9, suspect));
                this.down_prot.down(new Event(9, suspect));
            }
        }
    }

    class TimeoutChecker
    implements Runnable {
        TimeoutChecker() {
        }

        @Override
        public void run() {
            LinkedList<Address> suspects = new LinkedList<Address>();
            long current_time = System.currentTimeMillis();
            Iterator it = FD_ALL.this.timestamps.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Address key = (Address)entry.getKey();
                Long val = (Long)entry.getValue();
                if (val == null) {
                    it.remove();
                    continue;
                }
                long diff = current_time - val;
                if (diff <= FD_ALL.this.timeout) continue;
                if (FD_ALL.this.log.isDebugEnabled()) {
                    FD_ALL.this.log.debug("haven't received a heartbeat from " + key + " for " + diff + " ms, adding it to suspect list");
                }
                suspects.add(key);
            }
            if (!suspects.isEmpty()) {
                FD_ALL.this.suspect(suspects);
            }
        }
    }

    class HeartbeatSender
    implements Runnable {
        HeartbeatSender() {
        }

        @Override
        public void run() {
            Message heartbeat = new Message();
            heartbeat.setFlag(Message.OOB);
            heartbeat.putHeader(FD_ALL.this.id, new HeartbeatHeader());
            FD_ALL.this.down_prot.down(new Event(1, heartbeat));
            ++FD_ALL.this.num_heartbeats_sent;
        }
    }

    public static class HeartbeatHeader
    extends Header {
        @Override
        public String toString() {
            return "heartbeat";
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
        }
    }
}

