/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.api.session.managers;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.picketlink.idm.api.Attribute;
import org.picketlink.idm.api.AttributeDescription;
import org.picketlink.idm.api.AttributesManager;
import org.picketlink.idm.api.Credential;
import org.picketlink.idm.api.CredentialType;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.User;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.api.PasswordCredential;
import org.picketlink.idm.impl.api.SimpleAttribute;
import org.picketlink.idm.impl.api.SimpleCredentialType;
import org.picketlink.idm.impl.api.attribute.IdentityObjectAttributeMetaDataImpl;
import org.picketlink.idm.impl.api.session.IdentitySessionImpl;
import org.picketlink.idm.impl.api.session.managers.AbstractManager;
import org.picketlink.idm.spi.configuration.metadata.IdentityObjectAttributeMetaData;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectAttribute;
import org.picketlink.idm.spi.model.IdentityObjectCredential;

public class AttributesManagerImpl
extends AbstractManager
implements AttributesManager,
Serializable {
    private static Logger log = Logger.getLogger(AttributesManagerImpl.class.getName());
    private static final long serialVersionUID = 1285532201632609092L;

    public AttributesManagerImpl(IdentitySessionImpl session) {
        super(session);
    }

    @Override
    public AttributeDescription getAttributeDescription(IdentityType identityType, String name) {
        this.checkNotNullArgument(identityType, "IdentityType");
        this.checkNotNullArgument(name, "Attribute name");
        Map<String, IdentityObjectAttributeMetaData> mdMap = this.getRepository().getAttributesMetaData(this.getInvocationContext(), this.createIdentityObject(identityType).getIdentityType());
        if (mdMap != null && mdMap.containsKey(name)) {
            IdentityObjectAttributeMetaData attributeMD = mdMap.get(name);
            if (attributeMD instanceof AttributeDescription) {
                return (AttributeDescription)((Object)attributeMD);
            }
            return new IdentityObjectAttributeMetaDataImpl(attributeMD);
        }
        return null;
    }

    @Override
    public AttributeDescription getAttributeDescription(String id, String attributeName) {
        this.checkNotNullArgument(id, "IdentityType Id");
        this.checkNotNullArgument(attributeName, "Attribute name");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        return this.getAttributeDescription(identityType, attributeName);
    }

    @Override
    public Map<String, AttributeDescription> getSupportedAttributesDescriptions(IdentityType identityType) {
        this.checkNotNullArgument(identityType, "IdentityType");
        Map<String, IdentityObjectAttributeMetaData> mdMap = this.getRepository().getAttributesMetaData(this.getInvocationContext(), this.createIdentityObject(identityType).getIdentityType());
        HashMap<String, AttributeDescription> descriptionMap = new HashMap<String, AttributeDescription>();
        if (mdMap != null) {
            for (IdentityObjectAttributeMetaData attributeMD : mdMap.values()) {
                if (attributeMD instanceof AttributeDescription) {
                    descriptionMap.put(attributeMD.getName(), (AttributeDescription)((Object)attributeMD));
                    continue;
                }
                descriptionMap.put(attributeMD.getName(), new IdentityObjectAttributeMetaDataImpl(attributeMD));
            }
        }
        return descriptionMap;
    }

    @Override
    public Map<String, AttributeDescription> getSupportedAttributesDescriptions(String id) {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        return this.getSupportedAttributesDescriptions(identityType);
    }

    @Override
    public Set<String> getSupportedAttributeNames(IdentityType identityType) throws IdentityException {
        try {
            this.checkNotNullArgument(identityType, "IdentityType");
            return this.getRepository().getSupportedAttributeNames(this.getInvocationContext(), this.createIdentityObject(identityType).getIdentityType());
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    @Override
    public Set<String> getSupportedAttributeNames(String id) throws IdentityException {
        try {
            this.checkNotNullArgument(id, "Id (Group) or name (User)");
            IdentityType identityType = this.createIdentityTypeFromId(id);
            return this.getSupportedAttributeNames(identityType);
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    @Override
    public Map<String, Attribute> getAttributes(IdentityType identityType) throws IdentityException {
        try {
            Map<String, Attribute> attributes;
            this.checkNotNullArgument(identityType, "IdentityType");
            if (this.cache != null && (attributes = this.cache.getAttributes(this.cacheNS, identityType.getKey())) != null) {
                return attributes;
            }
            Map<String, IdentityObjectAttribute> map = this.getRepository().getAttributes(this.getInvocationContext(), this.createIdentityObject(identityType));
            HashMap<String, Attribute> newMap = new HashMap<String, Attribute>();
            for (Map.Entry<String, IdentityObjectAttribute> entry : map.entrySet()) {
                newMap.put(entry.getKey(), this.convertAttribute(entry.getValue()));
            }
            if (this.cache != null) {
                this.cache.putAttributes(this.cacheNS, identityType.getKey(), newMap);
            }
            return newMap;
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    @Override
    public Map<String, Attribute> getAttributes(String id) throws IdentityException {
        try {
            this.checkNotNullArgument(id, "Id (Group) or name (User)");
            IdentityType identityType = this.createIdentityTypeFromId(id);
            return this.getAttributes(identityType);
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    @Override
    public void updateAttributes(IdentityType identity, Attribute[] attributes) throws IdentityException {
        try {
            this.checkNotNullArgument(identity, "IdentityType");
            this.checkNotNullArgument(attributes, "Attributes");
            this.preAttributesUpdate(identity, attributes);
            this.getRepository().updateAttributes(this.getInvocationContext(), this.createIdentityObject(identity), this.convertAttributes(attributes));
            if (this.cache != null) {
                this.cache.invalidateAttributes(this.cacheNS, identity.getKey());
                this.getAttributes(identity);
            }
            this.postAttributesUpdate(identity, attributes);
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    @Override
    public void updateAttributes(String id, Attribute[] attributes) throws IdentityException {
        try {
            this.checkNotNullArgument(id, "Id (Group) or name (User)");
            this.checkNotNullArgument(attributes, "Attributes");
            IdentityType identityType = this.createIdentityTypeFromId(id);
            this.updateAttributes(identityType, attributes);
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    @Override
    public Attribute getAttribute(IdentityType identityType, String attributeName) throws IdentityException {
        try {
            this.checkNotNullArgument(identityType, "IdentityType");
            this.checkNotNullArgument(attributeName, "Attribute name");
            return this.getAttributes(identityType).get(attributeName);
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    @Override
    public Attribute getAttribute(String id, String attributeName) throws IdentityException {
        try {
            this.checkNotNullArgument(id, "Id (Group) or name (User)");
            this.checkNotNullArgument(attributeName, "Attribute name");
            IdentityType identityType = this.createIdentityTypeFromId(id);
            return this.getAttribute(identityType, attributeName);
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    @Override
    public void addAttribute(IdentityType identityType, String attributeName, Object[] values) throws IdentityException {
        try {
            this.checkNotNullArgument(identityType, "IdentityType");
            this.checkNotNullArgument(attributeName, "Attribute name");
            this.checkNotNullArgument(values, "Attribute values");
            Attribute[] attrs = new Attribute[]{new SimpleAttribute(attributeName, values)};
            this.addAttributes(identityType, attrs);
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    @Override
    public void addAttributes(String id, Attribute[] attributes) throws IdentityException {
        try {
            this.checkNotNullArgument(id, "Id (Group) or name (User)");
            this.checkNotNullArgument(attributes, "Attributes");
            IdentityType identityType = this.createIdentityTypeFromId(id);
            this.addAttributes(identityType, attributes);
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    @Override
    public void addAttribute(IdentityType identityType, String attributeName, Object value) throws IdentityException {
        try {
            this.checkNotNullArgument(identityType, "IdentityType");
            this.checkNotNullArgument(attributeName, "Attribute name");
            this.checkNotNullArgument(value, "Attribute value");
            Attribute[] attrs = new Attribute[]{new SimpleAttribute(attributeName, value)};
            this.addAttributes(identityType, attrs);
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    @Override
    public void addAttribute(String id, String attributeName, Object[] values) throws IdentityException {
        try {
            this.checkNotNullArgument(id, "Id (Group) or name (User)");
            this.checkNotNullArgument(attributeName, "Attribute name");
            this.checkNotNullArgument(values, "Attribute values");
            IdentityType identityType = this.createIdentityTypeFromId(id);
            this.addAttribute(identityType, attributeName, values);
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    @Override
    public void addAttribute(String id, String attributeName, Object value) throws IdentityException {
        try {
            this.checkNotNullArgument(id, "Id (Group) or name (User)");
            this.checkNotNullArgument(attributeName, "Attribute name");
            this.checkNotNullArgument(value, "Attribute value");
            IdentityType identityType = this.createIdentityTypeFromId(id);
            this.addAttribute(identityType, attributeName, value);
        }
        catch (IdentityException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addAttributes(IdentityType identityType, Attribute[] attributes) throws IdentityException {
        try {
            this.checkNotNullArgument(identityType, "IdentityType");
            this.checkNotNullArgument(attributes, "Attributes");
            this.preAttributesAdd(identityType, attributes);
            this.getRepository().addAttributes(this.getInvocationContext(), this.createIdentityObject(identityType), this.convertAttributes(attributes));
            if (this.cache != null) {
                this.cache.invalidateAttributes(this.cacheNS, identityType.getKey());
                this.getAttributes(identityType);
            }
            this.postAttributesAdd(identityType, attributes);
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    @Override
    public void removeAttributes(IdentityType identityType, String[] attributeNames) throws IdentityException {
        try {
            this.checkNotNullArgument(identityType, "IdentityType");
            this.checkNotNullArgument(attributeNames, "Attribute names");
            this.preAttributesRemove(identityType, attributeNames);
            this.getRepository().removeAttributes(this.getInvocationContext(), this.createIdentityObject(identityType), attributeNames);
            if (this.cache != null) {
                this.cache.invalidateAttributes(this.cacheNS, identityType.getKey());
                this.getAttributes(identityType);
            }
            this.postAttributesRemove(identityType, attributeNames);
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    @Override
    public void removeAttributes(String id, String[] attributeNames) throws IdentityException {
        try {
            this.checkNotNullArgument(id, "Id (Group) or name (User)");
            this.checkNotNullArgument(attributeNames, "Attribute names");
            IdentityType identityType = this.createIdentityTypeFromId(id);
            this.removeAttributes(identityType, attributeNames);
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    @Override
    public boolean hasPassword(User user) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        return this.getRepository().getSupportedFeatures().isCredentialSupported(this.createIdentityObject(user).getIdentityType(), PasswordCredential.TYPE);
    }

    @Override
    public boolean validatePassword(User user, String password) throws IdentityException {
        try {
            this.checkNotNullArgument(user, "User");
            this.checkNotNullArgument(password, "Password");
            return this.getRepository().validateCredential(this.getInvocationContext(), this.createIdentityObject(user), new PasswordCredential(password, this.getCredentialEncoder(), user.getKey()));
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    @Override
    public void updatePassword(User user, String password) throws IdentityException {
        try {
            this.checkNotNullArgument(user, "User");
            this.checkNotNullArgument(password, "Password");
            PasswordCredential passwordCredential = new PasswordCredential(password, this.getCredentialEncoder(), user.getKey());
            this.preCredentialUpdate(user, passwordCredential);
            this.getRepository().updateCredential(this.getInvocationContext(), this.createIdentityObject(user), passwordCredential);
            this.postCredentialUpdate(user, passwordCredential);
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    @Override
    public boolean isCredentialTypeSupported(CredentialType credentialType) throws IdentityException {
        this.checkNotNullArgument(credentialType, "CredentialType");
        return this.getRepository().getSupportedFeatures().isCredentialSupported(this.getUserObjectType(), new SimpleCredentialType(credentialType.getName()));
    }

    @Override
    public boolean validateCredentials(User user, Credential[] credentials) throws IdentityException {
        try {
            this.checkNotNullArgument(user, "User");
            this.checkNotNullArgument(credentials, "Credentials");
            for (Credential credential : credentials) {
                IdentityObjectCredential ioc = null;
                if (!(credential instanceof IdentityObjectCredential)) {
                    throw new IdentityException("Unsupported Credential implementation: " + credential.getClass());
                }
                ioc = (IdentityObjectCredential)((Object)credential);
                if (this.getRepository().validateCredential(this.getInvocationContext(), this.createIdentityObject(user), ioc)) continue;
                return false;
            }
            return true;
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    @Override
    public void updateCredential(User user, Credential credential) throws IdentityException {
        try {
            this.checkNotNullArgument(user, "User");
            this.checkNotNullArgument(credential, "Credential");
            if (!(credential instanceof IdentityObjectCredential)) {
                throw new IdentityException("Unsupported Credential implementation: " + credential.getClass());
            }
            this.preCredentialUpdate(user, credential);
            this.getRepository().updateCredential(this.getInvocationContext(), this.createIdentityObject(user), (IdentityObjectCredential)((Object)credential));
            this.postCredentialUpdate(user, credential);
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    @Override
    public User findUserByUniqueAttribute(String attributeName, Object value) throws IdentityException {
        try {
            this.checkNotNullArgument(attributeName, "Attribute name");
            this.checkNotNullArgument(value, "Attribute value");
            IdentityObject io = this.getRepository().findIdentityObjectByUniqueAttribute(this.getInvocationContext(), this.getUserObjectType(), new SimpleAttribute(attributeName, value));
            if (io == null) {
                return null;
            }
            return this.createUser(io);
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    @Override
    public Group findGroupByUniqueAttribute(String groupType, String attributeName, Object value) throws IdentityException {
        try {
            this.checkNotNullArgument(groupType, "GroupType");
            this.checkNotNullArgument(attributeName, "Attribute name");
            this.checkNotNullArgument(value, "Attribute value");
            IdentityObject io = this.getRepository().findIdentityObjectByUniqueAttribute(this.getInvocationContext(), this.getIdentityObjectType(groupType), new SimpleAttribute(attributeName, value));
            if (io == null) {
                return null;
            }
            return this.createGroup(io);
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }
}

