/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DataLocality;
import org.infinispan.distribution.L1Manager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.distribution.BaseDistributionInterceptor;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.InfinispanCollections;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TxDistributionInterceptor
extends BaseDistributionInterceptor {
    private static Log log = LogFactory.getLog(TxDistributionInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private boolean isPessimisticCache;
    private boolean useClusteredWriteSkewCheck;
    private L1Manager l1Manager;
    private boolean isL1CacheEnabled;
    private static final BaseDistributionInterceptor.RecipientGenerator CLEAR_COMMAND_GENERATOR = new BaseDistributionInterceptor.RecipientGenerator(){

        @Override
        public List<Address> generateRecipients() {
            return null;
        }

        @Override
        public Collection<Object> getKeys() {
            return InfinispanCollections.emptySet();
        }
    };

    @Inject
    public void init(L1Manager l1Manager) {
        this.l1Manager = l1Manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        try {
            Object object = super.visitReplaceCommand(ctx, command);
            return object;
        }
        finally {
            boolean ignorePreviousValues = this.ignorePreviousValueOnBackup(command, ctx);
            command.setIgnorePreviousValue(ignorePreviousValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        try {
            Object object = super.visitRemoveCommand(ctx, command);
            return object;
        }
        finally {
            boolean ignorePreviousValues = this.ignorePreviousValueOnBackup(command, ctx);
            command.setIgnorePreviousValue(ignorePreviousValues);
        }
    }

    @Override
    protected boolean ignorePreviousValueOnBackup(WriteCommand command, InvocationContext ctx) {
        return super.ignorePreviousValueOnBackup(command, ctx) && this.cacheConfiguration.transaction().lockingMode() == LockingMode.OPTIMISTIC && !this.useClusteredWriteSkewCheck;
    }

    @Start
    public void start() {
        this.isPessimisticCache = this.cacheConfiguration.transaction().lockingMode() == LockingMode.PESSIMISTIC;
        this.isL1CacheEnabled = this.cacheConfiguration.clustering().l1().enabled();
        this.useClusteredWriteSkewCheck = !this.isPessimisticCache && this.cacheConfiguration.versioning().enabled() && this.cacheConfiguration.locking().writeSkewCheck();
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        BaseDistributionInterceptor.SingleKeyRecipientGenerator skrg = new BaseDistributionInterceptor.SingleKeyRecipientGenerator(command.getKey());
        Object returnValue = this.handleWriteCommand(ctx, command, skrg, command.hasFlag(Flag.PUT_FOR_STATE_TRANSFER), false);
        if (this.ignorePreviousValueOnBackup(command, ctx)) {
            command.setPutIfAbsent(false);
        }
        if (this.isL1CacheEnabled && !ctx.isOriginLocal() && !skrg.generateRecipients().contains(ctx.getOrigin())) {
            this.l1Manager.addRequestor(command.getKey(), ctx.getOrigin());
        }
        return returnValue;
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, CLEAR_COMMAND_GENERATOR, false, true);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        try {
            Object returnValue = this.invokeNextInterceptor(ctx, command);
            if (returnValue != null && this.isL1CacheEnabled && !ctx.isOriginLocal()) {
                this.l1Manager.addRequestor(command.getKey(), ctx.getOrigin());
            }
            if (returnValue == null) {
                Object key = command.getKey();
                if (this.needsRemoteGet(ctx, command)) {
                    returnValue = this.remoteGetAndStoreInL1(ctx, key, false, command);
                }
                if (returnValue == null) {
                    returnValue = this.localGet(ctx, key, false, command);
                }
            }
            return returnValue;
        }
        catch (SuspectException e) {
            return this.visitGetKeyValueCommand(ctx, command);
        }
    }

    private void lockAndWrap(InvocationContext ctx, Object key, InternalCacheEntry ice, FlagAffectedCommand command) throws InterruptedException {
        boolean skipLocking = this.hasSkipLocking(command);
        long lockTimeout = this.getLockAcquisitionTimeout(command, skipLocking);
        this.lockManager.acquireLock(ctx, key, lockTimeout, skipLocking);
        this.entryFactory.wrapEntryForPut(ctx, key, ice, false, command);
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            Collection<Address> affectedNodes = this.dm.getAffectedNodes(command.getKeys());
            ((LocalTxInvocationContext)ctx).remoteLocksAcquired(affectedNodes);
            log.tracef("Registered remote locks acquired %s", affectedNodes);
            this.rpcManager.invokeRemotely(affectedNodes, (ReplicableCommand)command, true, true);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (this.shouldInvokeRemoteTxCommand(ctx)) {
            Future<?> f = this.flushL1Caches(ctx);
            this.sendCommitCommand(ctx, command);
            this.blockOnL1FutureIfNeeded(f);
        } else if (this.isL1CacheEnabled && !ctx.isOriginLocal() && !ctx.getLockedKeys().isEmpty()) {
            this.blockOnL1FutureIfNeeded(this.flushL1Caches(ctx));
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private void blockOnL1FutureIfNeeded(Future<?> f) {
        block3: {
            if (f != null && this.cacheConfiguration.transaction().syncCommitPhase()) {
                try {
                    f.get();
                }
                catch (Exception e) {
                    if (e.getCause() instanceof SuspectException) break block3;
                    this.getLog().failedInvalidatingRemoteCache(e);
                }
            }
        }
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        if (this.shouldInvokeRemoteTxCommand(ctx)) {
            boolean affectsAllNodes;
            if (command.isOnePhaseCommit()) {
                this.flushL1Caches(ctx);
            }
            Collection<Address> recipients = (affectsAllNodes = ctx.getCacheTransaction().hasModification(ClearCommand.class)) ? this.dm.getWriteConsistentHash().getMembers() : this.dm.getAffectedNodes(ctx.getAffectedKeys());
            this.prepareOnAffectedNodes(ctx, command, recipients, this.defaultSynchronous);
            ((LocalTxInvocationContext)ctx).remoteLocksAcquired(recipients);
        } else if (this.isL1CacheEnabled && command.isOnePhaseCommit() && !ctx.isOriginLocal() && !ctx.getLockedKeys().isEmpty()) {
            this.flushL1Caches(ctx);
        }
        return retVal;
    }

    protected void prepareOnAffectedNodes(TxInvocationContext ctx, PrepareCommand command, Collection<Address> recipients, boolean sync) {
        this.rpcManager.invokeRemotely(recipients, command, sync);
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (this.shouldInvokeRemoteTxCommand(ctx)) {
            this.rpcManager.invokeRemotely(this.getCommitNodes(ctx), (ReplicableCommand)command, this.cacheConfiguration.transaction().syncRollbackPhase(), true);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private Collection<Address> getCommitNodes(TxInvocationContext ctx) {
        LocalTransaction localTx = (LocalTransaction)ctx.getCacheTransaction();
        Collection<Address> affectedNodes = this.dm.getAffectedNodes(ctx.getAffectedKeys());
        List<Address> members = this.dm.getConsistentHash().getMembers();
        return localTx.getCommitNodes(affectedNodes, this.rpcManager.getTopologyId(), members);
    }

    protected void sendCommitCommand(TxInvocationContext ctx, CommitCommand command) throws TimeoutException, InterruptedException {
        Collection<Address> recipients = this.getCommitNodes(ctx);
        boolean syncCommitPhase = this.cacheConfiguration.transaction().syncCommitPhase();
        this.rpcManager.invokeRemotely(recipients, (ReplicableCommand)command, syncCommitPhase, true);
    }

    private boolean shouldFetchRemoteValuesForWriteSkewCheck(InvocationContext ctx, WriteCommand cmd) {
        if (this.useClusteredWriteSkewCheck && ctx.isInTxScope() && this.dm.isRehashInProgress()) {
            for (Object key : cmd.getAffectedKeys()) {
                if (!this.dm.isAffectedByRehash(key) || this.dataContainer.containsKey(key)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected Object handleWriteCommand(InvocationContext ctx, WriteCommand command, BaseDistributionInterceptor.RecipientGenerator recipientGenerator, boolean skipRemoteGet, boolean skipL1Invalidation) throws Throwable {
        if (ctx.isOriginLocal() && !skipRemoteGet || command.isConditional() || this.shouldFetchRemoteValuesForWriteSkewCheck(ctx, command)) {
            this.remoteGetBeforeWrite(ctx, command, recipientGenerator);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private Object localGet(InvocationContext ctx, Object key, boolean isWrite, FlagAffectedCommand command) throws Throwable {
        InternalCacheEntry ice = this.dataContainer.get(key);
        if (ice != null) {
            if (isWrite && this.isPessimisticCache && ctx.isInTxScope()) {
                ((TxInvocationContext)ctx).addAffectedKey(key);
            }
            if (!ctx.replaceValue(key, ice.getValue())) {
                if (isWrite) {
                    this.lockAndWrap(ctx, key, ice, command);
                } else {
                    ctx.putLookedUpEntry(key, ice);
                }
            }
            return command instanceof GetCacheEntryCommand ? ice : ice.getValue();
        }
        return null;
    }

    private void remoteGetBeforeWrite(InvocationContext ctx, WriteCommand command, BaseDistributionInterceptor.KeyGenerator keygen) throws Throwable {
        if (this.isNeedReliableReturnValues(command) || command.isConditional() || this.shouldFetchRemoteValuesForWriteSkewCheck(ctx, command)) {
            for (Object k : keygen.getKeys()) {
                Object returnValue = this.remoteGetAndStoreInL1(ctx, k, true, command);
                if (returnValue != null) continue;
                this.localGet(ctx, k, true, command);
            }
        }
    }

    private boolean isNotInL1(Object key) {
        return !this.isL1CacheEnabled || !this.dataContainer.containsKey(key);
    }

    private Object remoteGetAndStoreInL1(InvocationContext ctx, Object key, boolean isWrite, FlagAffectedCommand command) throws Throwable {
        DataLocality locality;
        DataLocality dataLocality = locality = this.dm.getReadConsistentHash().isKeyLocalToNode(this.rpcManager.getAddress(), key) ? DataLocality.LOCAL : DataLocality.NOT_LOCAL;
        if (ctx.isOriginLocal() && !locality.isLocal() && this.isNotInL1(key) || this.dm.isAffectedByRehash(key) && !this.dataContainer.containsKey(key)) {
            if (trace) {
                log.tracef("Doing a remote get for key %s", key);
            }
            boolean acquireRemoteLock = false;
            if (ctx.isInTxScope()) {
                TxInvocationContext txContext = (TxInvocationContext)ctx;
                acquireRemoteLock = isWrite && this.isPessimisticCache && !txContext.getAffectedKeys().contains(key);
            }
            InternalCacheEntry ice = this.retrieveFromRemoteSource(key, ctx, acquireRemoteLock, command);
            if (acquireRemoteLock) {
                ((TxInvocationContext)ctx).addAffectedKey(key);
            }
            if (ice != null) {
                if (this.useClusteredWriteSkewCheck && ctx.isInTxScope()) {
                    ((TxInvocationContext)ctx).getCacheTransaction().putLookedUpRemoteVersion(key, ice.getVersion());
                }
                if (this.isL1CacheEnabled) {
                    List<Address> writeOwners;
                    List<Address> readOwners = this.dm.getReadConsistentHash().locateOwners(key);
                    if (!((Object)readOwners).equals(writeOwners = this.dm.getWriteConsistentHash().locateOwners(key))) {
                        if (trace) {
                            log.tracef("State transfer in progress for key %s, not storing to L1", new Object[0]);
                        }
                        return ice.getValue();
                    }
                    if (trace) {
                        log.tracef("Caching remotely retrieved entry for key %s in L1", key);
                    }
                    try {
                        long l1Lifespan = this.cacheConfiguration.clustering().l1().lifespan();
                        long lifespan = ice.getLifespan() < 0L ? l1Lifespan : Math.min(ice.getLifespan(), l1Lifespan);
                        PutKeyValueCommand put = this.cf.buildPutKeyValueCommand(ice.getKey(), ice.getValue(), lifespan, -1L, command.getFlags());
                        this.lockAndWrap(ctx, key, ice, command);
                        this.invokeNextInterceptor(ctx, put);
                    }
                    catch (Exception e) {
                        log.infof("Unable to store entry %s in L1 cache", key);
                        log.debug("Inability to store in L1 caused by", e);
                    }
                } else if (!ctx.replaceValue(key, ice.getValue())) {
                    if (isWrite) {
                        this.lockAndWrap(ctx, key, ice, command);
                    } else {
                        ctx.putLookedUpEntry(key, ice);
                    }
                }
                return ice.getValue();
            }
        } else if (trace) {
            log.tracef("Not doing a remote get for key %s since entry is mapped to current node (%s), or is in L1.  Owners are %s", key, this.rpcManager.getAddress(), this.dm.locate(key));
        }
        return null;
    }

    protected Future<?> flushL1Caches(InvocationContext ctx) {
        return this.isL1CacheEnabled ? this.l1Manager.flushCacheWithSimpleFuture(ctx.getLockedKeys(), null, ctx.getOrigin(), true) : null;
    }
}

