/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;

public class DocumentEvent {
    public IDocument fDocument;
    public int fOffset;
    public int fLength;
    public String fText;
    protected long fModificationStamp;

    public DocumentEvent(IDocument doc, int offset, int length, String text) {
        Assert.isNotNull(doc);
        Assert.isTrue(offset >= 0);
        Assert.isTrue(length >= 0);
        this.fDocument = doc;
        this.fOffset = offset;
        this.fLength = length;
        this.fText = text;
        this.fModificationStamp = this.fDocument instanceof IDocumentExtension4 ? ((IDocumentExtension4)((Object)this.fDocument)).getModificationStamp() : -1L;
    }

    public DocumentEvent() {
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getLength() {
        return this.fLength;
    }

    public String getText() {
        return this.fText;
    }

    public long getModificationStamp() {
        return this.fModificationStamp;
    }
}

