/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.store.ldap.api;

import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentitySessionFactory;
import org.picketlink.idm.impl.api.APITestContext;
import org.picketlink.idm.impl.configuration.IdentityConfigurationImpl;
import org.picketlink.idm.test.support.IdentityTestPOJO;
import org.picketlink.idm.test.support.hibernate.HibernateTestPOJO;
import org.picketlink.idm.test.support.ldap.LDAPTestPOJO;

public class TwoLDAPTestCase
extends IdentityTestPOJO
implements APITestContext {
    IdentitySessionFactory identitySessionFactory;
    HibernateTestPOJO hibernateTest = new HibernateTestPOJO();
    LDAPTestPOJO ldapTestPOJO = new LDAPTestPOJO();

    public void setUp() throws Exception {
        super.start();
        this.hibernateTest.start();
        this.ldapTestPOJO.start();
        if (!this.ldapTestPOJO.getDirectoryName().equals(this.ldapTestPOJO.EMBEDDED_OPEN_DS_DIRECTORY_NAME)) {
            return;
        }
        this.setRealmName("DB_2LDAP_REALM");
        this.ldapTestPOJO.populateLDIF("ldap/initial-opends.ldif");
        this.identityConfig = "two-ldap-config.xml";
        this.identitySessionFactory = new IdentityConfigurationImpl().configure(this.getIdentityConfig()).buildIdentitySessionFactory();
    }

    public void tearDown() throws Exception {
        super.stop();
        this.ldapTestPOJO.stop();
        this.hibernateTest.stop();
    }

    public IdentitySessionFactory getIdentitySessionFactory() {
        return this.identitySessionFactory;
    }

    public void testWhatIsAccesible() throws Exception {
        if (!this.ldapTestPOJO.getDirectoryName().equals(this.ldapTestPOJO.EMBEDDED_OPEN_DS_DIRECTORY_NAME)) {
            return;
        }
        IdentitySession session = this.identitySessionFactory.createIdentitySession(this.getRealmName());
        this.begin();
        TwoLDAPTestCase.assertEquals((String)"User count", (int)14, (int)session.getPersistenceManager().getUserCount());
        TwoLDAPTestCase.assertNotNull((Object)session.getPersistenceManager().findUser("jduke"));
        TwoLDAPTestCase.assertNotNull((Object)session.getPersistenceManager().findUser("jduke1"));
        TwoLDAPTestCase.assertNotNull((Object)session.getPersistenceManager().findUser("jduke2"));
        TwoLDAPTestCase.assertNotNull((Object)session.getPersistenceManager().findUser("jduke3"));
        TwoLDAPTestCase.assertNotNull((Object)session.getPersistenceManager().findUser("jduke4"));
        TwoLDAPTestCase.assertNotNull((Object)session.getPersistenceManager().findUser("jduke5"));
        TwoLDAPTestCase.assertNotNull((Object)session.getPersistenceManager().findUser("jduke6"));
        TwoLDAPTestCase.assertNotNull((Object)session.getPersistenceManager().findUser("jduke7"));
        TwoLDAPTestCase.assertNotNull((Object)session.getPersistenceManager().findUser("jduke8"));
        TwoLDAPTestCase.assertNotNull((Object)session.getPersistenceManager().findUser("jduke9"));
        TwoLDAPTestCase.assertNotNull((Object)session.getPersistenceManager().findUser("admin"));
        TwoLDAPTestCase.assertNotNull((Object)session.getPersistenceManager().findUser("admin2"));
        TwoLDAPTestCase.assertNotNull((Object)session.getPersistenceManager().findUser("user"));
        TwoLDAPTestCase.assertNotNull((Object)session.getPersistenceManager().findUser("user2"));
        TwoLDAPTestCase.assertNull((Object)session.getPersistenceManager().findUser("user112"));
        TwoLDAPTestCase.assertNotNull((Object)session.getPersistenceManager().findGroup("employee", "internal_role"));
        TwoLDAPTestCase.assertNotNull((Object)session.getPersistenceManager().findGroup("echo", "internal_role"));
        TwoLDAPTestCase.assertNotNull((Object)session.getPersistenceManager().findGroup("foo", "internal_ou"));
        TwoLDAPTestCase.assertNotNull((Object)session.getPersistenceManager().findGroup("bar", "internal_ou"));
        TwoLDAPTestCase.assertNotNull((Object)session.getPersistenceManager().findGroup("customer", "customers_role"));
        TwoLDAPTestCase.assertNotNull((Object)session.getPersistenceManager().findGroup("partner", "customers_role"));
        TwoLDAPTestCase.assertNotNull((Object)session.getPersistenceManager().findGroup("customer_foo", "customers_ou"));
        TwoLDAPTestCase.assertNotNull((Object)session.getPersistenceManager().findGroup("customer_bar", "customers_ou"));
        this.commit();
    }

    public void begin() {
        this.hibernateTest.begin();
    }

    public void commit() {
        this.hibernateTest.commit();
    }

    public void overrideFromProperties() throws Exception {
    }
}

