/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.model;

import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.picketlink.as.subsystem.model.ModelElement;
import org.picketlink.identity.federation.core.config.AuthPropertyType;
import org.picketlink.identity.federation.core.config.IDPConfiguration;
import org.picketlink.identity.federation.core.config.KeyProviderType;
import org.picketlink.identity.federation.core.config.SPConfiguration;
import org.picketlink.identity.federation.core.config.STSConfiguration;

public class ModelUtils {
    public static String getFederationAlias(ModelNode fromModel) {
        return ((Property)fromModel.get("address").asPropertyList().get(1)).getValue().asString();
    }

    public static final STSConfiguration toSTSConfig(ModelNode fromModel) {
        String alias = PathAddress.pathAddress((ModelNode)fromModel.get("address")).getLastElement().getValue();
        String securityDomain = fromModel.get(ModelElement.COMMON_SECURITY_DOMAIN.getName()).asString();
        STSConfiguration stsType = new STSConfiguration();
        stsType.setAlias(alias);
        stsType.setSecurityDomain(securityDomain);
        return stsType;
    }

    public static final STSConfiguration toSAMLConfig(ModelNode fromModel) {
        int tokenTimeout = fromModel.get(ModelElement.SAML_TOKEN_TIMEOUT.getName()).asInt();
        int clockSkew = fromModel.get(ModelElement.SAML_CLOCK_SKEW.getName()).asInt();
        STSConfiguration stsType = new STSConfiguration();
        stsType.setTokenTimeout(tokenTimeout);
        stsType.setClockSkew(clockSkew);
        return stsType;
    }

    public static SPConfiguration toSPConfig(ModelNode fromModel) {
        ModelNode logoutPage;
        ModelNode errorPage;
        ModelNode strictPostBinding;
        SPConfiguration spType = new SPConfiguration();
        String alias = fromModel.get(ModelElement.COMMON_ALIAS.getName()).asString();
        spType.setAlias(alias);
        String url = fromModel.get(ModelElement.COMMON_URL.getName()).asString();
        spType.setServiceURL(url);
        String securityDomain = fromModel.get(ModelElement.COMMON_SECURITY_DOMAIN.getName()).asString();
        spType.setSecurityDomain(securityDomain);
        boolean postBinding = fromModel.get(ModelElement.SERVICE_PROVIDER_POST_BINDING.getName()).asBoolean();
        if (postBinding) {
            spType.setBindingType("POST");
        } else {
            spType.setBindingType("REDIRECT");
        }
        spType.setPostBinding(postBinding);
        ModelNode supportsSignatures = fromModel.get(ModelElement.COMMON_SUPPORTS_SIGNATURES.getName());
        if (supportsSignatures.isDefined()) {
            spType.setSupportsSignature(supportsSignatures.asBoolean());
        }
        if ((strictPostBinding = fromModel.get(ModelElement.COMMON_STRICT_POST_BINDING.getName())).isDefined()) {
            spType.setIdpUsesPostBinding(strictPostBinding.asBoolean());
        }
        if ((errorPage = fromModel.get(ModelElement.SERVICE_PROVIDER_ERROR_PAGE.getName())).isDefined()) {
            spType.setErrorPage(errorPage.asString());
        }
        if ((logoutPage = fromModel.get(ModelElement.SERVICE_PROVIDER_LOGOUT_PAGE.getName())).isDefined()) {
            spType.setLogOutPage(logoutPage.asString());
        }
        return spType;
    }

    public static IDPConfiguration toIDPConfig(ModelNode fromModel) {
        ModelNode roleGenerator;
        ModelNode strictPostBinding;
        ModelNode encrypt;
        IDPConfiguration idpType = new IDPConfiguration();
        String alias = fromModel.get(ModelElement.COMMON_ALIAS.getName()).asString();
        idpType.setAlias(alias);
        String url = fromModel.get(ModelElement.COMMON_URL.getName()).asString();
        idpType.setIdentityURL(url);
        ModelNode supportsSignatures = fromModel.get(ModelElement.COMMON_SUPPORTS_SIGNATURES.getName());
        if (supportsSignatures.isDefined()) {
            idpType.setSupportsSignature(supportsSignatures.asBoolean());
        }
        if ((encrypt = fromModel.get(ModelElement.IDENTITY_PROVIDER_ENCRYPT.getName())).isDefined()) {
            idpType.setEncrypt(encrypt.asBoolean());
        }
        if ((strictPostBinding = fromModel.get(ModelElement.COMMON_STRICT_POST_BINDING.getName())).isDefined()) {
            idpType.setStrictPostBinding(strictPostBinding.asBoolean());
        }
        String securityDomain = fromModel.get(ModelElement.COMMON_SECURITY_DOMAIN.getName()).asString();
        idpType.setSecurityDomain(securityDomain);
        ModelNode attributeManager = fromModel.get(ModelElement.IDENTITY_PROVIDER_ATTRIBUTE_MANAGER.getName());
        if (attributeManager.isDefined()) {
            idpType.setAttributeManager(attributeManager.asString());
        }
        if ((roleGenerator = fromModel.get(ModelElement.IDENTITY_PROVIDER_ROLE_GENERATOR.getName())).isDefined()) {
            idpType.setRoleGenerator(roleGenerator.asString());
        }
        return idpType;
    }

    public static KeyProviderType toKeyProviderType(ModelNode model) {
        KeyProviderType keyProviderType = new KeyProviderType();
        keyProviderType.setSigningAlias(model.get(ModelElement.KEY_STORE_SIGN_KEY_ALIAS.getName()).asString());
        AuthPropertyType keyStoreURL = new AuthPropertyType();
        keyStoreURL.setKey("KeyStoreURL");
        keyStoreURL.setValue(model.get(ModelElement.COMMON_URL.getName()).asString());
        keyProviderType.add(keyStoreURL);
        AuthPropertyType keyStorePass = new AuthPropertyType();
        keyStorePass.setKey("KeyStorePass");
        keyStorePass.setValue(model.get(ModelElement.KEY_STORE_PASSWD.getName()).asString());
        keyProviderType.add(keyStorePass);
        AuthPropertyType signingKeyPass = new AuthPropertyType();
        signingKeyPass.setKey("SigningKeyPass");
        signingKeyPass.setValue(model.get(ModelElement.KEY_STORE_SIGN_KEY_PASSWD.getName()).asString());
        keyProviderType.add(signingKeyPass);
        AuthPropertyType signingKeyAlias = new AuthPropertyType();
        signingKeyAlias.setKey("SigningKeyAlias");
        signingKeyAlias.setValue(model.get(ModelElement.KEY_STORE_SIGN_KEY_ALIAS.getName()).asString());
        keyProviderType.add(signingKeyAlias);
        return keyProviderType;
    }
}

