/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.jboss.as.console.client.Console;
import org.jboss.as.console.client.widgets.ContentDescription;
import org.jboss.ballroom.client.widgets.forms.Form;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.TextBoxItem;
import org.jboss.ballroom.client.widgets.tools.ToolButton;
import org.jboss.ballroom.client.widgets.tools.ToolStrip;
import org.jboss.ballroom.client.widgets.window.Feedback;
import org.picketlink.as.console.client.i18n.PicketLinkUIConstants;
import org.picketlink.as.console.client.shared.subsys.model.Key;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.KeyTable;

public class KeyEditor {
    private Form<Key> keyForm;
    private KeyTable keyTable;
    private FederationPresenter presenter;
    private ToolButton removeBtn;
    private ToolButton addBtn;
    private PicketLinkUIConstants uiConstants;
    private VerticalPanel keyLayout;

    public KeyEditor(FederationPresenter presenter, PicketLinkUIConstants uiConstants) {
        this.presenter = presenter;
        this.uiConstants = uiConstants;
    }

    public Widget asWidget() {
        this.keyLayout = new VerticalPanel();
        this.keyLayout.setStyleName("fill-layout-width");
        this.addForm(this.keyLayout);
        this.addActions(this.keyLayout);
        this.addTable(this.keyLayout);
        return this.keyLayout;
    }

    private void addTable(VerticalPanel detailPanel) {
        detailPanel.add(this.getKeyTable().asWidget());
    }

    private void addActions(VerticalPanel header) {
        ToolStrip tools = new ToolStrip();
        this.addBtn = new ToolButton(Console.CONSTANTS.common_label_add());
        this.addBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Key newKey = (Key)KeyEditor.this.keyForm.getUpdatedEntity();
                if (newKey != null && !newKey.getName().trim().isEmpty()) {
                    KeyEditor.this.presenter.getFederationManager().onCreateKey(KeyEditor.this.presenter.getCurrentFederation(), newKey);
                    KeyEditor.this.getKeyTable().getDataProvider().getList().add(newKey);
                }
                KeyEditor.this.keyForm.clearValues();
            }
        });
        tools.addToolButtonRight(this.addBtn);
        this.removeBtn = new ToolButton(Console.CONSTANTS.common_label_delete());
        this.removeBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                final Key removedKey = KeyEditor.this.getKeyTable().getSelectedTrustedDomain();
                Feedback.confirm((String)Console.MESSAGES.deleteTitle(KeyEditor.this.uiConstants.common_label_trustDomain()), (String)Console.MESSAGES.deleteConfirm(removedKey.getName()), (Feedback.ConfirmationHandler)new Feedback.ConfirmationHandler(){

                    public void onConfirmation(boolean isConfirmed) {
                        if (isConfirmed) {
                            KeyEditor.this.presenter.getFederationManager().onRemoveKey(KeyEditor.this.presenter.getCurrentFederation(), removedKey);
                            KeyEditor.this.getKeyTable().getDataProvider().getList().remove(removedKey);
                        }
                    }
                });
                KeyEditor.this.keyForm.clearValues();
            }
        });
        tools.addToolButtonRight(this.removeBtn);
        tools.setStyleName("fill-layout-width");
        header.add((Widget)tools);
        header.add((Widget)new ContentDescription(""));
    }

    private void addForm(VerticalPanel trustDomainsHeader) {
        this.keyForm = new Form(Key.class);
        TextBoxItem name = new TextBoxItem("name", this.uiConstants.common_label_key_alias());
        name.setRequired(true);
        TextBoxItem host = new TextBoxItem("host", this.uiConstants.common_label_key_host());
        host.setRequired(false);
        this.keyForm.setFields(new FormItem[]{name, host});
        trustDomainsHeader.add(this.keyForm.asWidget());
    }

    public KeyTable getKeyTable() {
        if (this.keyTable == null) {
            this.keyTable = new KeyTable();
        }
        return this.keyTable;
    }

    public void setEnabled(boolean enabled) {
        this.keyLayout.setVisible(enabled);
    }
}

